/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleSourceAndHeaderAction
extends TextEditorAction {
    private static ITranslationUnit fgLastPartnerUnit;
    private static ITranslationUnit fgLastSourceUnit;

    public ToggleSourceAndHeaderAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        IWorkingCopy currentUnit = this.getWorkingCopy();
        if (currentUnit == null) {
            return;
        }
        ITranslationUnit partnerUnit = this.computePartnerFile((ITranslationUnit)currentUnit);
        if (partnerUnit != null) {
            fgLastSourceUnit = currentUnit.getOriginalElement();
            fgLastPartnerUnit = partnerUnit;
            try {
                EditorUtility.openInEditor(partnerUnit);
            }
            catch (PartInitException exc) {
                CUIPlugin.getDefault().log(exc.getStatus());
            }
            catch (CModelException exc) {
                CUIPlugin.getDefault().log(exc.getStatus());
            }
        }
    }

    private IWorkingCopy getWorkingCopy() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public void update() {
        this.setEnabled(this.getWorkingCopy() != null);
    }

    private ITranslationUnit computePartnerFile(ITranslationUnit tUnit) {
        ITranslationUnit originalUnit;
        if (fgLastPartnerUnit != null && (originalUnit = tUnit instanceof IWorkingCopy ? ((IWorkingCopy)tUnit).getOriginalElement() : tUnit).getTranslationUnit().equals(fgLastPartnerUnit) && fgLastSourceUnit.exists()) {
            return fgLastSourceUnit;
        }
        ITranslationUnit partnerUnit = this.getPartnerFileFromFilename(tUnit);
        if (partnerUnit == null) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            PartnerFileComputer computer = new PartnerFileComputer();
            ASTProvider.getASTProvider().runOnAST((ICElement)tUnit, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)monitor, computer);
            IPath partnerFileLoation = computer.getPartnerFileLocation();
            if (partnerFileLoation != null && (partnerUnit = (ITranslationUnit)CoreModel.getDefault().create(partnerFileLoation)) == null) {
                partnerUnit = CoreModel.getDefault().createTranslationUnitFrom(tUnit.getCProject(), partnerFileLoation);
            }
        }
        return partnerUnit;
    }

    private ITranslationUnit getPartnerFileFromFilename(ITranslationUnit tUnit) {
        IPath sourceFileLocation = tUnit.getLocation();
        if (sourceFileLocation == null) {
            return null;
        }
        IPath partnerBasePath = sourceFileLocation.removeFileExtension();
        IContentType[] contentTypes = this.getPartnerContentTypes(tUnit.getContentTypeId());
        HashSet<String> extensionsTried = new HashSet<String>();
        int j = 0;
        while (j < contentTypes.length) {
            IContentType contentType = contentTypes[j];
            String[] partnerExtensions = contentType.getFileSpecs(8);
            int i = 0;
            while (i < partnerExtensions.length) {
                String ext = partnerExtensions[i];
                if (extensionsTried.add(ext)) {
                    ITranslationUnit partnerUnit;
                    String partnerFileBasename = partnerBasePath.addFileExtension(ext).lastSegment();
                    IFile partnerFile = null;
                    if (tUnit.getResource() != null) {
                        partnerFile = this.findInContainer(tUnit.getResource().getParent(), partnerFileBasename);
                    }
                    if (partnerFile == null) {
                        partnerFile = this.findInContainer((IContainer)tUnit.getCProject().getProject(), partnerFileBasename);
                    }
                    if (partnerFile != null && (partnerUnit = (ITranslationUnit)CoreModel.getDefault().create(partnerFile)) != null) {
                        return partnerUnit;
                    }
                    if (tUnit.getResource() == null) {
                        IPath partnerFileLoation = partnerBasePath.removeLastSegments(1).append(partnerFileBasename);
                        ITranslationUnit partnerUnit2 = CoreModel.getDefault().createTranslationUnitFrom(tUnit.getCProject(), partnerFileLoation);
                        if (partnerUnit2 != null) {
                            return partnerUnit2;
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    private IFile findInContainer(IContainer container, final String basename) {
        final IFile[] result = new IFile[1];
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (result[0] != null) {
                    return false;
                }
                if (!proxy.isAccessible()) {
                    return false;
                }
                if (proxy.getType() == 1 && proxy.getName().equals(basename)) {
                    result[0] = (IFile)proxy.requestResource();
                    return false;
                }
                return true;
            }
        };
        try {
            container.accept(visitor, 0);
        }
        catch (CoreException coreException) {}
        return result[0];
    }

    private IContentType[] getPartnerContentTypes(String contentTypeId) {
        IContentTypeManager mgr = Platform.getContentTypeManager();
        if (contentTypeId.equals("org.eclipse.cdt.core.cHeader")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cSource"), mgr.getContentType("org.eclipse.cdt.core.cxxSource")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cSource")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cHeader"), mgr.getContentType("org.eclipse.cdt.core.cxxHeader")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cxxHeader")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cxxSource"), mgr.getContentType("org.eclipse.cdt.core.cSource")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cxxSource")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cxxHeader"), mgr.getContentType("org.eclipse.cdt.core.cHeader")};
        }
        return new IContentType[0];
    }

    private static class Counter {
        public int fCount;

        private Counter() {
        }
    }

    private static class PartnerFileComputer
    extends CPPASTVisitor
    implements ASTCache.ASTRunnable {
        private static final int CONFIDENCE_LIMIT = 15;
        private static final int SUSPECT_LIMIT = 15;
        private IIndex fIndex;
        private IPath fFilePath;
        private Map fMap;
        private int fConfidence;
        private int fSuspect;
        private IPath fFavoriteLocation;

        private PartnerFileComputer() {
            this.shouldVisitDeclarators = true;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                this.fIndex = ast.getIndex();
                this.fFilePath = Path.fromOSString((String)ast.getFilePath());
                this.fMap = new HashMap();
                if (this.fIndex != null) {
                    ast.accept((ASTVisitor)this);
                }
            }
            return Status.OK_STATUS;
        }

        public IPath getPartnerFileLocation() {
            return this.fFavoriteLocation;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int visit(IASTDeclarator declarator) {
            if (!(declarator instanceof IASTFunctionDeclarator)) return 1;
            IASTName name = declarator.getName();
            if (name == null) return 1;
            if (declarator.getNestedDeclarator() != null) return 1;
            IBinding binding = name.resolveBinding();
            if (binding == null) return 1;
            if (binding instanceof IProblemBinding) return 1;
            boolean isDefinition = name.isDefinition();
            try {
                IIndexName[] partnerNames = isDefinition ? this.fIndex.findNames(binding, 1) : this.fIndex.findNames(binding, 2);
                if (partnerNames.length == 0) {
                    ++this.fSuspect;
                    if (this.fSuspect == 15) {
                        this.fFavoriteLocation = null;
                        return 2;
                    }
                }
                int i = 0;
                while (true) {
                    IPath partnerFileLocation;
                    if (i >= partnerNames.length) {
                        return 1;
                    }
                    IIndexName partnerName = partnerNames[i];
                    IASTFileLocation partnerLocation = partnerName.getFileLocation();
                    if (partnerLocation != null && !this.fFilePath.equals((Object)(partnerFileLocation = Path.fromOSString((String)partnerLocation.getFileName())))) {
                        this.addPotentialPartnerFileLocation(partnerFileLocation);
                        if (this.fConfidence == 15) {
                            return 2;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                CUIPlugin.getDefault().log(exc.getStatus());
            }
            return 1;
        }

        private void addPotentialPartnerFileLocation(IPath partnerFileLocation) {
            Counter counter = (Counter)this.fMap.get(partnerFileLocation);
            if (counter == null) {
                counter = new Counter();
                this.fMap.put(partnerFileLocation, counter);
            }
            ++counter.fCount;
            if (counter.fCount > this.fConfidence) {
                this.fConfidence = counter.fCount;
                this.fFavoriteLocation = partnerFileLocation;
            }
        }
    }
}

