/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.indexview.IndexNode;
import org.eclipse.cdt.internal.ui.indexview.IndexView;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenDefinitionAction
extends IndexAction {
    public OpenDefinitionAction(IndexView view, TreeViewer viewer) {
        super(view, viewer, CUIPlugin.getResourceString("IndexView.openDefinition.name"));
    }

    private IndexNode getBindingNode() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        if (objs.length == 1 && objs[0] instanceof IndexNode) {
            IndexNode node = (IndexNode)objs[0];
            if (node.fObject instanceof IIndexBinding) {
                return node;
            }
        }
        return null;
    }

    public void run() {
        IndexNode bindingNode = this.getBindingNode();
        if (bindingNode == null) {
            return;
        }
        try {
            IIndex index;
            ICProject cproject = bindingNode.getProject();
            if (cproject != null && !this.openDefinition(cproject, bindingNode, index = CCorePlugin.getIndexManager().getIndex(cproject))) {
                index = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProjects());
                this.openDefinition(cproject, bindingNode, index);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openDefinition(ICProject cproject, IndexNode bindingNode, IIndex index) throws InterruptedException, CoreException, CModelException, PartInitException {
        index.acquireReadLock();
        try {
            block8: {
                block6: {
                    IIndexName[] defs;
                    block7: {
                        block5: {
                            if (this.indexView.getLastWriteAccess(cproject) == CCoreInternals.getPDOMManager().getPDOM(cproject).getLastWriteAccess()) break block5;
                            break block6;
                        }
                        defs = index.findDefinitions((IBinding)((IIndexBinding)bindingNode.fObject));
                        if (defs.length <= 0) break block7;
                        this.showInEditor(defs[0]);
                        break block6;
                    }
                    defs = index.findDeclarations((IBinding)((IIndexBinding)bindingNode.fObject));
                    if (defs.length <= 0) break block8;
                    this.showInEditor(defs[0]);
                }
                Object var5_4 = null;
                index.releaseReadLock();
                return true;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            index.releaseReadLock();
            throw throwable;
        }
        index.releaseReadLock();
        return false;
    }

    private void showInEditor(IIndexName name) throws CModelException, PartInitException, CoreException {
        IEditorPart editor;
        IPath path = IndexLocationFactory.getPath((IIndexFileLocation)name.getFile().getLocation());
        if (path != null && (editor = EditorUtility.openInEditor(path, null)) != null && editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            int nodeOffset = name.getNodeOffset();
            int nodeLength = name.getNodeLength();
            try {
                if (nodeLength == -1) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    nodeOffset = document.getLineOffset(nodeOffset);
                    nodeLength = document.getLineLength(nodeOffset);
                }
                textEditor.selectAndReveal(nodeOffset, nodeLength);
            }
            catch (BadLocationException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
    }

    public boolean valid() {
        return this.getBindingNode() != null;
    }
}

