/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.language.LanguageMappingWidget;
import org.eclipse.cdt.internal.ui.language.WorkspaceContentTypeMappingDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class WorkspaceLanguageMappingWidget
extends LanguageMappingWidget {
    private Map fContentTypeMappings = new TreeMap();

    public Composite createContents(Composite parent, String description) {
        this.fContents = new Composite(parent, 0);
        this.fContents.setLayout((Layout)new GridLayout(2, false));
        if (description != null) {
            this.createHeader(parent, description);
        }
        Composite tableParent = new Composite(this.fContents, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new Table(tableParent, 68098);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.fTable.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = PreferencesMessages.WorkspaceLanguagesPreferencePage_mappingTableTitle;
            }
        });
        this.fTable.setToolTipText(PreferencesMessages.WorkspaceLanguagesPreferencePage_mappingTableTitle);
        TableColumn contentTypeColumn = new TableColumn(this.fTable, 16384);
        contentTypeColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_contentTypeColumn);
        TableColumn languageColumn = new TableColumn(this.fTable, 16384);
        languageColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_languageColumn);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)contentTypeColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        layout.setColumnData((Widget)languageColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        tableParent.setLayout((Layout)layout);
        if (!this.fIsReadOnly) {
            Composite buttons = new Composite(this.fContents, 0);
            buttons.setLayout((Layout)new GridLayout());
            buttons.setLayoutData((Object)new GridData(1, 1, false, false));
            Button addButton = new Button(buttons, 8);
            addButton.setLayoutData((Object)new GridData(4, 1, true, false));
            addButton.setText(PreferencesMessages.ProjectLanguagesPropertyPage_addMappingButton);
            addButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    WorkspaceContentTypeMappingDialog dialog = new WorkspaceContentTypeMappingDialog(WorkspaceLanguageMappingWidget.this.fContents.getShell());
                    dialog.setContentTypeFilter(WorkspaceLanguageMappingWidget.this.fContentTypeMappings.keySet());
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        String contentType = dialog.getContentTypeID();
                        String language = dialog.getLanguageID();
                        WorkspaceLanguageMappingWidget.this.fContentTypeMappings.put(contentType, language);
                        WorkspaceLanguageMappingWidget.this.setChanged(true);
                        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                        WorkspaceLanguageMappingWidget.this.fAffectedContentTypes.add(contentTypeManager.getContentType(contentType));
                        WorkspaceLanguageMappingWidget.this.refreshMappings();
                    }
                }
            });
            Button removeButton = new Button(buttons, 8);
            removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
            removeButton.setText(PreferencesMessages.ProjectLanguagesPropertyPage_removeMappingButton);
            removeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem[] selection = WorkspaceLanguageMappingWidget.this.fTable.getSelection();
                    int i = 0;
                    while (i < selection.length) {
                        String contentType = (String)WorkspaceLanguageMappingWidget.this.fContentTypeNamesToIDsMap.get(selection[i].getText(0));
                        WorkspaceLanguageMappingWidget.this.fContentTypeMappings.remove(contentType);
                        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                        WorkspaceLanguageMappingWidget.this.fAffectedContentTypes.add(contentTypeManager.getContentType(contentType));
                        ++i;
                    }
                    if (selection.length > 0) {
                        WorkspaceLanguageMappingWidget.this.setChanged(true);
                    }
                    WorkspaceLanguageMappingWidget.this.refreshMappings();
                }
            });
        }
        this.refreshMappings();
        return this.fContents;
    }

    public void refreshMappings() {
        if (this.fTable == null) {
            return;
        }
        this.fTable.removeAll();
        Iterator mappings = this.fContentTypeMappings.entrySet().iterator();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        while (mappings.hasNext()) {
            Map.Entry entry = mappings.next();
            TableItem item = new TableItem(this.fTable, 0);
            String contentType = (String)entry.getKey();
            String contentTypeName = contentTypeManager.getContentType(contentType).getName();
            String languageName = LanguageManager.getInstance().getLanguage((String)entry.getValue()).getName();
            if (this.fOverriddenContentTypes.contains(contentType)) {
                item.setText(0, Messages.format(PreferencesMessages.ProjectLanguagesPropertyPage_overriddenContentType, contentTypeName));
                item.setFont(this.fOverriddenFont);
            } else {
                item.setText(0, contentTypeName);
            }
            item.setText(1, languageName);
        }
        if (this.fChild != null) {
            HashSet overrides = new HashSet(this.fContentTypeMappings.keySet());
            overrides.addAll(this.fOverriddenContentTypes);
            this.fChild.setOverriddenContentTypes(overrides);
            this.fChild.refreshMappings();
        }
    }

    public void setMappings(Map mappings) {
        this.fContentTypeMappings = new TreeMap(mappings);
    }

    public Map getContentTypeMappings() {
        return Collections.unmodifiableMap(this.fContentTypeMappings);
    }
}

