/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class PDOMSearchListContentProvider
implements IStructuredContentProvider,
IPDOMSearchContentProvider {
    private TableViewer viewer;
    private PDOMSearchResult result;

    public Object[] getElements(Object inputElement) {
        HashSet<String> uncoveredProjects = new HashSet<String>();
        PDOMSearchResult result = (PDOMSearchResult)((Object)inputElement);
        Object[] results = result.getElements();
        ArrayList<Object> resultList = new ArrayList<Object>(Arrays.asList(results));
        if (result.wasIndexerBusy()) {
            resultList.add(IPDOMSearchContentProvider.INCOMPLETE_RESULTS_NODE);
        }
        int i = 0;
        while (i < results.length) {
            PDOMSearchElement searchElement;
            String path;
            if (results[i] instanceof PDOMSearchElement && (path = (searchElement = (PDOMSearchElement)results[i]).getLocation().getFullPath()) != null) {
                uncoveredProjects.add(new Path(path).segment(0));
            }
            ++i;
        }
        ICProject[] projects = ((PDOMSearchQuery)result.getQuery()).getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            ICProject project = projects[i2];
            boolean foundProject = uncoveredProjects.contains(project.getProject().getName());
            if (!foundProject) {
                if (project.isOpen()) {
                    if (!CCorePlugin.getIndexManager().isProjectIndexed(project)) {
                        resultList.add(this.createUnindexedProjectWarningElement(project));
                    }
                } else {
                    resultList.add(this.createClosedProjectWarningElement(project));
                }
            }
            ++i2;
        }
        return resultList.toArray();
    }

    private Status createUnindexedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format((String)CSearchMessages.getString("PDOMSearchListContentProvider.IndexerNotEnabledMessageFormat"), (Object[])new Object[]{project.getProject().getName()}));
    }

    private Status createClosedProjectWarningElement(ICProject project) {
        return new Status(2, "org.eclipse.cdt.ui", MessageFormat.format((String)CSearchMessages.getString("PDOMSearchListContentProvider.ProjectClosedMessageFormat"), (Object[])new Object[]{project.getProject().getName()}));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
        this.result = (PDOMSearchResult)((Object)newInput);
        viewer.refresh();
    }

    public void elementsChanged(Object[] elements) {
        if (this.result == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (this.result.getMatchCount(elements[i]) > 0) {
                if (this.viewer.testFindItem(elements[i]) != null) {
                    this.viewer.refresh(elements[i]);
                } else {
                    this.viewer.add(elements[i]);
                }
            } else {
                this.viewer.remove(elements[i]);
            }
            ++i;
        }
    }

    public void clear() {
        this.viewer.refresh();
    }
}

