/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class COutlineInformationControl
extends AbstractInformationControl {
    private static final int TEXT_FLAGS = 1073742345;
    private static final int IMAGE_FLAGS = 1;
    private ICElement fInput = null;
    private IContentProvider fOutlineContentProvider;
    private LexicalSortingAction fSortingAction;

    public COutlineInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle, null, false);
    }

    protected TreeViewer createTreeViewer(Composite parent, int treeStyle) {
        ProblemTreeViewer treeViewer = new ProblemTreeViewer(parent, treeStyle);
        Tree tree = treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        this.fOutlineContentProvider = new CContentOutlinerProvider(treeViewer);
        treeViewer.setContentProvider(this.fOutlineContentProvider);
        this.fSortingAction = new LexicalSortingAction(treeViewer);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(new AppearanceAwareLabelProvider(1073742345, 1), true));
        treeViewer.setAutoExpandLevel(-1);
        return treeViewer;
    }

    protected String getId() {
        return "org.eclipse.cdt.internal.ui.text.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        ICElement ce = (ICElement)information;
        ITranslationUnit tu = (ITranslationUnit)ce.getAncestor(60);
        if (tu != null) {
            this.fInput = tu;
        }
        this.inputChanged(this.fInput, information);
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.fSortingAction);
    }

    private class LexicalCSorter
    extends ViewerComparator {
        private LexicalCSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }

        public int category(Object obj) {
            if (obj instanceof ICElement) {
                ICElement elem = (ICElement)obj;
                switch (elem.getElementType()) {
                    case 79: {
                        return 2;
                    }
                    case 75: {
                        return 3;
                    }
                    case 62: {
                        return 4;
                    }
                    case 80: {
                        return 10;
                    }
                    case 64: 
                    case 65: 
                    case 82: 
                    case 83: {
                        return 11;
                    }
                    case 66: 
                    case 67: 
                    case 84: 
                    case 85: {
                        return 12;
                    }
                    case 68: 
                    case 69: 
                    case 86: 
                    case 87: {
                        return 13;
                    }
                    case 63: {
                        return 14;
                    }
                    case 76: 
                    case 77: {
                        return 20;
                    }
                    case 72: {
                        return 21;
                    }
                    case 73: 
                    case 74: 
                    case 88: 
                    case 89: {
                        return 22;
                    }
                    case 70: 
                    case 71: 
                    case 90: 
                    case 91: {
                        return 23;
                    }
                    case 61: {
                        return 30;
                    }
                }
            } else if (obj instanceof CElementGrouping) {
                return 0;
            }
            return 100;
        }
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;
        private LexicalCSorter fSorter;

        public LexicalSortingAction(TreeViewer treeViewer) {
            super(ActionMessages.getString("COutlineInformationControl.viewMenu.sort.label"), 2);
            CPluginImages.setLocalImageDescriptors((IAction)this, "org.eclipse.cdt.ui.alphab_sort_co.gif");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.lexical_sorting_browsing_action");
            this.fOutlineViewer = treeViewer;
            this.fSorter = new LexicalCSorter();
            boolean checked = COutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
            if (checked && this.fOutlineViewer != null) {
                this.fOutlineViewer.setComparator((ViewerComparator)this.fSorter);
            }
        }

        public void run() {
            boolean on = this.isChecked();
            this.fOutlineViewer.setComparator((ViewerComparator)(on ? this.fSorter : null));
            COutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
        }
    }
}

