/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.text.CCodeReader;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class CSourceHover
extends AbstractCEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private static final boolean DEBUG = false;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            String source;
            block13: {
                ICElement curr;
                String expression;
                IWorkingCopy copy;
                block12: {
                    block11: {
                        IEditorInput input = editor.getEditorInput();
                        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
                        copy = manager.getWorkingCopy(input);
                        if (copy == null) {
                            return null;
                        }
                        expression = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                        expression = expression.trim();
                        if (expression.length() != 0) break block11;
                        return null;
                    }
                    if (!this.selectionIsKeyword(expression)) break block12;
                    return null;
                }
                source = null;
                source = this.searchInIndex((ITranslationUnit)copy, hoverRegion);
                if (source == null && (curr = copy.getElement(expression)) != null) {
                    source = CSourceHover.getSourceForCElement(textViewer.getDocument(), curr);
                }
                if (source != null && source.trim().length() != 0) break block13;
                return null;
            }
            try {
                String delim = System.getProperty("line.separator", "\n");
                String[] sourceLines = Strings.convertIntoLines(source);
                String firstLine = sourceLines[0];
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = "";
                }
                Strings.trimIndentation(sourceLines, CSourceHover.getTabWidth());
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = firstLine;
                }
                source = Strings.concatenate(sourceLines, delim);
                return source;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private static String getSourceForCElement(IDocument doc, ICElement cElement) throws CModelException, BadLocationException {
        String contentType;
        int commentStart;
        if (!(cElement instanceof ISourceReference)) {
            return null;
        }
        ISourceRange sourceRange = ((ISourceReference)cElement).getSourceRange();
        int sourceStart = sourceRange.getStartPos();
        int sourceEnd = sourceStart + sourceRange.getLength();
        CHeuristicScanner scanner = new CHeuristicScanner(doc);
        int commentBound = scanner.scanBackward(sourceStart, -2, new char[]{'{', '}', ';'});
        if (commentBound == -1) {
            commentBound = -1;
        }
        sourceStart = (commentStart = CSourceHover.searchCommentBackward(doc, sourceStart, commentBound)) >= 0 ? commentStart : doc.getLineInformationOfOffset(sourceStart).getOffset();
        IRegion lineRegion = doc.getLineInformationOfOffset(sourceEnd);
        int lineEnd = lineRegion.getOffset() + lineRegion.getLength();
        int nextNonWS = scanner.findNonWhitespaceForwardInAnyPartition(sourceEnd + 1, lineEnd);
        if (nextNonWS != -1 && ("__c_multiline_comment".equals(contentType = TextUtilities.getContentType((IDocument)doc, (String)"___c_partitioning", (int)nextNonWS, (boolean)false)) || "__c_singleline_comment".equals(contentType))) {
            sourceEnd = lineEnd;
        }
        return doc.get(sourceStart, sourceEnd - sourceStart);
    }

    private static int searchCommentBackward(IDocument doc, int start, int bound) throws BadLocationException {
        int firstLine = doc.getLineOfOffset(start);
        if (firstLine == 0) {
            return 0;
        }
        ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)start, (boolean)true);
        int currentOffset = Math.max(doc.getLineOffset(firstLine - 1), partition.getOffset() - 1);
        int commentOffset = -1;
        while (currentOffset > bound) {
            int startLine;
            int lineOffset;
            int partitionOffset;
            partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)currentOffset, (boolean)true);
            currentOffset = partition.getOffset() - 1;
            if ("__c_multiline_comment".equals(partition.getType())) {
                partitionOffset = partition.getOffset();
                if (partitionOffset == (lineOffset = doc.getLineOffset(startLine = doc.getLineOfOffset(partitionOffset))) || doc.get(lineOffset, partitionOffset - lineOffset).trim().length() == 0) {
                    return lineOffset;
                }
                return commentOffset;
            }
            if ("__c_singleline_comment".equals(partition.getType())) {
                partitionOffset = partition.getOffset();
                if (partitionOffset == (lineOffset = doc.getLineOffset(startLine = doc.getLineOfOffset(partitionOffset))) || doc.get(lineOffset, partitionOffset - lineOffset).trim().length() == 0) {
                    commentOffset = lineOffset;
                    continue;
                }
                return commentOffset;
            }
            if (!"__dftl_partition_content_type".equals(partition.getType()) || doc.get(partition.getOffset(), partition.getLength()).trim().length() != 0 && commentOffset >= 0) break;
        }
        return commentOffset;
    }

    private static int getTabWidth() {
        return 4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String removeLeadingComments(String source) {
        block11: {
            reader = new CCodeReader();
            document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    c = reader.read();
                    while (true) {
                        if (c == -1 || c != 13 && c != 10) {
                            i = reader.getOffset();
                            reader.close();
                        }
                        c = reader.read();
                    }
                }
                catch (IOException v0) {
                    i = 0;
                }
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                try {
                    if (reader == null) throw var6_5;
                    reader.close();
                    throw var6_5;
                }
                catch (IOException ex) {
                    CUIPlugin.getDefault().log(ex);
                }
                throw var6_5;
            }
            {
                var5_7 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 94->105)] { 
lbl29:
            // 1 sources

            if (reader != null) {
                reader.close();
            }
            break block11;
lbl32:
            // 1 sources

            catch (IOException ex) {
                CUIPlugin.getDefault().log(ex);
            }
        }
        if (i >= 0) return source.substring(i);
        return source;
    }

    private String searchInIndex(ITranslationUnit tUnit, IRegion textRegion) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ComputeSourceRunnable computer = new ComputeSourceRunnable(tUnit, textRegion);
        ASTProvider.getASTProvider().runOnAST((ICElement)tUnit, ASTProvider.WAIT_NO, (IProgressMonitor)monitor, computer);
        return computer.getSource();
    }

    private boolean selectionIsKeyword(String name) {
        Set keywords = ParserFactory.getKeywordSet((KeywordSetKey)KeywordSetKey.KEYWORDS, (ParserLanguage)ParserLanguage.CPP);
        return keywords.contains(name);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, CSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }

    private static class ComputeSourceRunnable
    implements ASTCache.ASTRunnable {
        private final ITranslationUnit fTU;
        private final IRegion fTextRegion;
        private final IProgressMonitor fMonitor;
        private String fSource;

        public ComputeSourceRunnable(ITranslationUnit tUnit, IRegion textRegion) {
            this.fTU = tUnit;
            this.fTextRegion = textRegion;
            this.fMonitor = new NullProgressMonitor();
            this.fSource = null;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                try {
                    IASTName[] names = lang.getSelectedNames(ast, this.fTextRegion.getOffset(), this.fTextRegion.getLength());
                    if (names != null && names.length >= 1) {
                        int i = 0;
                        while (i < names.length) {
                            IASTName name = names[i];
                            IBinding binding = name.resolveBinding();
                            if (binding != null) {
                                if (!(binding instanceof IProblemBinding)) {
                                    this.fSource = binding instanceof IMacroBinding ? this.computeSourceForMacro(ast, name, binding) : this.computeSourceForBinding(ast, binding);
                                }
                                if (this.fSource != null) {
                                    return Status.OK_STATUS;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException exc) {
                    return exc.getStatus();
                }
                catch (DOMException exc) {
                    return new Status(4, "org.eclipse.cdt.ui", "Internal Error", (Throwable)exc);
                }
            }
            return Status.CANCEL_STATUS;
        }

        private String computeSourceForMacro(IASTTranslationUnit ast, IASTName name, IBinding binding) throws CoreException {
            IASTPreprocessorMacroDefinition[] localMacroDefs;
            IASTPreprocessorMacroDefinition macroDef = null;
            char[] macroName = name.toCharArray();
            IASTPreprocessorMacroDefinition[] macroDefs = localMacroDefs = ast.getMacroDefinitions();
            while (macroDefs != null) {
                int i = 0;
                while (i < macroDefs.length) {
                    if (Arrays.equals(macroDefs[i].getName().toCharArray(), macroName)) {
                        macroDef = macroDefs[i];
                        break;
                    }
                    ++i;
                }
                IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = macroDefs = macroDefs == localMacroDefs ? ast.getBuiltinMacroDefinitions() : null;
            }
            if (macroDef != null) {
                String expansion;
                String source = this.computeSourceForName((IName)macroDef.getName(), binding);
                if (source != null) {
                    return source;
                }
                IASTFunctionStyleMacroParameter[] parameters = new IASTFunctionStyleMacroParameter[]{};
                if (macroDef instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
                    parameters = ((IASTPreprocessorFunctionStyleMacroDefinition)macroDef).getParameters();
                }
                StringBuffer buf = new StringBuffer(macroName.length + macroDef.getExpansion().length() + parameters.length * 5 + 10);
                buf.append("#define ").append(macroName);
                if (parameters.length > 0) {
                    buf.append('(');
                    int i = 0;
                    while (i < parameters.length) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        IASTFunctionStyleMacroParameter parameter = parameters[i];
                        buf.append(parameter.getParameter());
                        ++i;
                    }
                    buf.append(')');
                }
                if ((expansion = macroDef.getExpansion()) != null) {
                    buf.append(' ').append(expansion);
                }
                return buf.toString();
            }
            return null;
        }

        private String computeSourceForBinding(IASTTranslationUnit ast, IBinding binding) throws CoreException, DOMException {
            IName[] names = this.findDefinitions(ast, binding);
            if (names.length == 0) {
                names = this.findDeclarations(ast, binding);
            }
            if (names.length > 0) {
                int i = 0;
                while (i < names.length) {
                    String source = this.computeSourceForName(names[0], binding);
                    if (source != null) {
                        return source;
                    }
                    ++i;
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String computeSourceForName(IName name, IBinding binding) throws CoreException {
            IASTName astName;
            IASTFileLocation fileLocation = name.getFileLocation();
            if (fileLocation == null) {
                return null;
            }
            String fileName = fileLocation.getFileName();
            IPath location = Path.fromOSString((String)fileName);
            LocationKind locationKind = LocationKind.LOCATION;
            if (name instanceof IASTName && !name.isReference() && (astName = (IASTName)name).getTranslationUnit().getFilePath().equals(fileName) && this.fTU.getResource() != null) {
                location = this.fTU.getResource().getFullPath();
                locationKind = LocationKind.IFILE;
            }
            ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
            mgr.connect(location, locationKind, this.fMonitor);
            ITextFileBuffer buffer = mgr.getTextFileBuffer(location, locationKind);
            try {
                String string;
                try {
                    String source;
                    int sourceEnd;
                    int sourceStart;
                    block12: {
                        boolean isKnR;
                        IDocument doc;
                        int nameOffset;
                        Region nameRegion;
                        block13: {
                            block11: {
                                block10: {
                                    nameRegion = new Region(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
                                    nameOffset = nameRegion.getOffset();
                                    doc = buffer.getDocument();
                                    if (!(binding instanceof IMacroBinding)) break block10;
                                    ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)nameOffset, (boolean)false);
                                    if (!"__c_preprocessor".equals(partition.getType())) break block11;
                                    int directiveStart = partition.getOffset();
                                    int commentStart = CSourceHover.searchCommentBackward(doc, directiveStart, -1);
                                    sourceStart = commentStart >= 0 ? commentStart : directiveStart;
                                    sourceEnd = directiveStart + partition.getLength();
                                    break block12;
                                }
                                isKnR = this.isKnRSource(name);
                                sourceStart = this.computeSourceStart(doc, nameOffset, binding, isKnR);
                                if (sourceStart != -1) break block13;
                            }
                            Object var17_18 = null;
                            mgr.disconnect(location, LocationKind.LOCATION, this.fMonitor);
                            return null;
                        }
                        sourceEnd = this.computeSourceEnd(doc, nameOffset + nameRegion.getLength(), binding, name.isDefinition(), isKnR);
                    }
                    string = source = buffer.getDocument().get(sourceStart, sourceEnd - sourceStart);
                    Object var17_19 = null;
                }
                catch (BadLocationException badLocationException) {}
                mgr.disconnect(location, LocationKind.LOCATION, this.fMonitor);
                return string;
                Object var17_21 = null;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                mgr.disconnect(location, LocationKind.LOCATION, this.fMonitor);
                throw throwable;
            }
            mgr.disconnect(location, LocationKind.LOCATION, this.fMonitor);
            return null;
        }

        private boolean isKnRSource(IName name) {
            if (name instanceof IASTName) {
                IASTNode node = (IASTNode)name;
                while (node.getParent() != null) {
                    if (node instanceof ICASTKnRFunctionDeclarator) {
                        return node.getParent() instanceof IASTFunctionDefinition;
                    }
                    node = node.getParent();
                }
            }
            return false;
        }

        private int computeSourceStart(IDocument doc, int nameOffset, IBinding binding, boolean isKnR) throws BadLocationException {
            int sourceStart = nameOffset;
            CHeuristicScanner scanner = new CHeuristicScanner(doc);
            if (binding instanceof IParameter) {
                if (isKnR) {
                    sourceStart = scanner.scanBackward(nameOffset, -2, new char[]{')', ';'});
                } else {
                    sourceStart = scanner.scanBackward(nameOffset, -2, new char[]{'>', '(', ','});
                    if (sourceStart > 0 && doc.getChar(sourceStart) == '>' && (sourceStart = scanner.findOpeningPeer(sourceStart - 1, '<', '>')) > 0) {
                        sourceStart = scanner.scanBackward(sourceStart, -2, new char[]{'(', ','});
                    }
                }
                if (sourceStart == -1) {
                    return sourceStart;
                }
                if ((sourceStart = scanner.findNonWhitespaceForward(sourceStart + 1, nameOffset)) == -1) {
                    sourceStart = nameOffset;
                }
            } else if (binding instanceof ICPPTemplateParameter) {
                sourceStart = scanner.scanBackward(nameOffset, -2, new char[]{'>', '<', ','});
                if (sourceStart > 0 && doc.getChar(sourceStart) == '>' && (sourceStart = scanner.findOpeningPeer(sourceStart - 1, '<', '>')) > 0) {
                    sourceStart = scanner.scanBackward(sourceStart, -2, new char[]{'<', ','});
                }
                if (sourceStart == -1) {
                    return sourceStart;
                }
                if ((sourceStart = scanner.findNonWhitespaceForward(sourceStart + 1, nameOffset)) == -1) {
                    sourceStart = nameOffset;
                }
            } else if (binding instanceof IEnumerator) {
                sourceStart = scanner.scanBackward(nameOffset, -2, new char[]{'{', ','});
                if (sourceStart == -1) {
                    return sourceStart;
                }
                if ((sourceStart = scanner.findNonWhitespaceForward(sourceStart + 1, nameOffset)) == -1) {
                    sourceStart = nameOffset;
                }
            } else {
                int commentStart;
                Object type = null;
                try {
                    type = binding instanceof ITypedef ? ((ITypedef)binding).getType() : (binding instanceof IVariable ? ((IVariable)binding).getType() : null);
                }
                catch (DOMException dOMException) {}
                boolean expectClosingBrace = type instanceof ICompositeType || type instanceof IEnumeration;
                int nameLine = doc.getLineOfOffset(nameOffset);
                sourceStart = nameOffset;
                int commentBound = isKnR ? scanner.scanBackward(sourceStart, -2, new char[]{')', ';'}) : scanner.scanBackward(sourceStart, -2, new char[]{'{', '}', ';'});
                while (expectClosingBrace && commentBound > 0 && doc.getChar(commentBound) == '}') {
                    int openingBrace = scanner.findOpeningPeer(commentBound - 1, '{', '}');
                    if (openingBrace != -1) {
                        sourceStart = openingBrace - 1;
                    }
                    commentBound = isKnR ? scanner.scanBackward(sourceStart, -2, new char[]{')', ';'}) : scanner.scanBackward(sourceStart, -2, new char[]{'{', '}', ';'});
                }
                if (commentBound == -1) {
                    commentBound = -1;
                }
                if ((commentStart = CSourceHover.searchCommentBackward(doc, sourceStart = Math.min(sourceStart, doc.getLineOffset(nameLine)), commentBound)) >= 0) {
                    sourceStart = commentStart;
                } else {
                    int nextNonWSLine;
                    int lineOffset;
                    int nextNonWS = scanner.findNonWhitespaceForward(commentBound + 1, sourceStart);
                    if (nextNonWS != -1 && doc.get(lineOffset = doc.getLineOffset(nextNonWSLine = doc.getLineOfOffset(nextNonWS)), nextNonWS - lineOffset).trim().length() == 0) {
                        sourceStart = doc.getLineOffset(nextNonWSLine);
                    }
                }
            }
            return sourceStart;
        }

        private int computeSourceEnd(IDocument doc, int start, IBinding binding, boolean isDefinition, boolean isKnR) throws BadLocationException {
            int sourceEnd = start;
            CHeuristicScanner scanner = new CHeuristicScanner(doc);
            boolean searchBrace = false;
            boolean searchSemi = false;
            boolean searchComma = false;
            if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
                searchBrace = true;
            } else if (binding instanceof ICPPTemplateDefinition) {
                searchBrace = true;
            } else if (binding instanceof IFunction && isDefinition) {
                searchBrace = true;
            } else if (binding instanceof IParameter) {
                if (isKnR) {
                    searchSemi = true;
                } else {
                    searchComma = true;
                }
            } else if (binding instanceof IEnumerator || binding instanceof ICPPTemplateParameter) {
                searchComma = true;
            } else if (binding instanceof IVariable || binding instanceof ITypedef) {
                searchSemi = true;
            } else if (!isDefinition) {
                searchSemi = true;
            }
            if (searchBrace) {
                int brace = scanner.scanForward(start, -2, '{');
                if (brace != -1 && (sourceEnd = scanner.findClosingPeer(brace + 1, '{', '}')) == -1) {
                    sourceEnd = doc.getLength();
                }
                IRegion lineRegion = doc.getLineInformationOfOffset(sourceEnd);
                sourceEnd = lineRegion.getOffset() + lineRegion.getLength();
            } else if (searchSemi) {
                int semi = scanner.scanForward(start, -2, ';');
                if (semi != -1) {
                    sourceEnd = semi + 1;
                }
                IRegion lineRegion = doc.getLineInformationOfOffset(sourceEnd);
                sourceEnd = lineRegion.getOffset() + lineRegion.getLength();
            } else if (searchComma) {
                int comma;
                int bound = binding instanceof IParameter ? scanner.findClosingPeer(start, '(', ')') : (binding instanceof ICPPTemplateParameter ? scanner.findClosingPeer(start, '<', '>') : (binding instanceof IEnumerator ? scanner.findClosingPeer(start, '{', '}') : -1));
                if (bound == -1) {
                    bound = Math.min(doc.getLength(), start + 100);
                }
                if ((comma = scanner.scanForward(start, bound, ',')) == -1) {
                    sourceEnd = bound;
                } else {
                    String contentType;
                    sourceEnd = comma;
                    IRegion lineRegion = doc.getLineInformationOfOffset(sourceEnd);
                    int lineEnd = lineRegion.getOffset() + lineRegion.getLength();
                    int nextNonWS = scanner.findNonWhitespaceForwardInAnyPartition(sourceEnd + 1, lineEnd);
                    if (nextNonWS != -1 && ("__c_multiline_comment".equals(contentType = TextUtilities.getContentType((IDocument)doc, (String)"___c_partitioning", (int)nextNonWS, (boolean)false)) || "__c_singleline_comment".equals(contentType))) {
                        sourceEnd = lineEnd;
                    }
                }
            }
            return sourceEnd;
        }

        private IName[] findDefinitions(IASTTranslationUnit ast, IBinding binding) throws CoreException {
            IASTName[] declNames = ast.getDefinitionsInAST(binding);
            if (declNames.length == 0 && ast.getIndex() != null) {
                declNames = ast.getIndex().findDefinitions(binding);
            }
            return declNames;
        }

        private IName[] findDeclarations(IASTTranslationUnit ast, IBinding binding) throws CoreException {
            IASTName[] declNames = ast.getDeclarationsInAST(binding);
            if (declNames.length == 0 && ast.getIndex() != null) {
                declNames = ast.getIndex().findNames(binding, 1);
            }
            return declNames;
        }

        public String getSource() {
            return this.fSource;
        }
    }
}

