/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;

public class KeywordCompletionProposalComputer
extends ParsingBasedProposalComputer
implements ICompletionProposalComputer {
    private static String[] ckeywords = new String[]{"break", "const", "continue", "default", "double", "extern", "float", "inline", "register", "restrict", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "volatile", "while", "_Bool", "_Complex", "_Imaginary"};
    private static String[] cppkeywords = new String[]{"break", "catch", "class", "const", "const_cast", "continue", "default", "delete", "double", "dynamic_cast", "explicit", "export", "extern", "false", "float", "friend", "inline", "mutable", "namespace", "operator", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_cast", "struct", "switch", "template", "throw", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "volatile", "wchar_t", "while"};
    private static String[] preprocessorKeywords = new String[]{"#define", "#elif", "#else", "#endif", "#error", "#if", "#ifdef", "#ifndef", "#include", "#pragma", "#undef"};

    protected List computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) throws CoreException {
        String[] keywords;
        if (prefix.length() == 0 || context.isContextInformationStyle()) {
            return Collections.EMPTY_LIST;
        }
        if (this.inPreprocessorDirective(context.getDocument(), context.getInvocationOffset())) {
            keywords = preprocessorKeywords;
        } else {
            if (!this.isValidContext(completionNode)) {
                return Collections.EMPTY_LIST;
            }
            ITranslationUnit tu = context.getTranslationUnit();
            keywords = cppkeywords;
            if (tu != null && tu.isCLanguage()) {
                keywords = ckeywords;
            }
        }
        ArrayList<CCompletionProposal> proposals = new ArrayList<CCompletionProposal>();
        ImageDescriptor imagedesc = CElementImageProvider.getKeywordImageDescriptor();
        Image image = imagedesc != null ? CUIPlugin.getImageDescriptorRegistry().get(imagedesc) : null;
        int i = 0;
        while (i < keywords.length) {
            if (keywords[i].startsWith(prefix)) {
                int repLength = prefix.length();
                int repOffset = context.getInvocationOffset() - repLength;
                proposals.add(new CCompletionProposal(keywords[i], repOffset, repLength, image, keywords[i], 1, context.getViewer()));
            }
            ++i;
        }
        return proposals;
    }

    private boolean isValidContext(IASTCompletionNode completionNode) {
        IASTName[] names = completionNode.getNames();
        int i = 0;
        while (i < names.length) {
            IASTName name = names[i];
            if (name.getTranslationUnit() != null && !(name.getParent() instanceof IASTFieldReference)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean inPreprocessorDirective(IDocument doc, int offset) {
        if (offset > 0 && offset == doc.getLength()) {
            --offset;
        }
        try {
            return "__c_preprocessor".equals(TextUtilities.getContentType((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

