/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.PendingUpdateAdapter;
import org.eclipse.cdt.internal.ui.util.RemoteTreeViewer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public class RemoteTreeContentManager {
    private RemoteTreeViewer fViewer;
    private IWorkbenchSiteProgressService progressService;
    private Job fFetchJob = new FetchJob();
    private List fElementQueue = new ArrayList();
    private List fCollectors = new ArrayList();
    private List fAdapaters = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RemoteTreeContentManager(ITreeContentProvider provider, RemoteTreeViewer viewer, IWorkbenchPartSite site) {
        this.fViewer = viewer;
        if (site != null) {
            Object siteService;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((siteService = site.getAdapter((Class)clazz)) != null) {
                this.progressService = (IWorkbenchSiteProgressService)siteService;
            }
        }
    }

    protected IElementCollector createElementCollector(Object parent, PendingUpdateAdapter placeholder) {
        return new Collector(parent);
    }

    public Object[] getChildren(Object parent) {
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        Object[] currentChildren = this.fViewer.getCurrentChildren(parent);
        PendingUpdateAdapter placeholder = null;
        if (currentChildren == null || currentChildren.length == 0) {
            placeholder = new PendingUpdateAdapter();
        }
        this.startFetchingDeferredChildren(parent, element, placeholder);
        if (placeholder == null) {
            return currentChildren;
        }
        return new Object[]{placeholder};
    }

    protected void replaceChildren(final Object parent, final Object[] children, final int offset, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        WorkbenchJob updateJob = new WorkbenchJob("IncrementalDeferredTreeContentManager"){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.replace(parent, children, offset);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void prune(final Object parent, final int offset) {
        WorkbenchJob updateJob = new WorkbenchJob("DeferredTree"){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.prune(parent, offset);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void runClearPlaceholderJob(final PendingUpdateAdapter placeholder) {
        if (placeholder == null || placeholder.isRemoved() || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        WorkbenchJob clearJob = new WorkbenchJob("DeferredTreeContentManager_ClearJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!placeholder.isRemoved()) {
                    Control control = RemoteTreeContentManager.this.fViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    RemoteTreeContentManager.this.fViewer.remove(placeholder);
                    placeholder.setRemoved(true);
                }
                return Status.OK_STATUS;
            }
        };
        clearJob.setSystem(true);
        clearJob.schedule();
    }

    protected String getFetchJobName(Object parent, IDeferredWorkbenchAdapter adapter) {
        return "RemoteTreeContentManager";
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        Object adapter;
        if (element instanceof IDeferredWorkbenchAdapter) {
            return (IDeferredWorkbenchAdapter)element;
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.progress.IDeferredWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return (IDeferredWorkbenchAdapter)adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFetchingDeferredChildren(Object parent, IDeferredWorkbenchAdapter adapter, PendingUpdateAdapter placeholder) {
        IElementCollector collector = this.createElementCollector(parent, placeholder);
        List list = this.fElementQueue;
        synchronized (list) {
            if (!this.fElementQueue.contains(parent)) {
                this.fElementQueue.add(parent);
                this.fCollectors.add(collector);
                this.fAdapaters.add(adapter);
            }
        }
        if (this.progressService == null) {
            this.fFetchJob.schedule();
        } else {
            this.progressService.schedule(this.fFetchJob);
        }
    }

    public boolean mayHaveChildren(Object element) {
        IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
        return adapter != null && adapter.isContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List list = this.fElementQueue;
        synchronized (list) {
            this.fFetchJob.cancel();
            this.fElementQueue.clear();
            this.fAdapaters.clear();
            this.fCollectors.clear();
        }
    }

    public class Collector
    implements IElementCollector {
        int offset = 0;
        Object fParent;

        public Collector(Object parent) {
            this.fParent = parent;
        }

        public void add(Object element, IProgressMonitor monitor) {
            this.add(new Object[]{element}, monitor);
        }

        public void add(Object[] elements, IProgressMonitor monitor) {
            Object[] filtered = RemoteTreeContentManager.this.fViewer.filter(elements);
            RemoteTreeContentManager.this.fViewer.getSorter().sort((Viewer)RemoteTreeContentManager.this.fViewer, filtered);
            if (filtered.length > 0) {
                RemoteTreeContentManager.this.replaceChildren(this.fParent, filtered, this.offset, monitor);
                this.offset += filtered.length;
            }
        }

        public void done() {
            RemoteTreeContentManager.this.prune(this.fParent, this.offset);
        }
    }

    class FetchJob
    extends Job {
        public FetchJob() {
            super("FetchJob");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!RemoteTreeContentManager.this.fElementQueue.isEmpty() && !monitor.isCanceled()) {
                Object element = null;
                IElementCollector collector = null;
                IDeferredWorkbenchAdapter adapter = null;
                List list = RemoteTreeContentManager.this.fElementQueue;
                synchronized (list) {
                    if (RemoteTreeContentManager.this.fElementQueue.isEmpty()) {
                        return Status.CANCEL_STATUS;
                    }
                    element = RemoteTreeContentManager.this.fElementQueue.remove(0);
                    collector = (IElementCollector)RemoteTreeContentManager.this.fCollectors.remove(0);
                    adapter = (IDeferredWorkbenchAdapter)RemoteTreeContentManager.this.fAdapaters.remove(0);
                }
                adapter.fetchDeferredChildren(element, collector, monitor);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

