/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeWorkInProgressNode;
import org.eclipse.cdt.internal.ui.viewsupport.ExtendedTreeViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public abstract class AsyncTreeContentProvider
implements ITreeContentProvider {
    private static final int PRIORITY_LOW = 0;
    private static final int PRIORITY_HIGH = 10;
    protected static final Object[] NO_CHILDREN;
    private Object fInput;
    private HashMap fChildNodes = new HashMap();
    private HashSet fHighPriorityTasks = new HashSet();
    private HashSet fLowPriorityTasks = new HashSet();
    private HashMap fViewUpdates = new HashMap();
    private int fViewUpdateDelta;
    private Job fJob;
    private Display fDisplay;
    private TreeViewer fTreeViewer = null;
    private Runnable fScheduledViewupdate = null;
    private HashSet fAutoexpand;
    private Object fAutoSelect;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_CHILDREN = new Object[0];
    }

    public AsyncTreeContentProvider(Display disp) {
        this.fDisplay = disp;
        this.fJob = new Job(CUIMessages.getString("AsyncTreeContentProvider.JobName")){

            protected IStatus run(IProgressMonitor monitor) {
                return AsyncTreeContentProvider.this.runJob(monitor);
            }
        };
        this.fJob.setSystem(true);
    }

    public Object getParent(Object element) {
        if (element instanceof AsyncTreeWorkInProgressNode) {
            AsyncTreeWorkInProgressNode wipNode = (AsyncTreeWorkInProgressNode)element;
            return wipNode.getParent();
        }
        return null;
    }

    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        return null;
    }

    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        return NO_CHILDREN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.fChildNodes.clear();
        HashSet hashSet = this.fHighPriorityTasks;
        synchronized (hashSet) {
            this.fScheduledViewupdate = null;
            this.fHighPriorityTasks.clear();
            this.fLowPriorityTasks.clear();
            this.fViewUpdates.clear();
        }
    }

    public void recompute() {
        if (this.getInput() != null) {
            this.fAutoexpand = new HashSet();
            this.fAutoexpand.addAll(Arrays.asList(this.fTreeViewer.getVisibleExpandedElements()));
            this.fAutoSelect = null;
            this.fAutoSelect = ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
            this.clear();
            this.refreshViewer();
        }
    }

    private void refreshViewer() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != oldInput) {
            this.clear();
            this.fInput = newInput;
        }
        this.fTreeViewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public final Object getInput() {
        return this.fInput;
    }

    public final Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public final Object[] getChildren(Object parentElement) {
        Object[] children = this.internalGetChildren(parentElement);
        if (children == null) {
            this.scheduleQuery(parentElement, 10);
            return new Object[]{new AsyncTreeWorkInProgressNode(parentElement)};
        }
        return children;
    }

    public final boolean hasChildren(Object element) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        Object[] children = this.internalGetChildren(element);
        if (children == null) {
            this.scheduleQuery(element, 0);
            return true;
        }
        return children.length > 0;
    }

    public void dispose() {
        this.fTreeViewer = null;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleQuery(Object element, int priority) {
        HashSet hashSet = this.fHighPriorityTasks;
        synchronized (hashSet) {
            if (priority == 10) {
                if (!this.fHighPriorityTasks.contains(element)) {
                    this.fHighPriorityTasks.add(element);
                    this.fLowPriorityTasks.remove(element);
                }
            } else if (!this.fHighPriorityTasks.contains(element) && !this.fLowPriorityTasks.contains(element)) {
                this.fLowPriorityTasks.add(element);
            }
            this.fJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runJob(IProgressMonitor monitor) {
        IStatus iStatus;
        monitor.beginTask(CUIMessages.getString("AsyncTreeContentProvider.TaskName"), -1);
        try {
            Object parent = this.getParentForNextTask();
            while (parent != null) {
                Object[] children = this.asyncronouslyComputeChildren(parent, monitor);
                HashSet hashSet = this.fHighPriorityTasks;
                synchronized (hashSet) {
                    if (this.fHighPriorityTasks.remove(parent) || this.fLowPriorityTasks.remove(parent)) {
                        this.fViewUpdates.put(parent, children);
                        this.scheduleViewerUpdate();
                    }
                }
                parent = this.getParentForNextTask();
            }
            iStatus = Status.OK_STATUS;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleViewerUpdate() {
        Runnable runme = null;
        HashSet hashSet = this.fHighPriorityTasks;
        synchronized (hashSet) {
            if (this.fScheduledViewupdate != null) {
                return;
            }
            runme = this.fScheduledViewupdate = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Iterator<Object> iter;
                    HashMap updates = null;
                    HashSet hashSet = AsyncTreeContentProvider.this.fHighPriorityTasks;
                    synchronized (hashSet) {
                        if (AsyncTreeContentProvider.this.fViewUpdates.isEmpty()) {
                            AsyncTreeContentProvider.this.fScheduledViewupdate = null;
                            return;
                        }
                        if (AsyncTreeContentProvider.this.fScheduledViewupdate != this) {
                            return;
                        }
                        updates = AsyncTreeContentProvider.this.fViewUpdates;
                        AsyncTreeContentProvider.this.fViewUpdates = new HashMap();
                    }
                    AsyncTreeContentProvider.this.fChildNodes.putAll(updates);
                    if (AsyncTreeContentProvider.this.fTreeViewer instanceof ExtendedTreeViewer) {
                        ((ExtendedTreeViewer)AsyncTreeContentProvider.this.fTreeViewer).refresh(updates.keySet().toArray());
                    } else if (AsyncTreeContentProvider.this.fTreeViewer != null) {
                        iter = updates.keySet().iterator();
                        while (iter.hasNext()) {
                            AsyncTreeContentProvider.this.fTreeViewer.refresh(iter.next());
                        }
                    }
                    iter = updates.values().iterator();
                    while (iter.hasNext()) {
                        AsyncTreeContentProvider.this.checkForAutoExpand((Object[])iter.next());
                    }
                    AsyncTreeContentProvider.this.fViewUpdateDelta = Math.min(1000, AsyncTreeContentProvider.this.fViewUpdateDelta * 2);
                    AsyncTreeContentProvider.this.fDisplay.timerExec(AsyncTreeContentProvider.this.fViewUpdateDelta, (Runnable)this);
                }
            };
        }
        try {
            this.fViewUpdateDelta = 32;
            this.fDisplay.asyncExec(runme);
        }
        catch (SWTException sWTException) {}
    }

    private void checkForAutoExpand(Object[] objects) {
        Object object;
        int i;
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fAutoexpand != null && !this.fAutoexpand.isEmpty()) {
            i = 0;
            while (i < objects.length) {
                object = objects[i];
                if (this.fAutoexpand.remove(object)) {
                    this.fTreeViewer.setExpandedState(object, true);
                }
                if (object.equals(this.fAutoSelect)) {
                    if (this.fTreeViewer.getSelection().isEmpty()) {
                        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
                    }
                    this.fAutoSelect = null;
                }
                ++i;
            }
        }
        if (this.fAutoSelect != null) {
            if (this.fTreeViewer.getSelection().isEmpty()) {
                i = 0;
                while (i < objects.length) {
                    object = objects[i];
                    if (object.equals(this.fAutoSelect)) {
                        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
                        this.fAutoSelect = null;
                    }
                    ++i;
                }
            } else {
                this.fAutoSelect = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getParentForNextTask() {
        HashSet hashSet = this.fHighPriorityTasks;
        synchronized (hashSet) {
            Object parent = null;
            if (!this.fHighPriorityTasks.isEmpty()) {
                parent = this.fHighPriorityTasks.iterator().next();
            } else if (!this.fLowPriorityTasks.isEmpty()) {
                parent = this.fLowPriorityTasks.iterator().next();
            }
            return parent;
        }
    }

    private Object[] internalGetChildren(Object parentElement) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (parentElement instanceof AsyncTreeWorkInProgressNode) {
            return NO_CHILDREN;
        }
        Object[] children = (Object[])this.fChildNodes.get(parentElement);
        if (children == null && (children = this.syncronouslyComputeChildren(parentElement)) != null) {
            final Object[] finalChildren = children;
            this.fChildNodes.put(parentElement, children);
            this.fDisplay.asyncExec(new Runnable(){

                public void run() {
                    AsyncTreeContentProvider.this.checkForAutoExpand(finalChildren);
                }
            });
        }
        return children;
    }

    protected final Display getDisplay() {
        return this.fDisplay;
    }
}

