/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class BinaryParsTab
extends AbstractCPropertyTab {
    private static final int DEFAULT_HEIGHT = 160;
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAME_VISIBILITY = "visibility";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_PRIVATE = "private";
    protected Map configMap;
    protected Map fParserPageMap = null;
    protected Table table;
    protected CheckboxTableViewer tv;
    protected Composite parserGroup;
    private ICTargetPlatformSetting tps;

    protected String getParserId() {
        return "BinaryParser";
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.usercomp, "org.eclipse.cdt.ui.newproj_parser_binary");
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.setupLabel(this.usercomp, UIMessages.getString("BinaryParsTab.0"), 2, 768);
        this.table = new Table(this.usercomp, 2084);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryParsTab.this.handleBinaryParserChanged();
                BinaryParsTab.this.updateButtons();
            }
        });
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String txt;
                String string = txt = element != null ? element.toString() : "";
                if (element instanceof BinaryParserConfiguration) {
                    txt = ((BinaryParserConfiguration)element).getName();
                }
                return txt;
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                BinaryParsTab.this.saveChecked();
            }
        });
        Composite c = new Composite(this.usercomp, 0);
        c.setLayoutData((Object)new GridData(3));
        this.initButtons(c, new String[]{MOVEUP_STR, MOVEDOWN_STR});
        this.parserGroup = new Composite(this.usercomp, 0);
        GridData gd = new GridData();
        this.parserGroup.setLayout((Layout)new TabFolderLayout());
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHorizontalDLUsToPixels(160);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.parserGroup.setLayoutData((Object)gd);
        this.initializeParserList();
        this.initializeParserPageMap();
        this.handleBinaryParserChanged();
    }

    public void setVisible(boolean _visible) {
        super.setVisible(_visible);
        this.page.enableConfigSelection(!_visible);
    }

    public void updateData(ICResourceDescription cfgd) {
        String[] ids = null;
        if (this.page.isForPrefs()) {
            if (cfgd != null && cfgd.getConfiguration() != null) {
                this.tps = cfgd.getConfiguration().getTargetPlatformSetting();
                if (this.tps != null) {
                    ids = this.tps.getBinaryParserIds();
                }
            }
            if (ids == null) {
                ids = new String[]{};
            }
        } else {
            ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
            ids = CoreModelUtil.getBinaryParserIds((ICConfigurationDescription[])cfgs);
        }
        Object[] data = new Object[this.configMap.size()];
        HashMap clone = new HashMap(this.configMap);
        int i = 0;
        while (i < ids.length) {
            data[i] = clone.get(ids[i]);
            clone.remove(ids[i]);
            ++i;
        }
        Iterator it = clone.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            data[i++] = clone.get(s);
        }
        this.tv.setInput((Object)data);
        this.tv.setAllChecked(false);
        i = 0;
        while (i < ids.length) {
            if (this.configMap.containsKey(ids[i])) {
                this.tv.setChecked(this.configMap.get(ids[i]), true);
            }
            ++i;
        }
        this.updateButtons();
    }

    private void initializeParserList() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            this.configMap = new HashMap(exts.length);
            int i = 0;
            while (i < exts.length) {
                if (this.isExtensionVisible(exts[i])) {
                    this.configMap.put(exts[i].getUniqueIdentifier(), new BinaryParserConfiguration(exts[i]));
                }
                ++i;
            }
        }
    }

    private void initializeParserPageMap() {
        this.fParserPageMap = new HashMap(5);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equals("parserPage")) {
                String id = infos[i].getAttribute("parserID");
                this.fParserPageMap.put(id, new BinaryParserPageConfiguration(infos[i]));
            }
            ++i;
        }
    }

    private boolean isExtensionVisible(IExtension ext) {
        int i = 0;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        if (i < elements.length) {
            IConfigurationElement[] children = elements[i].getChildren(ATTR_FILTER);
            int j = 0;
            while (j < children.length) {
                String value;
                String name = children[j].getAttribute(ATTR_NAME);
                if (name != null && name.equals(ATTR_NAME_VISIBILITY) && (value = children[j].getAttribute(ATTR_VALUE)) != null && value.equals(ATTR_VALUE_PRIVATE)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
    }

    protected void handleBinaryParserChanged() {
        ICOptionPage dynamicPage;
        String[] enabled = this.getBinaryParserIDs();
        int i = 0;
        while (i < enabled.length) {
            dynamicPage = this.getBinaryParserPage(enabled[i]);
            if (dynamicPage != null) {
                if (dynamicPage.getControl() == null) {
                    dynamicPage.setContainer(this.page);
                    dynamicPage.createControl(this.parserGroup);
                }
                dynamicPage.setVisible(false);
            }
            ++i;
        }
        String parserID = this.getCurrentBinaryParserID();
        dynamicPage = this.getBinaryParserPage(parserID);
        if (dynamicPage != null) {
            dynamicPage.setVisible(true);
        }
    }

    protected String[] getBinaryParserIDs() {
        return this.configMap.keySet().toArray(new String[this.configMap.keySet().size()]);
    }

    protected ICOptionPage getBinaryParserPage(String parserID) {
        BinaryParserPageConfiguration configElement = (BinaryParserPageConfiguration)this.fParserPageMap.get(parserID);
        if (configElement != null) {
            try {
                return configElement.getPage();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected String getCurrentBinaryParserID() {
        int x = this.table.getSelectionIndex();
        if (x < 0) {
            return null;
        }
        return ((BinaryParserConfiguration)this.table.getItem(x).getData()).getID();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        ICTargetPlatformSetting tps1 = src.getConfiguration().getTargetPlatformSetting();
        ICTargetPlatformSetting tps2 = dst.getConfiguration().getTargetPlatformSetting();
        if (tps1 != null && tps2 != null) {
            tps2.setBinaryParserIds(tps1.getBinaryParserIds());
        }
    }

    protected void performDefaults() {
        if (this.page.isForProject()) {
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable(), null);
        } else if (this.tps != null) {
            this.tps.setBinaryParserIds(null);
        }
        this.informPages(false);
        this.updateData(this.getResDesc());
    }

    private void informPages(boolean apply) {
        NullProgressMonitor mon = new NullProgressMonitor();
        Iterator it = this.fParserPageMap.values().iterator();
        while (it.hasNext()) {
            try {
                ICOptionPage dynamicPage = ((BinaryParserPageConfiguration)it.next()).getPage();
                if (!dynamicPage.isValid() || dynamicPage.getControl() == null) continue;
                if (apply) {
                    dynamicPage.performApply((IProgressMonitor)mon);
                    continue;
                }
                dynamicPage.performDefaults();
            }
            catch (CoreException coreException) {}
        }
    }

    public void buttonPressed(int i) {
        switch (i) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        Object d = this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked(d);
        this.tv.remove(d);
        n = up ? n - 1 : n + 1;
        this.tv.insert(d, n);
        this.tv.setChecked(d, checked);
        this.table.setSelection(n);
        this.saveChecked();
        this.updateButtons();
    }

    private void saveChecked() {
        Object[] objs = this.tv.getCheckedElements();
        String[] ids = null;
        if (objs != null) {
            ids = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                ids[i] = ((BinaryParserConfiguration)objs[i]).getID();
                ++i;
            }
        }
        if (this.page.isForPrefs()) {
            if (this.tps != null) {
                this.tps.setBinaryParserIds(ids);
            }
        } else {
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable(), (String[])ids);
        }
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected class BinaryParserConfiguration {
        IExtension fExtension;

        public BinaryParserConfiguration(IExtension extension) {
            this.fExtension = extension;
        }

        public String getID() {
            return this.fExtension.getUniqueIdentifier();
        }

        public String getName() {
            return this.fExtension.getLabel();
        }

        public String toString() {
            return this.fExtension.getUniqueIdentifier();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BinaryParserConfiguration) {
                return this.getID().equals(((BinaryParserConfiguration)obj).getID());
            }
            return super.equals(obj);
        }
    }

    protected class BinaryParserPageConfiguration {
        ICOptionPage dynamicPage;
        IConfigurationElement fElement;

        public BinaryParserPageConfiguration(IConfigurationElement element) {
            this.fElement = element;
        }

        public ICOptionPage getPage() throws CoreException {
            if (this.dynamicPage == null) {
                this.dynamicPage = (ICOptionPage)this.fElement.createExecutableExtension("class");
            }
            return this.dynamicPage;
        }
    }
}

