/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.IConfigManager;
import org.eclipse.cdt.ui.newui.ManageConfigDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ManageConfigRunner
implements IConfigManager {
    private static final String MANAGE_TITLE = UIMessages.getString("ManageConfigDialog.0");
    protected static ManageConfigRunner instance = null;

    public static ManageConfigRunner getDefault() {
        if (instance == null) {
            instance = new ManageConfigRunner();
        }
        return instance;
    }

    public boolean canManage(IProject[] obs) {
        return obs != null && obs.length == 1;
    }

    public boolean manage(IProject[] obs, boolean doOk) {
        if (!this.canManage(obs)) {
            return false;
        }
        ManageConfigDialog d = new ManageConfigDialog(CUIPlugin.getActiveWorkbenchShell(), String.valueOf(obs[0].getName()) + " : " + MANAGE_TITLE, obs[0]);
        boolean result = false;
        if (d.open() == 0) {
            ICProjectDescription des;
            if (doOk && (des = d.getProjectDescription()) != null) {
                try {
                    CoreModel.getDefault().setProjectDescription(obs[0], des);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            AbstractPage.updateViews((IResource)obs[0]);
            result = true;
        } else if (doOk) {
            CDTPropertyManager.performCancel(d.getShell());
        }
        return result;
    }
}

