/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.cdt.ui.templateengine.Template;

public class TemplateEngineUI {
    private static final TemplateEngineUI TEMPLATE_ENGINE_UI = new TemplateEngineUI();

    private TemplateEngineUI() {
    }

    public static TemplateEngineUI getDefault() {
        return TEMPLATE_ENGINE_UI;
    }

    public Template[] getTemplates(String projectType, String toolChain, String usageFilter) {
        TemplateInfo[] templateInfoArray = TemplateEngine.getDefault().getTemplateInfos(projectType, toolChain, usageFilter);
        ArrayList<Template> templatesList = new ArrayList<Template>();
        int i = 0;
        while (i < templateInfoArray.length) {
            TemplateInfo info = templateInfoArray[i];
            try {
                templatesList.add(new Template(info));
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log((Throwable)tie);
            }
            ++i;
        }
        return templatesList.toArray(new Template[templatesList.size()]);
    }

    public Template[] getTemplates(String projectType, String toolChain) {
        return this.getTemplates(projectType, toolChain, null);
    }

    public Template[] getTemplates(String projectType) {
        return this.getTemplates(projectType, null, null);
    }

    public Template[] getTemplates() {
        TemplateInfo[] templateInfoArray = TemplateEngine.getDefault().getTemplateInfos();
        ArrayList<Template> templatesList = new ArrayList<Template>();
        int i = 0;
        while (i < templateInfoArray.length) {
            try {
                templatesList.add(new Template(templateInfoArray[i]));
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log((Throwable)tie);
            }
            ++i;
        }
        return templatesList.toArray(new Template[templatesList.size()]);
    }

    public Template getTemplateById(String templateId) {
        Template[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            Template template = templates[i];
            if (template.getTemplateId().equalsIgnoreCase(templateId)) {
                return template;
            }
            ++i;
        }
        return null;
    }
}

