/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String DEFAULT_MODE = "default";
    private static final String NAME_PROP = "name";
    private static final String ENABLED_PROP = "enabled";
    private static final String MODE_PROP = "mode";
    private static final String ACTION_PROP = "action";
    private static final String ACTION_PARAM_PROP = "actionParam";
    public static String MULTI_LAUNCH_CONSTANTS_PREFIX = "org.eclipse.cdt.launch.launchGroup";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean dstore = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
        try {
            monitor.beginTask(String.valueOf(LaunchMessages.getString("MultiLaunchConfigurationDelegate.0")) + configuration.getName(), 1000);
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
            List<LaunchElement> input = MultiLaunchConfigurationDelegate.createLaunchElements(configuration, new ArrayList<LaunchElement>());
            MultiLaunchListener listener = new MultiLaunchListener(launch);
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.addLaunchListener((ILaunchListener)listener);
            for (LaunchElement le : input) {
                ILaunchConfiguration conf;
                if (!le.isEnabled() || (conf = MultiLaunchConfigurationDelegate.findLaunch(le.getName())) == null) continue;
                final String localMode = le.getMode() != null && !le.getMode().equals(DEFAULT_MODE) ? le.getMode() : mode;
                if (!conf.supportsMode(localMode)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)LaunchMessages.getFormattedString("MultiLaunchConfigurationDelegate.Cannot", new String[]{conf.toString(), localMode}));
                        }
                    });
                    continue;
                }
                try {
                    if (configuration.getName().equals(conf.getName())) {
                        throw new StackOverflowError();
                    }
                    ILaunch subLaunch = DebugUIPlugin.buildAndLaunch((ILaunchConfiguration)conf, (String)localMode, (IProgressMonitor)new SubProgressMonitor(monitor, 1000 / input.size()));
                    listener.addSubLaunch(subLaunch);
                    listener.launchChanged(subLaunch);
                    this.postLaunchAction(subLaunch, le.getAction(), le.getActionParam(), monitor);
                }
                catch (StackOverflowError stackOverflowError) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)LaunchMessages.getFormattedString("MultiLaunchConfigurationDelegate.Loop", conf.toString()));
                        }
                    });
                }
            }
            if (!launch.hasChildren()) {
                launchManager.removeLaunch(launch);
            }
        }
        finally {
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", dstore);
            monitor.done();
        }
    }

    private void postLaunchAction(ILaunch subLaunch, LaunchElement.EPostLaunchAction action, Object actionParam, IProgressMonitor monitor) {
        switch (action) {
            case NONE: {
                return;
            }
            case WAIT_FOR_TERMINATION: {
                monitor.subTask(String.valueOf(LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.WaitingForTermination")) + " " + subLaunch.getLaunchConfiguration().getName());
                while (!subLaunch.isTerminated() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                monitor.subTask("");
                break;
            }
            case DELAY: {
                Integer waitSecs = (Integer)actionParam;
                if (waitSecs == null) break;
                monitor.subTask(LaunchMessages.getFormattedString("MultiLaunchConfigurationDelegate.Action.Delaying", waitSecs.toString()));
                try {
                    Thread.sleep(waitSecs * 1000);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            default: {
                assert (false) : "new post launch action type is missing logic";
                break;
            }
        }
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    protected static ILaunchConfiguration findLaunch(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration lConf = launchConfigurations[i];
            if (lConf.getName().equals(name)) {
                return lConf;
            }
            ++i;
        }
        return null;
    }

    public static List<LaunchElement> createLaunchElements(ILaunchConfiguration configuration, List<LaunchElement> input) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    LaunchElement.EPostLaunchAction action;
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    String prop = attr.substring(MULTI_LAUNCH_CONSTANTS_PREFIX.length() + 1);
                    int k = prop.indexOf(46);
                    String num = prop.substring(0, k);
                    int index = Integer.parseInt(num);
                    String name = prop.substring(k + 1);
                    if (!name.equals(NAME_PROP)) continue;
                    LaunchElement el = new LaunchElement();
                    el.setIndex(index);
                    el.setName((String)attrs.get(attr));
                    Integer actionParam = null;
                    String actionStr = (String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ACTION_PROP));
                    try {
                        action = LaunchElement.EPostLaunchAction.valueOf(actionStr);
                    }
                    catch (Exception exception) {
                        action = LaunchElement.EPostLaunchAction.NONE;
                    }
                    if (action == LaunchElement.EPostLaunchAction.DELAY) {
                        try {
                            actionParam = Integer.parseInt((String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ACTION_PARAM_PROP)));
                        }
                        catch (NumberFormatException exc) {
                            LaunchUIPlugin.log(exc);
                        }
                    }
                    el.setAction(action, actionParam);
                    el.setMode((String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, MODE_PROP)));
                    el.setEnabled("true".equals(attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ENABLED_PROP))));
                    try {
                        el.setData(MultiLaunchConfigurationDelegate.findLaunch(el.getName()));
                    }
                    catch (Exception exception) {
                        el.setData(null);
                    }
                    while (index >= input.size()) {
                        input.add(null);
                    }
                    input.set(index, el);
                }
                catch (Exception e) {
                    LaunchUIPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
        }
        return input;
    }

    public static void storeLaunchElements(ILaunchConfigurationWorkingCopy configuration, List<LaunchElement> input) {
        int i = 0;
        MultiLaunchConfigurationDelegate.removeLaunchElements(configuration);
        for (LaunchElement el : input) {
            if (el == null) continue;
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, NAME_PROP), el.getName());
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ACTION_PROP), el.getAction().toString());
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ACTION_PARAM_PROP), el.getActionParam() != null ? el.getActionParam().toString() : null);
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, MODE_PROP), el.getMode());
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ENABLED_PROP), String.valueOf(el.isEnabled()));
            ++i;
        }
    }

    public static void removeLaunchElements(ILaunchConfigurationWorkingCopy configuration) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    configuration.removeAttribute(attr);
                }
                catch (Exception e) {
                    LaunchUIPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
        }
    }

    public static String getProp(int index, String string) {
        return String.valueOf(MULTI_LAUNCH_CONSTANTS_PREFIX) + "." + index + "." + string;
    }

    public static class LaunchElement {
        private int index;
        private boolean enabled;
        private String mode;
        private EPostLaunchAction action;
        private Object actionParam;
        private String name;
        private ILaunchConfiguration data;

        public static String actionEnumToStr(EPostLaunchAction action) {
            switch (action) {
                case NONE: {
                    return LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.None");
                }
                case WAIT_FOR_TERMINATION: {
                    return LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.WaitUntilTerminated");
                }
                case DELAY: {
                    return LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.Delay");
                }
            }
            assert (false) : "new post launch action type is missing logic";
            return LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.None");
        }

        public static EPostLaunchAction strToActionEnum(String str) {
            if (str.equals(LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.None"))) {
                return EPostLaunchAction.NONE;
            }
            if (str.equals(LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.WaitUntilTerminated"))) {
                return EPostLaunchAction.WAIT_FOR_TERMINATION;
            }
            if (str.equals(LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.Delay"))) {
                return EPostLaunchAction.DELAY;
            }
            assert (false) : "new post launch action type is missing logic";
            return EPostLaunchAction.NONE;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAction(EPostLaunchAction action, Object actionParam) {
            this.action = action;
            this.actionParam = actionParam;
        }

        public EPostLaunchAction getAction() {
            return this.action;
        }

        public Object getActionParam() {
            return this.actionParam;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setData(ILaunchConfiguration data) {
            this.data = data;
        }

        public ILaunchConfiguration getData() {
            return this.data;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EPostLaunchAction {
            NONE,
            WAIT_FOR_TERMINATION,
            DELAY;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiLaunchListener
    implements ILaunchListener {
        private ILaunch launch;
        private Map<ILaunch, IProcess[]> subLaunches = new HashMap<ILaunch, IProcess[]>();

        public MultiLaunchListener(ILaunch launch) {
            this.launch = launch;
        }

        public void addSubLaunch(ILaunch subLaunch) {
            this.subLaunches.put(subLaunch, subLaunch.getProcesses());
        }

        public void launchChanged(ILaunch launch2) {
            if (this.launch == launch2) {
                return;
            }
            if (this.isChild(launch2, this.subLaunches)) {
                IProcess[] newProcesses;
                IProcess[] oldProcesses;
                IProcess[] iProcessArray = oldProcesses = this.subLaunches.get(launch2);
                int n = oldProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess oldProcess = iProcessArray[n2];
                    this.launch.removeProcess(oldProcess);
                    ++n2;
                }
                IProcess[] iProcessArray2 = newProcesses = launch2.getProcesses();
                int n3 = newProcesses.length;
                n = 0;
                while (n < n3) {
                    IProcess newProcess = iProcessArray2[n];
                    this.launch.addProcess(newProcess);
                    ++n;
                }
                this.subLaunches.put(launch2, newProcesses);
            }
        }

        private boolean isChild(ILaunch launch, Map<ILaunch, IProcess[]> subLaunches) {
            for (ILaunch subLaunch : subLaunches.keySet()) {
                if (subLaunch != launch) continue;
                return true;
            }
            return false;
        }

        public void launchRemoved(ILaunch launch2) {
            if (this.launch == launch2) {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunchListener((ILaunchListener)this);
            } else if (this.isChild(launch2, this.subLaunches)) {
                IProcess[] oldProcesses;
                IProcess[] iProcessArray = oldProcesses = this.subLaunches.get(launch2);
                int n = oldProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess oldProcess = iProcessArray[n2];
                    this.launch.removeProcess(oldProcess);
                    ++n2;
                }
                this.subLaunches.remove(launch2);
            }
        }

        public void launchAdded(ILaunch launch2) {
        }
    }
}

