/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.io.File;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CoreFilePrompter
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Shell shell = LaunchUIPlugin.getShell();
        if (shell == null) {
            Status error = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 150, LaunchMessages.getString("CoreFileLaunchDelegate.No_Shell_available_in_Launch"), null);
            throw new CoreException((IStatus)error);
        }
        FileDialog dialog = new FileDialog(shell);
        dialog.setText(LaunchMessages.getString("CoreFileLaunchDelegate.Select_Corefile"));
        Object[] args = (Object[])source;
        IProject project = (IProject)args[0];
        ICDebugConfiguration debugConfig = (ICDebugConfiguration)args[1];
        String initPath = null;
        try {
            initPath = project.getPersistentProperty(new QualifiedName(LaunchUIPlugin.getUniqueIdentifier(), "SavePath"));
        }
        catch (CoreException coreException) {}
        if (initPath == null || initPath.equals("")) {
            initPath = project.getLocation().toString();
        }
        dialog.setFilterExtensions(debugConfig.getCoreFileExtensions());
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        if (res != null) {
            File file = new File(res);
            if (!file.exists() || !file.canRead()) {
                ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString("CoreFileLaunchDelegate.postmortem_debugging_failed"), (String)LaunchMessages.getString("CoreFileLaunchDelegate.Corefile_not_accessible"), (IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 108, LaunchMessages.getString("CoreFileLaunchDelegate.Corefile_not_readable"), null));
            }
            return new Path(res);
        }
        return null;
    }
}

