/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.core.scannerconfig.tests;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCSpecsConsoleParser;

public class GCCSpecsConsoleParserTest
extends TestCase {
    GCCSpecsConsoleParser parser;
    private IScannerInfoCollector collector;
    List<String> includes;
    List<String> symbols;

    protected void setUp() throws Exception {
        this.collector = new IScannerInfoCollector(){

            public List getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
                return null;
            }

            public void contributeToScannerConfig(Object resource, Map scannerInfo1) {
                Map scannerInfo = scannerInfo1;
                GCCSpecsConsoleParserTest.this.includes = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
                GCCSpecsConsoleParserTest.this.symbols = (List)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
            }
        };
        this.parser = new GCCSpecsConsoleParser();
        this.parser.startup(null, null, this.collector, null);
    }

    private void enterLine(String line) {
        this.parser.processLine(line);
        this.parser.shutdown();
    }

    private void checkMacro(String name, String value) {
        GCCSpecsConsoleParserTest.assertTrue((String)"No symbols", (this.symbols.size() > 0 ? 1 : 0) != 0);
        String string = this.symbols.get(0);
        if (string.contains("=")) {
            String[] val = string.split("=", 2);
            GCCSpecsConsoleParserTest.assertEquals((String)name, (String)val[0]);
            GCCSpecsConsoleParserTest.assertEquals((String)value, (String)val[1]);
        } else {
            GCCSpecsConsoleParserTest.assertEquals((String)name, (String)string);
            GCCSpecsConsoleParserTest.assertEquals((String)value, (String)"");
        }
    }

    public void testProcessLine_NoArgs() {
        this.enterLine("#define __MY_MACRO__ __MY_VALUE__");
        this.checkMacro("__MY_MACRO__", "__MY_VALUE__");
    }

    public void testProcessLine_Const() {
        this.enterLine("#define A (3)");
        this.checkMacro("A", "(3)");
    }

    public void testProcessLine_EmptyArgList() {
        this.enterLine("#define A() B");
        this.checkMacro("A()", "B");
    }

    public void testProcessLine_ParamUnused() {
        this.enterLine("#define A(X) B");
        this.checkMacro("A(X)", "B");
    }

    public void testProcessLine_ParamSpace() {
        this.enterLine("#define __MY_MACRO__(P1, P2) __MY_VALUE__(P1, P2)");
        this.checkMacro("__MY_MACRO__(P1, P2)", "__MY_VALUE__(P1, P2)");
    }

    public void testProcessLine_EmptyBody() {
        this.enterLine("#define __MY_MACRO__(P1, P2) ");
        this.checkMacro("__MY_MACRO__(P1, P2)", "");
    }
}

