/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ManagedBuildCoreTests20
extends TestCase {
    private static final boolean boolVal = true;
    private static final String testConfigId = "test.config.override";
    private static final String testConfigName = "Tester";
    private static final String enumVal = "Another Enum";
    private static final String[] listVal = new String[]{"_DEBUG", "/usr/include", "libglade.a"};
    private static final String newExt = "wen";
    private static final String projectName = "ManagedBuildTest";
    private static final String projectName2 = "ManagedBuildTest2";
    private static final String projectRename = "ManagedBuildRedux";
    private static final String rootExt = "toor";
    private static final String stringVal = "-c -Wall";
    private static final String anotherStringVal = "thevalue";
    private static final String subExt = "bus";

    public ManagedBuildCoreTests20(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedBuildCoreTests20.class.getName());
        suite.addTest((Test)new ManagedBuildCoreTests20("testExtensions"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testProjectCreation"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testConfigurations"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testConfigurationReset"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testConfigBuildArtifact"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testMakeCommandManipulation"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testScannerInfoInterface"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testProjectRename"));
        suite.addTest((Test)new ManagedBuildCoreTests20("testErrorParsers"));
        suite.addTest((Test)new ManagedBuildCoreTests20("cleanup"));
        return suite;
    }

    public void testExtensions() throws Exception {
        IProjectType testRoot = null;
        IProjectType testSub = null;
        IProjectType testSubSub = null;
        IProjectType testForwardChild = null;
        IProjectType testForwardParent = null;
        IProjectType testForwardGrandchild = null;
        int numTypes = 0;
        IProjectType[] projTypes = ManagedBuildManager.getDefinedProjectTypes();
        int i = 0;
        while (i < projTypes.length) {
            IProjectType type = projTypes[i];
            if (type.getName().equals("Test Root")) {
                testRoot = type;
                this.checkRootProjectType(testRoot);
            } else if (type.getName().equals("Test Sub")) {
                testSub = type;
                this.checkSubProjectType(testSub);
            } else if (type.getName().equals("Test Sub Sub")) {
                testSubSub = type;
                this.checkSubSubProjectType(testSubSub);
            } else if (type.getName().equals("Forward Child")) {
                testForwardChild = type;
            } else if (type.getName().equals("Forward Parent")) {
                testForwardParent = type;
            } else if (type.getName().equals("Forward Grandchild")) {
                testForwardGrandchild = type;
            } else if (type.getId().startsWith("test.provider.Test_")) {
                ++numTypes;
                this.checkProviderProjectType(type);
            }
            ++i;
        }
        ManagedBuildCoreTests20.assertNotNull(testForwardChild);
        ManagedBuildCoreTests20.assertNotNull(testForwardParent);
        ManagedBuildCoreTests20.assertNotNull(testForwardGrandchild);
        this.checkForwardProjectTypes(testForwardParent, testForwardChild, testForwardGrandchild);
        ManagedBuildCoreTests20.assertEquals((int)3, (int)numTypes);
        ManagedBuildCoreTests20.assertNotNull((Object)testRoot);
        ManagedBuildCoreTests20.assertNotNull((Object)testSub);
        ManagedBuildCoreTests20.assertNotNull(testSubSub);
    }

    public void testMakeCommandManipulation() {
        String oldMakeCmd = "make";
        String newMakeCmd = "Ant";
        IProject project = null;
        try {
            project = this.createProject(projectName);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open project in 'testMakeCommandManipulation': " + e.getLocalizedMessage()));
        }
        ManagedBuildCoreTests20.assertNotNull((Object)project);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertNotNull((Object)info);
        IManagedProject managedProj = info.getManagedProject();
        ManagedBuildCoreTests20.assertNotNull((Object)managedProj);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        ManagedBuildCoreTests20.assertNotNull((Object)defaultConfig);
        ManagedBuildCoreTests20.assertFalse((boolean)defaultConfig.hasOverriddenBuildCommand());
        ManagedBuildCoreTests20.assertEquals((String)oldMakeCmd, (String)defaultConfig.getBuildCommand());
        defaultConfig.setBuildCommand(newMakeCmd);
        ManagedBuildCoreTests20.assertEquals((String)newMakeCmd, (String)defaultConfig.getBuildCommand());
        ManagedBuildCoreTests20.assertTrue((boolean)defaultConfig.hasOverriddenBuildCommand());
        defaultConfig.setBuildCommand(null);
        ManagedBuildCoreTests20.assertFalse((boolean)defaultConfig.hasOverriddenBuildCommand());
        ManagedBuildCoreTests20.assertEquals((String)oldMakeCmd, (String)defaultConfig.getBuildCommand());
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
    }

    public void testScannerInfoInterface() {
        Path path;
        IProject project = null;
        try {
            project = this.createProject(projectName);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open project in 'testScannerInfoInterface': " + e.getLocalizedMessage()));
        }
        Object[] expectedPaths = new String[]{new Path("/usr/include").toOSString(), new Path("/opt/gnome/include").toOSString(), (path = new Path("C:\\home\\tester/include")).isAbsolute() ? path.toOSString() : project.getLocation().append("Sub Config").append((IPath)path).toOSString(), project.getLocation().append("includes").toOSString(), new Path("/usr/gnu/include").toOSString()};
        IProjectType projType = ManagedBuildManager.getExtensionProjectType((String)"test.sub");
        ManagedBuildCoreTests20.assertNotNull((Object)projType);
        IManagedProject newProject = null;
        try {
            newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failed creating new project: " + e.getLocalizedMessage()));
        }
        ManagedBuildCoreTests20.assertNotNull((Object)newProject);
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IConfiguration[] baseConfigs = projType.getConfigurations();
        int i = 0;
        while (i < baseConfigs.length) {
            newProject.createConfiguration(baseConfigs[i], String.valueOf(baseConfigs[i].getId()) + "." + i);
            ++i;
        }
        IConfiguration[] configs = newProject.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)4, (int)configs.length);
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        buildInfo.setDefaultConfiguration(newProject.getConfiguration(configs[0].getId()));
        buildInfo.setValid(true);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        try {
            project.close(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on project close: " + e.getLocalizedMessage()));
        }
        try {
            project.open(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on project open: " + e.getLocalizedMessage()));
        }
        buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.ScannerInfoProvider");
        if (extensionPoint == null) {
            ManagedBuildCoreTests20.fail((String)"Failed to retrieve the extension point ScannerInfoProvider.");
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        ManagedBuildCoreTests20.assertNotNull((Object)provider);
        provider.subscribe((IResource)project, new IScannerInfoChangeListener((String[])expectedPaths){
            private final /* synthetic */ String[] val$expectedPaths;
            {
                this.val$expectedPaths = stringArray;
            }

            public void changeNotification(IResource project, IScannerInfo info) {
                Map definedSymbols = info.getDefinedSymbols();
                ManagedBuildCoreTests20.assertTrue((boolean)definedSymbols.containsKey("BUILTIN"));
                ManagedBuildCoreTests20.assertTrue((boolean)definedSymbols.containsKey("DEBUG"));
                ManagedBuildCoreTests20.assertTrue((boolean)definedSymbols.containsKey("GNOME"));
                ManagedBuildCoreTests20.assertTrue((boolean)definedSymbols.containsValue("ME"));
                ManagedBuildCoreTests20.assertEquals((String)((String)definedSymbols.get("BUILTIN")), (String)"");
                ManagedBuildCoreTests20.assertEquals((String)((String)definedSymbols.get("DEBUG")), (String)"");
                ManagedBuildCoreTests20.assertEquals((String)((String)definedSymbols.get("GNOME")), (String)"ME");
                Object[] actualPaths = info.getIncludePaths();
                BuildSystemTestHelper.checkDiff(this.val$expectedPaths, actualPaths);
            }
        });
        IScannerInfo currentSettings = provider.getScannerInformation((IResource)project);
        Map currentSymbols = currentSettings.getDefinedSymbols();
        ManagedBuildCoreTests20.assertTrue((boolean)currentSymbols.containsKey("BUILTIN"));
        ManagedBuildCoreTests20.assertEquals((String)((String)currentSymbols.get("BUILTIN")), (String)"");
        Object[] currentPaths = currentSettings.getIncludePaths();
        BuildSystemTestHelper.checkDiff(expectedPaths, currentPaths);
        String[] expectedSymbols = new String[]{"DEBUG", "GNOME = ME "};
        IConfiguration defaultConfig = buildInfo.getDefaultConfiguration();
        ITool[] tools = defaultConfig.getTools();
        ITool subTool = null;
        int i2 = 0;
        while (i2 < tools.length) {
            ITool tool = tools[i2];
            if ("tool.sub".equalsIgnoreCase(tool.getSuperClass().getId())) {
                subTool = tool;
                break;
            }
            ++i2;
        }
        ManagedBuildCoreTests20.assertNotNull(subTool);
        IOption symbolOpt = null;
        IOption[] opts = subTool.getOptions();
        int i3 = 0;
        while (i3 < opts.length) {
            IOption option = opts[i3];
            try {
                if (option.getValueType() == 5) {
                    symbolOpt = option;
                    break;
                }
            }
            catch (BuildException e) {
                ManagedBuildCoreTests20.fail((String)("Failed getting option value-type: " + e.getLocalizedMessage()));
            }
            ++i3;
        }
        ManagedBuildCoreTests20.assertNotNull(symbolOpt);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertFalse((boolean)info.isDirty());
        ManagedBuildManager.setOption((IConfiguration)defaultConfig, (IHoldsOptions)subTool, (IOption)symbolOpt, (String[])expectedSymbols);
        ManagedBuildCoreTests20.assertTrue((boolean)info.isDirty());
        info.setDirty(false);
        ManagedBuildCoreTests20.assertFalse((boolean)info.isDirty());
    }

    public void testConfigurations() throws CoreException, BuildException {
        IProject project = this.createProject(projectName);
        IProjectDescription description = project.getDescription();
        if (description != null) {
            ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject managedProj = info.getManagedProject();
        IConfiguration[] definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)3, (int)definedConfigs.length);
        IConfiguration baseConfig = definedConfigs[0];
        ManagedBuildCoreTests20.assertEquals((String)definedConfigs[0].getName(), (String)"Root Config");
        ManagedBuildCoreTests20.assertEquals((String)definedConfigs[1].getName(), (String)"Root Override Config");
        ManagedBuildCoreTests20.assertEquals((String)definedConfigs[2].getName(), (String)"Complete Override Config");
        IConfiguration newConfig = managedProj.createConfigurationClone(baseConfig, testConfigId);
        ManagedBuildCoreTests20.assertEquals((int)4, (int)managedProj.getConfigurations().length);
        newConfig.setName(testConfigName);
        ManagedBuildCoreTests20.assertEquals((String)newConfig.getId(), (String)testConfigId);
        ManagedBuildCoreTests20.assertEquals((String)newConfig.getName(), (String)testConfigName);
        ITool[] definedTools = newConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)definedTools.length);
        ITool rootTool = definedTools[0];
        ManagedBuildCoreTests20.assertEquals((String)rootTool.getToolCommand(), (String)"doIt");
        newConfig.setToolCommand(rootTool, "never");
        ManagedBuildCoreTests20.assertEquals((String)rootTool.getToolCommand(), (String)"never");
        IOptionCategory topCategory = rootTool.getTopOptionCategory();
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)topCategory.getName());
        Object[][] options = topCategory.getOptions(newConfig);
        int i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        ITool tool = (ITool)options[0][0];
        IOption option = (IOption)options[0][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (String[])listVal);
        option = (IOption)options[1][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (boolean)true);
        IOptionCategory[] categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        options = categories[0].getOptions(newConfig);
        i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        tool = (ITool)options[0][0];
        option = (IOption)options[0][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (String)stringVal);
        option = (IOption)options[1][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (String)anotherStringVal);
        option = (IOption)options[2][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (String)enumVal);
        option = (IOption)options[3][1];
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)tool, (IOption)option, (String)"False");
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        project.close(null);
        project.open(null);
        this.checkOptionReferences(project);
        info = ManagedBuildManager.getBuildInfo((IResource)project);
        managedProj = info.getManagedProject();
        definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)4, (int)definedConfigs.length);
        managedProj.removeConfiguration(testConfigId);
        definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)3, (int)definedConfigs.length);
        ManagedBuildCoreTests20.assertEquals((String)definedConfigs[0].getName(), (String)"Root Config");
        ManagedBuildCoreTests20.assertEquals((String)definedConfigs[1].getName(), (String)"Root Override Config");
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
    }

    public void testConfigurationReset() {
        IProject project = null;
        try {
            project = this.createProject(projectName);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open project: " + e.getLocalizedMessage()));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertNotNull((Object)info);
        IManagedProject managedProj = info.getManagedProject();
        ManagedBuildCoreTests20.assertNotNull((Object)managedProj);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        ManagedBuildCoreTests20.assertNotNull((Object)defaultConfig);
        try {
            this.checkRootManagedProject(managedProj, "z");
        }
        catch (BuildException e1) {
            ManagedBuildCoreTests20.fail((String)("Overridden root managed project check failed: " + e1.getLocalizedMessage()));
        }
        ManagedBuildManager.resetConfiguration((IProject)project, (IConfiguration)defaultConfig);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        try {
            this.checkRootManagedProject(managedProj, "x");
        }
        catch (BuildException e2) {
            ManagedBuildCoreTests20.fail((String)("Reset root managed project check failed: " + e2.getLocalizedMessage()));
        }
    }

    public void testProjectCreation() throws BuildException {
        IProject project = null;
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        IProjectType projType = ManagedBuildManager.getExtensionProjectType((String)"test.root");
        ManagedBuildCoreTests20.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ManagedBuildCoreTests20.assertEquals((String)newProject.getName(), (String)projType.getName());
        ManagedBuildCoreTests20.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        String buildArtifactName = projectName;
        defaultConfig.setArtifactName(buildArtifactName);
        defaultConfig.setArtifactExtension(newExt);
        ManagedBuildManager.getBuildInfo((IResource)project).setValid(true);
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)project);
        if (initResult.getCode() != 0) {
            ManagedBuildCoreTests20.fail((String)("Initializing build information failed for: " + project.getName() + " because: " + initResult.getMessage()));
        }
        this.checkRootManagedProject(newProject, "x");
        configs = newProject.getConfigurations();
        ITool[] tools = configs[0].getTools();
        IOptionCategory topCategory = tools[0].getTopOptionCategory();
        IOptionCategory[] categories = topCategory.getChildCategories();
        Object[][] options = categories[0].getOptions(configs[0]);
        ITool tool = (ITool)options[0][0];
        IOption option = (IOption)options[0][1];
        configs[0].setOption((IHoldsOptions)tool, option, "z");
        options = categories[0].getOptions(null);
        tool = (ITool)options[0][0];
        option = (IOption)options[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"x", (String)option.getStringValue());
        options = categories[0].getOptions(configs[0]);
        tool = (ITool)options[0][0];
        option = (IOption)options[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"z", (String)option.getStringValue());
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        try {
            project.close(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on project close: " + e.getLocalizedMessage()));
        }
        try {
            project.open(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on project open: " + e.getLocalizedMessage()));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertEquals((String)defaultConfig.getId(), (String)info.getDefaultConfiguration().getId());
        this.checkRootManagedProject(newProject, "z");
        this.checkBuildTestSettings(info);
        ManagedBuildManager.removeBuildInfo((IResource)project);
    }

    public void testProjectRename() {
        IWorkspaceRoot workspaceRoot;
        IResource newResource;
        IProject project = null;
        try {
            project = this.createProject(projectName);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open project: " + e.getLocalizedMessage()));
        }
        if ((newResource = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(projectRename)) != null) {
            try {
                newResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ManagedBuildCoreTests20.fail((String)("Failed to delete old project ManagedBuildRedux: " + e.getLocalizedMessage()));
            }
        }
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to find project descriptor for ManagedBuildTest: " + e.getLocalizedMessage()));
        }
        description.setName(projectRename);
        try {
            project.move(description, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to rename project: " + e.getLocalizedMessage()));
        }
        try {
            project = this.createProject(projectRename);
            description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open renamed project: " + e.getLocalizedMessage()));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject managedProj = info.getManagedProject();
        IConfiguration[] definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)4, (int)definedConfigs.length);
        IConfiguration baseConfig = definedConfigs[1];
        ITool[] definedTools = baseConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)definedTools.length);
        ITool rootTool = definedTools[0];
        IOptionCategory topCategory = rootTool.getTopOptionCategory();
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)topCategory.getName());
        Object[][] options = topCategory.getOptions(baseConfig);
        int i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        IOptionCategory[] categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        options = categories[0].getOptions(baseConfig);
        i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        newResource = workspaceRoot.findMember(projectName);
        if (newResource != null) {
            try {
                newResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ManagedBuildCoreTests20.fail((String)("Failed to delete old project ManagedBuildTest: " + e.getLocalizedMessage()));
            }
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to find project descriptor for ManagedBuildRedux: " + e.getLocalizedMessage()));
        }
        description.setName(projectName);
        try {
            project.move(description, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to re-rename project: " + e.getLocalizedMessage()));
        }
        try {
            project = this.createProject(projectName);
            description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed to open re-renamed project: " + e.getLocalizedMessage()));
        }
        info = ManagedBuildManager.getBuildInfo((IResource)project);
        managedProj = info.getManagedProject();
        definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)4, (int)definedConfigs.length);
        baseConfig = definedConfigs[1];
        definedTools = baseConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)definedTools.length);
        rootTool = definedTools[0];
        topCategory = rootTool.getTopOptionCategory();
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)topCategory.getName());
        options = topCategory.getOptions(baseConfig);
        i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        options = categories[0].getOptions(baseConfig);
        i = 0;
        while (i < options.length) {
            if (options[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
    }

    private void checkBuildTestSettings(IManagedBuildInfo info) {
        String ext1 = "foo";
        String ext2 = "bar";
        String badExt = "cpp";
        String expectedOutput = rootExt;
        String expectedCmd = "doIt";
        ManagedBuildCoreTests20.assertNotNull((Object)info);
        ManagedBuildCoreTests20.assertEquals((String)info.getBuildArtifactName(), (String)projectName);
        IManagedProject managedProj = info.getManagedProject();
        ManagedBuildCoreTests20.assertNotNull((Object)managedProj);
        IConfiguration buildConfig = info.getDefaultConfiguration();
        ManagedBuildCoreTests20.assertNotNull((Object)buildConfig);
        ManagedBuildCoreTests20.assertEquals((String)info.getOutputExtension(ext1), (String)expectedOutput);
        ManagedBuildCoreTests20.assertEquals((String)info.getOutputExtension(ext2), (String)expectedOutput);
        ManagedBuildCoreTests20.assertNull((Object)info.getOutputExtension(badExt));
        ManagedBuildCoreTests20.assertEquals((String)info.getToolForSource(ext1), (String)expectedCmd);
        ManagedBuildCoreTests20.assertEquals((String)info.getToolForSource(ext2), (String)expectedCmd);
        ManagedBuildCoreTests20.assertNull((Object)info.getToolForConfiguration(ext1));
        ManagedBuildCoreTests20.assertNull((Object)info.getToolForConfiguration(ext2));
        ManagedBuildCoreTests20.assertNull((Object)info.getToolForSource(expectedOutput));
        ManagedBuildCoreTests20.assertEquals((String)info.getToolForConfiguration(expectedOutput), (String)expectedCmd);
        ManagedBuildCoreTests20.assertEquals((String)info.getFlagsForSource(ext1), (String)"-La -Lb z -e1 -nob");
        ManagedBuildCoreTests20.assertEquals((String)info.getFlagsForSource(ext1), (String)info.getFlagsForSource(ext2));
    }

    private void checkOptionReferences(IProject project) throws BuildException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject managedProj = info.getManagedProject();
        IConfiguration[] definedConfigs = managedProj.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)4, (int)definedConfigs.length);
        IConfiguration newConfig = managedProj.getConfiguration(testConfigId);
        ManagedBuildCoreTests20.assertNotNull((Object)newConfig);
        ITool[] definedTools = newConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)definedTools.length);
        ITool rootTool = definedTools[0];
        IOption[] rootOptions = rootTool.getOptions();
        ManagedBuildCoreTests20.assertEquals((int)6, (int)rootOptions.length);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)rootOptions[0].getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)rootOptions[0].getValueType());
        Object[] list = rootOptions[0].getStringListValue();
        ManagedBuildCoreTests20.assertEquals((int)3, (int)list.length);
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(listVal, list));
        ManagedBuildCoreTests20.assertEquals((String)rootOptions[0].getCommand(), (String)"-L");
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)rootOptions[1].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)rootOptions[1].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)rootOptions[1].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)rootOptions[1].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)rootOptions[2].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)rootOptions[2].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)stringVal, (String)rootOptions[2].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)rootOptions[3].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)rootOptions[3].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)anotherStringVal, (String)rootOptions[3].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"-str", (String)rootOptions[3].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)rootOptions[4].getName());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)rootOptions[4].getValueType());
        String selEnum = rootOptions[4].getSelectedEnum();
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)selEnum);
        String[] enums = rootOptions[4].getApplicableValues();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)enums.length);
        ManagedBuildCoreTests20.assertEquals((String)"Default Enum", (String)enums[0]);
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)enums[1]);
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)rootOptions[4].getEnumCommand(enums[0]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)rootOptions[4].getEnumCommand(enums[1]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)rootOptions[4].getEnumCommand(selEnum));
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)rootOptions[5].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)rootOptions[5].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)rootOptions[5].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-nob", (String)rootOptions[5].getCommandFalse());
    }

    private void checkRootProjectType(IProjectType type) throws BuildException {
        String expectedCleanCmd = "del /myworld";
        String expectedParserId = "org.eclipse.cdt.core.PE";
        Object[] expectedOSList = new String[]{"win32"};
        Object[] expectedArchList = new String[]{"all"};
        ManagedBuildCoreTests20.assertTrue((boolean)type.isTestProjectType());
        IConfiguration[] configs = type.getConfigurations();
        if (configs[0].getArtifactName().equals(projectName)) {
            ManagedBuildCoreTests20.assertEquals((String)configs[0].getArtifactExtension(), (String)newExt);
        } else {
            ManagedBuildCoreTests20.assertEquals((String)configs[0].getArtifactExtension(), (String)rootExt);
        }
        ManagedBuildCoreTests20.assertEquals((String)expectedCleanCmd, (String)configs[0].getCleanCommand());
        ManagedBuildCoreTests20.assertEquals((String)"make", (String)configs[0].getBuildCommand());
        IToolChain toolChain = configs[0].getToolChain();
        ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
        String[] binaryParsers = targetPlatform.getBinaryParserList();
        ManagedBuildCoreTests20.assertEquals((int)binaryParsers.length, (int)1);
        ManagedBuildCoreTests20.assertEquals((String)binaryParsers[0], (String)expectedParserId);
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedOSList, toolChain.getOSList()));
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedArchList, toolChain.getArchList()));
        ManagedBuildCoreTests20.assertNull((Object)configs[0].getErrorParserIds());
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(configs[0].getErrorParserList(), CCorePlugin.getDefault().getAllErrorParsersIDs()));
        ITool[] tools = toolChain.getTools();
        ITool rootTool = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)rootTool.getName());
        IOption[] options = rootTool.getOptions();
        ManagedBuildCoreTests20.assertEquals((int)6, (int)options.length);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)options[0].getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)options[0].getValueType());
        String[] valueList = options[0].getStringListValue();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"a", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"b", (String)valueList[1]);
        String[] builtInList = options[0].getBuiltIns();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)builtInList.length);
        ManagedBuildCoreTests20.assertEquals((String)"c", (String)builtInList[0]);
        ManagedBuildCoreTests20.assertEquals((String)options[0].getCommand(), (String)"-L");
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)options[1].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)options[1].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)options[1].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)options[1].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)options[2].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)options[2].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"x", (String)options[2].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)options[3].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)options[3].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)options[3].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"-str", (String)options[3].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)options[4].getName());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)options[4].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"default.enum.option", (String)options[4].getSelectedEnum());
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)options[4].getEnumCommand("default.enum.option"));
        valueList = options[4].getApplicableValues();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"Default Enum", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)options[4].getEnumCommand(valueList[0]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)options[4].getEnumCommand(valueList[1]));
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)options[5].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)options[5].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)options[5].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)options[5].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-nob", (String)options[5].getCommandFalse());
        IOptionCategory topCategory = rootTool.getTopOptionCategory();
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)topCategory.getName());
        Object[][] catoptions = topCategory.getOptions(configs[0]);
        int i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)((IOption)catoptions[0][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)((IOption)catoptions[1][1]).getName());
        IOptionCategory[] categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        ManagedBuildCoreTests20.assertEquals((String)"Category", (String)categories[0].getName());
        catoptions = categories[0].getOptions(configs[0]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)((IOption)catoptions[0][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)((IOption)catoptions[1][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)((IOption)catoptions[2][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)((IOption)catoptions[3][1]).getName());
        configs = type.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((int)3, (int)configs.length);
        IConfiguration rootConfig = configs[0];
        ManagedBuildCoreTests20.assertEquals((String)"Root Config", (String)rootConfig.getName());
        tools = rootConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        ManagedBuildCoreTests20.assertEquals((String)"-r", (String)tools[0].getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("foo"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("bar"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].producesFileType(rootExt));
        ManagedBuildCoreTests20.assertEquals((String)"doIt", (String)tools[0].getToolCommand());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)tools[0].getOutputPrefix());
        ManagedBuildCoreTests20.assertTrue((boolean)rootTool.isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertEquals((int)0, (int)rootTool.getNatureFilter());
        ManagedBuildCoreTests20.assertEquals((String)"Root Override Config", (String)configs[1].getName());
        tools = configs[1].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        topCategory = tools[0].getTopOptionCategory();
        catoptions = topCategory.getOptions(configs[1]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)((IOption)catoptions[0][1]).getName());
        valueList = ((IOption)catoptions[0][1]).getStringListValue();
        ManagedBuildCoreTests20.assertEquals((String)"a", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"b", (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)((IOption)catoptions[1][1]).getName());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)((IOption)catoptions[1][1]).getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)((IOption)catoptions[1][1]).getCommand());
        categories = topCategory.getChildCategories();
        catoptions = categories[0].getOptions(configs[1]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)((IOption)catoptions[0][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"y", (String)((IOption)catoptions[0][1]).getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)((IOption)catoptions[1][1]).getName());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)((IOption)catoptions[1][1]).getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)((IOption)catoptions[2][1]).getName());
        valueList = ((IOption)catoptions[2][1]).getApplicableValues();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"Default Enum", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)((IOption)catoptions[2][1]).getEnumCommand(valueList[0]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)((IOption)catoptions[2][1]).getEnumCommand(valueList[1]));
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)((IOption)catoptions[3][1]).getName());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)((IOption)catoptions[3][1]).getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)((IOption)catoptions[3][1]).getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-nob", (String)((IOption)catoptions[3][1]).getCommandFalse());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ITool tool = tools[0];
        ManagedBuildCoreTests20.assertNotNull((Object)tool);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tool.getName());
        ManagedBuildCoreTests20.assertEquals((String)"-r", (String)tool.getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)tool.buildsFileType("foo"));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.buildsFileType("bar"));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.producesFileType(rootExt));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertEquals((String)"doIt", (String)tool.getToolCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-La -Lb -b y -e1 -nob", (String)tool.getToolFlags());
        ManagedBuildCoreTests20.assertEquals((String)"Complete Override Config", (String)configs[2].getName());
        tools = configs[2].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        topCategory = tools[0].getTopOptionCategory();
        catoptions = topCategory.getOptions(configs[2]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)((IOption)catoptions[0][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)((IOption)catoptions[0][1]).getValueType());
        valueList = ((IOption)catoptions[0][1]).getStringListValue();
        ManagedBuildCoreTests20.assertTrue((valueList.length == 3 ? 1 : 0) != 0);
        ManagedBuildCoreTests20.assertEquals((String)"d", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"e", (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"f", (String)valueList[2]);
        ManagedBuildCoreTests20.assertEquals((String)"-L", (String)((IOption)catoptions[0][1]).getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)((IOption)catoptions[1][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)((IOption)catoptions[1][1]).getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)((IOption)catoptions[1][1]).getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)((IOption)catoptions[1][1]).getCommand());
        categories = topCategory.getChildCategories();
        catoptions = categories[0].getOptions(configs[2]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)((IOption)catoptions[0][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)((IOption)catoptions[0][1]).getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"overridden", (String)((IOption)catoptions[0][1]).getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)((IOption)catoptions[1][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)((IOption)catoptions[1][1]).getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"alsooverridden", (String)((IOption)catoptions[1][1]).getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)((IOption)catoptions[2][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)((IOption)catoptions[2][1]).getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"another.enum.option", (String)((IOption)catoptions[2][1]).getSelectedEnum());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)((IOption)catoptions[3][1]).getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)((IOption)catoptions[3][1]).getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)((IOption)catoptions[3][1]).getBooleanValue());
        tool = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)"-Ld -Le -Lf -b overridden -stralsooverridden -e2", (String)tool.getToolFlags());
        ManagedBuildCoreTests20.assertNotNull((Object)ManagedBuildManager.getBuildfileGenerator((IConfiguration)configs[0]));
    }

    private void checkRootManagedProject(IManagedProject managedProj, String testValue) throws BuildException {
        String expectedCleanCmd = "del /myworld";
        String expectedParserId = "org.eclipse.cdt.core.PE";
        Object[] expectedOSList = new String[]{"win32"};
        Object[] expectedArchList = new String[]{"all"};
        ManagedBuildCoreTests20.assertTrue((boolean)managedProj.getProjectType().isTestProjectType());
        IConfiguration[] configs = managedProj.getConfigurations();
        if (configs[0].getArtifactName().equals(projectName)) {
            ManagedBuildCoreTests20.assertEquals((String)configs[0].getArtifactExtension(), (String)newExt);
        } else {
            ManagedBuildCoreTests20.assertEquals((String)configs[0].getArtifactExtension(), (String)rootExt);
        }
        ManagedBuildCoreTests20.assertEquals((String)expectedCleanCmd, (String)configs[0].getCleanCommand());
        ManagedBuildCoreTests20.assertEquals((String)"make", (String)configs[0].getBuildCommand());
        IToolChain toolChain = configs[0].getToolChain();
        ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
        String[] binaryParsers = targetPlatform.getBinaryParserList();
        ManagedBuildCoreTests20.assertEquals((int)binaryParsers.length, (int)1);
        ManagedBuildCoreTests20.assertEquals((String)binaryParsers[0], (String)expectedParserId);
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedOSList, toolChain.getOSList()));
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedArchList, toolChain.getArchList()));
        ManagedBuildCoreTests20.assertNull((Object)configs[0].getErrorParserIds());
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(configs[0].getErrorParserList(), CCorePlugin.getDefault().getAllErrorParsersIDs()));
        ITool[] tools = configs[0].getTools();
        ITool rootTool = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)rootTool.getName());
        IOption[] options = rootTool.getOptions();
        ManagedBuildCoreTests20.assertEquals((int)6, (int)options.length);
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)options[0].getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)options[0].getValueType());
        String[] valueList = options[0].getStringListValue();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"a", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"b", (String)valueList[1]);
        String[] builtInList = options[0].getBuiltIns();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)builtInList.length);
        ManagedBuildCoreTests20.assertEquals((String)"c", (String)builtInList[0]);
        ManagedBuildCoreTests20.assertEquals((String)options[0].getCommand(), (String)"-L");
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)options[1].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)options[1].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)options[1].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)options[1].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)options[2].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)options[2].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)testValue, (String)options[2].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)options[3].getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)options[3].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)options[3].getStringValue());
        ManagedBuildCoreTests20.assertEquals((String)"-str", (String)options[3].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)options[4].getName());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)options[4].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"default.enum.option", (String)options[4].getSelectedEnum());
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)options[4].getEnumCommand("default.enum.option"));
        valueList = options[4].getApplicableValues();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"Default Enum", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)options[4].getEnumCommand(valueList[0]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)options[4].getEnumCommand(valueList[1]));
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)options[5].getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)options[5].getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)options[5].getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)options[5].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-nob", (String)options[5].getCommandFalse());
        IOptionCategory topCategory = rootTool.getTopOptionCategory();
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)topCategory.getName());
        Object[][] catoptions = topCategory.getOptions(configs[0]);
        int i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        IOption catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)catOption.getName());
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)catOption.getName());
        IOptionCategory[] categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        ManagedBuildCoreTests20.assertEquals((String)"Category", (String)categories[0].getName());
        catoptions = categories[0].getOptions(configs[0]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)catOption.getName());
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)catOption.getName());
        catOption = (IOption)catoptions[2][1];
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)catOption.getName());
        catOption = (IOption)catoptions[3][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)configs.length);
        IConfiguration rootConfig = configs[0];
        ManagedBuildCoreTests20.assertEquals((String)"Root Config", (String)rootConfig.getName());
        tools = rootConfig.getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        ManagedBuildCoreTests20.assertEquals((String)"-r", (String)tools[0].getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("foo"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("bar"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].producesFileType(rootExt));
        ManagedBuildCoreTests20.assertEquals((String)"doIt", (String)tools[0].getToolCommand());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)tools[0].getOutputPrefix());
        ManagedBuildCoreTests20.assertTrue((boolean)rootTool.isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertEquals((int)0, (int)rootTool.getNatureFilter());
        ManagedBuildCoreTests20.assertEquals((String)"Root Override Config", (String)configs[1].getName());
        tools = configs[1].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        topCategory = tools[0].getTopOptionCategory();
        catoptions = topCategory.getOptions(configs[1]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)catOption.getName());
        valueList = catOption.getStringListValue();
        ManagedBuildCoreTests20.assertEquals((String)"a", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"b", (String)valueList[1]);
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)catOption.getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)catOption.getCommand());
        categories = topCategory.getChildCategories();
        catoptions = categories[0].getOptions(configs[1]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((String)"y", (String)catOption.getStringValue());
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)catOption.getStringValue());
        catOption = (IOption)catoptions[2][1];
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)catOption.getName());
        valueList = catOption.getApplicableValues();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)valueList.length);
        ManagedBuildCoreTests20.assertEquals((String)"Default Enum", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)enumVal, (String)valueList[1]);
        catOption = (IOption)catoptions[2][1];
        ManagedBuildCoreTests20.assertEquals((String)"-e1", (String)catOption.getEnumCommand(valueList[0]));
        ManagedBuildCoreTests20.assertEquals((String)"-e2", (String)catOption.getEnumCommand(valueList[1]));
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        catOption = (IOption)catoptions[3][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((boolean)false, (boolean)catOption.getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)catOption.getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-nob", (String)catOption.getCommandFalse());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ITool tool = tools[0];
        ManagedBuildCoreTests20.assertNotNull((Object)tool);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tool.getName());
        ManagedBuildCoreTests20.assertEquals((String)"-r", (String)tool.getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)tool.buildsFileType("foo"));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.buildsFileType("bar"));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.producesFileType(rootExt));
        ManagedBuildCoreTests20.assertTrue((boolean)tool.isHeaderFile("baz"));
        ManagedBuildCoreTests20.assertEquals((String)"doIt", (String)tool.getToolCommand());
        ManagedBuildCoreTests20.assertEquals((String)"-La -Lb -b y -e1 -nob", (String)tool.getToolFlags());
        ManagedBuildCoreTests20.assertEquals((String)"Complete Override Config", (String)configs[2].getName());
        tools = configs[2].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)tools[0].getName());
        topCategory = tools[0].getTopOptionCategory();
        catoptions = topCategory.getOptions(configs[2]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)2, (int)i);
        catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"List Option in Top", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)catOption.getValueType());
        valueList = catOption.getStringListValue();
        ManagedBuildCoreTests20.assertTrue((valueList.length == 3 ? 1 : 0) != 0);
        ManagedBuildCoreTests20.assertEquals((String)"d", (String)valueList[0]);
        ManagedBuildCoreTests20.assertEquals((String)"e", (String)valueList[1]);
        ManagedBuildCoreTests20.assertEquals((String)"f", (String)valueList[2]);
        ManagedBuildCoreTests20.assertEquals((String)"-L", (String)catOption.getCommand());
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Top", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)catOption.getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)catOption.getBooleanValue());
        ManagedBuildCoreTests20.assertEquals((String)"-b", (String)catOption.getCommand());
        categories = topCategory.getChildCategories();
        catoptions = categories[0].getOptions(configs[2]);
        i = 0;
        while (i < catoptions.length) {
            if (catoptions[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)4, (int)i);
        catOption = (IOption)catoptions[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"String Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)catOption.getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"overridden", (String)catOption.getStringValue());
        catOption = (IOption)catoptions[1][1];
        ManagedBuildCoreTests20.assertEquals((String)"Another String Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)catOption.getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"alsooverridden", (String)catOption.getStringValue());
        catOption = (IOption)catoptions[2][1];
        ManagedBuildCoreTests20.assertEquals((String)"Enumerated Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)catOption.getValueType());
        ManagedBuildCoreTests20.assertEquals((String)"another.enum.option", (String)catOption.getSelectedEnum());
        catOption = (IOption)catoptions[3][1];
        ManagedBuildCoreTests20.assertEquals((String)"Boolean Option in Category", (String)catOption.getName());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)catOption.getValueType());
        ManagedBuildCoreTests20.assertEquals((boolean)true, (boolean)catOption.getBooleanValue());
        tool = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)"-Ld -Le -Lf -b overridden -stralsooverridden -e2", (String)tool.getToolFlags());
        ManagedBuildCoreTests20.assertNotNull((Object)ManagedBuildManager.getBuildfileGenerator((IConfiguration)configs[0]));
    }

    private void checkSubSubProjectType(IProjectType projType) {
        IConfiguration[] configs = projType.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((String)"rm -yourworld", (String)configs[0].getCleanCommand());
        ManagedBuildCoreTests20.assertEquals((String)"nmake", (String)configs[0].getBuildCommand());
        IToolChain toolChain = configs[0].getToolChain();
        ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
        ManagedBuildCoreTests20.assertEquals((String)"org.eclipse.cdt.core.ELF", (String)targetPlatform.getBinaryParserList()[0]);
        Object[] expectedOSList = new String[]{"win32", "linux", "solaris"};
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedOSList, toolChain.getOSList()));
        Object[] expectedArchList = new String[]{"x86", "ppc"};
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedArchList, toolChain.getArchList()));
        ManagedBuildCoreTests20.assertEquals((int)5, (int)configs.length);
        ITool[] tools = configs[0].getTools();
        ManagedBuildCoreTests20.assertEquals((int)3, (int)tools.length);
        ITool toolRef = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)toolRef.getName(), (String)"Target Independent Tool");
        ManagedBuildCoreTests20.assertEquals((String)toolRef.getToolCommand(), (String)"RC.EXE");
        ManagedBuildCoreTests20.assertTrue((boolean)toolRef.buildsFileType("rc"));
        ManagedBuildCoreTests20.assertEquals((String)toolRef.getOutputExtension("rc"), (String)"free");
        ManagedBuildCoreTests20.assertEquals((String)toolRef.getOutputFlag(), (String)"/fo");
        ManagedBuildCoreTests20.assertTrue((boolean)toolRef.isHeaderFile("h"));
        ManagedBuildCoreTests20.assertFalse((boolean)toolRef.isHeaderFile("j"));
        ManagedBuildCoreTests20.assertEquals((int)toolRef.getNatureFilter(), (int)2);
        IOptionCategory topCategory = toolRef.getTopOptionCategory();
        IOptionCategory[] categories = topCategory.getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)categories.length);
        ManagedBuildCoreTests20.assertEquals((String)categories[0].getName(), (String)"Free");
        IOptionCategory[] subCategories = categories[0].getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)subCategories.length);
        ManagedBuildCoreTests20.assertEquals((String)subCategories[0].getName(), (String)"Chained");
        Object[][] optsInCat = categories[0].getOptions(configs[0]);
        int i = 0;
        while (i < optsInCat.length) {
            if (optsInCat[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)1, (int)i);
        IOption optCat = (IOption)optsInCat[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"String in Free", (String)optCat.getName());
        try {
            ManagedBuildCoreTests20.assertEquals((int)2, (int)optCat.getValueType());
            IOption stringOpt = toolRef.getOptionById(optCat.getId());
            ManagedBuildCoreTests20.assertTrue((boolean)(stringOpt instanceof Option));
            ManagedBuildCoreTests20.assertEquals((String)"Live free or die", (String)stringOpt.getStringValue());
        }
        catch (BuildException e1) {
            ManagedBuildCoreTests20.fail((String)("Failed getting string value in subsub :" + e1.getLocalizedMessage()));
        }
        Object[][] optsInSubCat = subCategories[0].getOptions(configs[0]);
        i = 0;
        while (i < optsInSubCat.length) {
            if (optsInSubCat[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)1, (int)i);
        IOption booleanRef = toolRef.getOptionById(((IOption)optsInSubCat[0][1]).getId());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean in Chained", (String)booleanRef.getName());
        try {
            ManagedBuildCoreTests20.assertEquals((int)0, (int)booleanRef.getValueType());
            ManagedBuildCoreTests20.assertTrue((boolean)booleanRef.getBooleanValue());
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure getting boolean value in subsub: " + e.getLocalizedMessage()));
        }
        toolRef.setToolCommand("Let the Wookie win");
        ManagedBuildCoreTests20.assertEquals((String)toolRef.getToolCommand(), (String)"Let the Wookie win");
        IConfiguration subSubConfig = projType.getConfiguration("sub.sub.config");
        ManagedBuildCoreTests20.assertNotNull((Object)subSubConfig);
        ITool[] configTools = subSubConfig.getTools();
        ITool configToolRef = configTools[0];
        ManagedBuildCoreTests20.assertNotNull((Object)configToolRef);
        optCat = (IOption)optsInCat[0][1];
        IOption configStringOpt = configToolRef.getOptionById(optCat.getId());
        ManagedBuildCoreTests20.assertNotNull((Object)configStringOpt);
        try {
            subSubConfig.setOption((IHoldsOptions)configToolRef, configStringOpt, "The future language of slaves");
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure setting string value in subsubconfiguration: " + e.getLocalizedMessage()));
        }
        configTools = subSubConfig.getTools();
        configToolRef = configTools[0];
        ManagedBuildCoreTests20.assertNotNull((Object)configToolRef);
        optsInCat = categories[0].getOptions(configs[0]);
        i = 0;
        while (i < optsInCat.length) {
            if (optsInCat[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)1, (int)i);
        optCat = (IOption)optsInCat[0][1];
        ManagedBuildCoreTests20.assertEquals((String)"String in Free", (String)optCat.getName());
        configStringOpt = configToolRef.getOptionById(optCat.getId());
        try {
            ManagedBuildCoreTests20.assertEquals((String)"The future language of slaves", (String)configStringOpt.getStringValue());
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure getting string value in subsubconfiguration: " + e.getLocalizedMessage()));
        }
        IOption optSubCat = (IOption)optsInSubCat[0][1];
        IOption configBoolOpt = configToolRef.getOptionById(optSubCat.getId());
        ManagedBuildCoreTests20.assertNotNull((Object)configBoolOpt);
        try {
            ManagedBuildCoreTests20.assertTrue((boolean)configBoolOpt.getBooleanValue());
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure getting boolean value in subsubconfiguration: " + e.getLocalizedMessage()));
        }
        try {
            subSubConfig.setOption((IHoldsOptions)configToolRef, configBoolOpt, false);
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure setting boolean value in subsubconfiguration: " + e.getLocalizedMessage()));
        }
        optsInSubCat = subCategories[0].getOptions(configs[0]);
        i = 0;
        while (i < optsInSubCat.length) {
            if (optsInSubCat[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)1, (int)i);
        configBoolOpt = configToolRef.getOptionById(((IOption)optsInSubCat[0][1]).getId());
        ManagedBuildCoreTests20.assertEquals((String)"Boolean in Chained", (String)booleanRef.getName());
        try {
            ManagedBuildCoreTests20.assertFalse((boolean)configBoolOpt.getBooleanValue());
        }
        catch (BuildException e) {
            ManagedBuildCoreTests20.fail((String)("Failure getting boolean value in subsubconfiguration: " + e.getLocalizedMessage()));
        }
    }

    private void checkSubProjectType(IProjectType projType) throws BuildException {
        IConfiguration[] configs = projType.getConfigurations();
        ManagedBuildCoreTests20.assertEquals((String)"rm -yourworld", (String)configs[0].getCleanCommand());
        ManagedBuildCoreTests20.assertEquals((String)"make", (String)configs[0].getBuildCommand());
        IToolChain toolChain = configs[0].getToolChain();
        ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
        ManagedBuildCoreTests20.assertEquals((String)"org.eclipse.cdt.core.PE", (String)targetPlatform.getBinaryParserList()[0]);
        Object[] expectedOSList = new String[]{"win32", "linux", "solaris"};
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedOSList, toolChain.getOSList()));
        Object[] expectedArchList = new String[]{"x86", "ppc"};
        ManagedBuildCoreTests20.assertTrue((boolean)Arrays.equals(expectedArchList, toolChain.getArchList()));
        ManagedBuildCoreTests20.assertTrue((boolean)projType.isTestProjectType());
        ManagedBuildCoreTests20.assertEquals((String)configs[0].getArtifactExtension(), (String)subExt);
        ITool[] tools = configs[0].getTools();
        ITool rootTool = tools[0];
        ManagedBuildCoreTests20.assertEquals((String)"Root Tool", (String)rootTool.getName());
        ITool subTool = tools[1];
        ManagedBuildCoreTests20.assertEquals((String)"Sub Tool", (String)subTool.getName());
        IOption[] subOpts = subTool.getOptions();
        ManagedBuildCoreTests20.assertEquals((int)5, (int)subOpts.length);
        ManagedBuildCoreTests20.assertEquals((String)"", (String)subTool.getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)subTool.buildsFileType("yarf"));
        ManagedBuildCoreTests20.assertTrue((boolean)subTool.producesFileType(subExt));
        ManagedBuildCoreTests20.assertEquals((String)"", (String)subTool.getToolCommand());
        ManagedBuildCoreTests20.assertEquals((String)"lib", (String)subTool.getOutputPrefix());
        ManagedBuildCoreTests20.assertTrue((boolean)subTool.isHeaderFile("arf"));
        ManagedBuildCoreTests20.assertTrue((boolean)subTool.isHeaderFile("barf"));
        ManagedBuildCoreTests20.assertEquals((int)2, (int)subTool.getNatureFilter());
        ManagedBuildCoreTests20.assertEquals((String)"Include Paths", (String)subOpts[0].getName());
        ManagedBuildCoreTests20.assertEquals((int)4, (int)subOpts[0].getValueType());
        String[] incPath = subOpts[0].getIncludePaths();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)incPath.length);
        ManagedBuildCoreTests20.assertEquals((String)"/usr/include", (String)incPath[0]);
        ManagedBuildCoreTests20.assertEquals((String)"/opt/gnome/include", (String)incPath[1]);
        String[] builtInPaths = subOpts[0].getBuiltIns();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)builtInPaths.length);
        ManagedBuildCoreTests20.assertEquals((String)"/usr/gnu/include", (String)builtInPaths[0]);
        ManagedBuildCoreTests20.assertEquals((String)"-I", (String)subOpts[0].getCommand());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)subOpts[0].getBrowseType());
        ManagedBuildCoreTests20.assertEquals((String)"Defined Symbols", (String)subOpts[1].getName());
        ManagedBuildCoreTests20.assertEquals((int)5, (int)subOpts[1].getValueType());
        String[] defdSymbols = subOpts[1].getDefinedSymbols();
        ManagedBuildCoreTests20.assertEquals((int)0, (int)defdSymbols.length);
        ManagedBuildCoreTests20.assertEquals((String)"-D", (String)subOpts[1].getCommand());
        String[] builtInSymbols = subOpts[1].getBuiltIns();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)builtInSymbols.length);
        ManagedBuildCoreTests20.assertEquals((String)"BUILTIN", (String)builtInSymbols[0]);
        ManagedBuildCoreTests20.assertEquals((int)0, (int)subOpts[1].getBrowseType());
        ManagedBuildCoreTests20.assertEquals((String)"More Includes", (String)subOpts[2].getName());
        ManagedBuildCoreTests20.assertEquals((int)4, (int)subOpts[2].getValueType());
        String[] moreIncPath = subOpts[2].getIncludePaths();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)moreIncPath.length);
        ManagedBuildCoreTests20.assertEquals((String)"C:\\home\\tester/include", (String)moreIncPath[0]);
        ManagedBuildCoreTests20.assertEquals((String)"-I", (String)subOpts[2].getCommand());
        ManagedBuildCoreTests20.assertEquals((int)2, (int)subOpts[2].getBrowseType());
        ManagedBuildCoreTests20.assertEquals((String)"User Objects", (String)subOpts[3].getName());
        ManagedBuildCoreTests20.assertEquals((int)7, (int)subOpts[3].getValueType());
        String[] objs = subOpts[3].getUserObjects();
        ManagedBuildCoreTests20.assertEquals((int)2, (int)objs.length);
        ManagedBuildCoreTests20.assertEquals((String)"obj1.o", (String)objs[0]);
        ManagedBuildCoreTests20.assertEquals((String)"obj2.o", (String)objs[1]);
        ManagedBuildCoreTests20.assertEquals((int)1, (int)subOpts[3].getBrowseType());
        ManagedBuildCoreTests20.assertEquals((String)"", (String)subOpts[3].getCommand());
        ManagedBuildCoreTests20.assertEquals((String)"No Command StringList", (String)subOpts[4].getName());
        ManagedBuildCoreTests20.assertEquals((int)3, (int)subOpts[4].getValueType());
        ManagedBuildCoreTests20.assertEquals((String)subTool.getToolFlags(), (String)"-I/usr/include -I/opt/gnome/include -IC:\\home\\tester/include -I\"../includes\" x y z");
        ManagedBuildCoreTests20.assertEquals((int)4, (int)configs.length);
        ManagedBuildCoreTests20.assertEquals((String)"Sub Config", (String)configs[0].getName());
        ManagedBuildCoreTests20.assertEquals((String)"Root Config", (String)configs[1].getName());
        ManagedBuildCoreTests20.assertEquals((String)"Root Override Config", (String)configs[2].getName());
        ManagedBuildCoreTests20.assertEquals((String)"Complete Override Config", (String)configs[3].getName());
    }

    private void checkForwardProjectTypes(IProjectType parent, IProjectType child, IProjectType grandchild) {
        ManagedBuildCoreTests20.assertEquals((Object)parent, (Object)child.getSuperClass());
        ManagedBuildCoreTests20.assertEquals((Object)child, (Object)grandchild.getSuperClass());
        IConfiguration[] parentConfigs = parent.getConfigurations();
        ITool[] parentTools = parentConfigs[0].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)parentTools.length);
        ITool parentTool = parentTools[0];
        ManagedBuildCoreTests20.assertNotNull((Object)parentTool);
        IOption option = parentTool.getOptionById("test.forward.option");
        ManagedBuildCoreTests20.assertNotNull((Object)option);
        IOptionCategory[] firstLevel = parentTool.getTopOptionCategory().getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)firstLevel.length);
        IOptionCategory[] secondLevel = firstLevel[0].getChildCategories();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)secondLevel.length);
        ManagedBuildCoreTests20.assertEquals((int)0, (int)secondLevel[0].getChildCategories().length);
        Object[][] optList = secondLevel[0].getOptions(parentConfigs[0]);
        int i = 0;
        while (i < optList.length) {
            if (optList[i][0] == null) break;
            ++i;
        }
        ManagedBuildCoreTests20.assertEquals((int)1, (int)i);
        ManagedBuildCoreTests20.assertEquals((Object)option, (Object)optList[0][1]);
        IConfiguration[] childConfigs = child.getConfigurations();
        ITool[] childTools = childConfigs[0].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)childTools.length);
        ITool childToolRef = childTools[0];
        ManagedBuildCoreTests20.assertEquals((Object)parentTool.getSuperClass(), (Object)childToolRef.getSuperClass());
        IOption optRef = childToolRef.getOptionById("test.forward.option");
        ManagedBuildCoreTests20.assertEquals((Object)option, (Object)optRef);
        IConfiguration[] grandConfigs = grandchild.getConfigurations();
        ITool[] grandTools = grandConfigs[0].getTools();
        ManagedBuildCoreTests20.assertEquals((int)1, (int)grandTools.length);
        ITool grandToolRef = grandTools[0];
        ManagedBuildCoreTests20.assertEquals((Object)parentTool.getSuperClass(), (Object)grandToolRef.getSuperClass());
    }

    public void checkProviderProjectType(IProjectType projType) throws Exception {
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("test_commands"));
        String command = props.getProperty(projType.getId());
        ManagedBuildCoreTests20.assertNotNull((Object)command);
        IProjectType parent = projType.getSuperClass();
        ManagedBuildCoreTests20.assertNotNull((Object)parent);
        ManagedBuildCoreTests20.assertEquals((String)"test.forward.parent.target", (String)parent.getId());
        IConfiguration[] configs = projType.getConfigurations();
        ITool toolRef = configs[0].getFilteredTools()[0];
        ManagedBuildCoreTests20.assertEquals((String)command, (String)toolRef.getToolCommand());
    }

    public void cleanup() {
        this.removeProject(projectName);
        this.removeProject(projectName2);
    }

    private IProject createProject(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            project = CCorePlugin.getDefault().createCProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
            ManagedBuildTestHelper.addManagedBuildNature(project);
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    private void removeProject(String name) {
        block12: {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(name);
            if (project.exists()) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            System.gc();
                            System.runFinalization();
                            project.delete(true, true, null);
                        }
                        catch (CoreException coreException) {
                            ManagedBuildCoreTests20.assertTrue((boolean)false);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.gc();
                        System.runFinalization();
                        project.delete(true, true, null);
                    }
                    catch (CoreException coreException) {
                        ManagedBuildCoreTests20.assertTrue((boolean)false);
                    }
                    throw throwable;
                }
                try {
                    System.gc();
                    System.runFinalization();
                    project.delete(true, true, null);
                }
                catch (CoreException coreException) {
                    ManagedBuildCoreTests20.assertTrue((boolean)false);
                }
            }
        }
    }

    public void testErrorParsers() throws BuildException {
        IProject project = null;
        try {
            project = this.createProject(projectName2);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests20.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Test failed on error parser project creation: " + e.getLocalizedMessage()));
        }
        IProjectType projType = ManagedBuildManager.getProjectType((String)"test.error.parsers");
        ManagedBuildCoreTests20.assertNotNull((Object)projType);
        IManagedProject newProj = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ManagedBuildCoreTests20.assertEquals((String)newProj.getName(), (String)projType.getName());
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        ManagedBuildManager.getBuildInfo((IResource)project).setValid(true);
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)project);
        if (initResult.getCode() != 0) {
            ManagedBuildCoreTests20.fail((String)("Initializing build information failed for: " + project.getName() + " because: " + initResult.getMessage()));
        }
        IConfiguration[] baseConfigs = projType.getConfigurations();
        int i = 0;
        while (i < baseConfigs.length) {
            newProj.createConfiguration(baseConfigs[i], String.valueOf(baseConfigs[i].getId()) + "." + i);
            ++i;
        }
        this.checkErrorParsersProject(newProj);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        try {
            project.close(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on error parser project close: " + e.getLocalizedMessage()));
        }
        try {
            project.open(null);
        }
        catch (CoreException e) {
            ManagedBuildCoreTests20.fail((String)("Failed on error parser project open: " + e.getLocalizedMessage()));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        this.checkErrorParsersProject(info.getManagedProject());
        ManagedBuildManager.removeBuildInfo((IResource)project);
    }

    private void checkErrorParsersProject(IManagedProject proj) throws BuildException {
        String expectedBinParserId = "org.eclipse.cdt.core.PE";
        IConfiguration[] configs = proj.getConfigurations();
        IToolChain toolChain = configs[0].getToolChain();
        ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
        ManagedBuildCoreTests20.assertEquals((String)expectedBinParserId, (String)targetPlatform.getBinaryParserList()[0]);
        ManagedBuildCoreTests20.assertEquals((String)"org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser", (String)configs[0].getErrorParserIds());
        ITool[] tools = configs[0].getTools();
        ITool rootTool = tools[0];
        ManagedBuildCoreTests20.assertEquals((int)1, (int)tools.length);
        ManagedBuildCoreTests20.assertEquals((String)"EP Tool", (String)tools[0].getName());
        ManagedBuildCoreTests20.assertEquals((String)"-o", (String)tools[0].getOutputFlag());
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("y"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].buildsFileType("x"));
        ManagedBuildCoreTests20.assertTrue((boolean)tools[0].producesFileType("xy"));
        ManagedBuildCoreTests20.assertEquals((String)"EP", (String)tools[0].getToolCommand());
        ManagedBuildCoreTests20.assertEquals((int)0, (int)rootTool.getNatureFilter());
        ManagedBuildCoreTests20.assertEquals((int)1, (int)configs.length);
    }

    public void testConfigBuildArtifact() throws CoreException {
        IProject project = this.createProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertNotNull((Object)info);
        IManagedProject managedProj = info.getManagedProject();
        ManagedBuildCoreTests20.assertNotNull((Object)managedProj);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        ManagedBuildCoreTests20.assertNotNull((Object)defaultConfig);
        String ext = defaultConfig.getArtifactExtension();
        String name = String.valueOf(project.getName()) + "." + ext;
        defaultConfig.setArtifactName(name);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        project.close(null);
        project.open(null);
        info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedBuildCoreTests20.assertNotNull((Object)info);
        managedProj = info.getManagedProject();
        ManagedBuildCoreTests20.assertNotNull((Object)managedProj);
        defaultConfig = info.getDefaultConfiguration();
        ManagedBuildCoreTests20.assertNotNull((Object)defaultConfig);
        ManagedBuildCoreTests20.assertEquals((String)name, (String)defaultConfig.getArtifactName());
    }

    public void testThatAlwaysFails() {
        ManagedBuildCoreTests20.assertTrue((boolean)false);
    }
}

