/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.projectmodel.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class CProjectDescriptionSerializationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CProjectDescriptionSerializationTests.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testTooManyConfigurations() throws Exception {
        String projectName = "testTooManyConfigurations";
        String pluginProjectTypeId = "cdt.managedbuild.target.gnu.cygwin.exe";
        CoreModel coreModel = CoreModel.getDefault();
        IProject project = BuildSystemTestHelper.createProject(projectName);
        ICProjectDescription des = coreModel.createProjectDescription(project, false);
        Assert.assertNotNull((String)"createDescription returned null!", (Object)des);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)pluginProjectTypeId);
        Assert.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        Assert.assertNotNull((String)"configurations not found", (Object)cfgs);
        Assert.assertTrue((String)"no configurations found in the project type", (cfgs.length > 0 ? 1 : 0) != 0);
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            String id = ManagedBuildManager.calculateChildId((String)configuration.getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)configuration, id, false, true, false);
            CConfigurationData data = config.getConfigurationData();
            Assert.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
            ++n2;
        }
        Assert.assertEquals((int)2, (int)des.getConfigurations().length);
        coreModel.setProjectDescription(project, des);
        project.close(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.setAutoBuilding(false);
        workspace.setDescription(workspaceDesc);
        int i = 0;
        while (i < 144) {
            IProject project2 = root.getProject(projectName);
            project2.open(null);
            Assert.assertEquals((boolean)true, (boolean)project2.isOpen());
            ICProjectDescription des2 = coreModel.getProjectDescription(project2);
            Assert.assertEquals((int)2, (int)des2.getConfigurations().length);
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project2);
            String[] configurationNames = buildInfo.getConfigurationNames();
            Assert.assertNotNull((String)"buildInfo.getConfigurationNames() returned null", (Object)configurationNames);
            IConfiguration[] configurations = buildInfo.getManagedProject().getConfigurations();
            if (configurations.length != 2) {
                String message = String.valueOf(i) + "-th round: Invalid number (not 2) of configurations loaded. ";
                IConfiguration[] iConfigurationArray2 = configurations;
                int n3 = configurations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfiguration configuration = iConfigurationArray2[n4];
                    message = String.valueOf(message) + "[" + configuration.getName() + "], ";
                    ++n4;
                }
                Assert.assertEquals((String)message, (int)2, (int)configurations.length);
            }
            project2.close(null);
            ++i;
        }
    }

    public void testPersistentProperties() throws Exception {
        CoreModel coreModel = CoreModel.getDefault();
        coreModel.getProjectDescriptionManager();
        String pluginProjectTypeId = "cdt.managedbuild.target.gnu.cygwin.exe";
        IProject project = BuildSystemTestHelper.createProject("testPersistentProperties");
        ICProjectDescription des = coreModel.createProjectDescription(project, false);
        Assert.assertNotNull((String)"createDescription returned null!", (Object)des);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)pluginProjectTypeId);
        Assert.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        Assert.assertNotNull((String)"configurations not found", (Object)cfgs);
        Assert.assertTrue((String)"no configurations found in the project type", (cfgs.length > 0 ? 1 : 0) != 0);
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            String id = ManagedBuildManager.calculateChildId((String)configuration.getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)configuration, id, false, true, false);
            CConfigurationData data = config.getConfigurationData();
            Assert.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
            ++n2;
        }
        Assert.assertEquals((int)2, (int)des.getConfigurations().length);
        coreModel.setProjectDescription(project, des);
        Assert.assertEquals((Object)project, (Object)des.getProject());
        Thread.sleep(1000L);
        try {
            QualifiedName pdomName = new QualifiedName("org.eclipse.cdt.core", "pdomName");
            QualifiedName activeCfg = new QualifiedName("org.eclipse.cdt.core", "activeConfiguration");
            QualifiedName settingCfg = new QualifiedName("org.eclipse.cdt.core", "settingConfiguration");
            QualifiedName discoveredScannerConfigFileName = new QualifiedName("org.eclipse.cdt.make.core", "discoveredScannerConfigFileName");
            CProjectDescriptionSerializationTests.assertTrue((String)"pdomName", (boolean)project.getPersistentProperties().containsKey(pdomName));
            CProjectDescriptionSerializationTests.assertTrue((String)"activeCfg", (boolean)project.getPersistentProperties().containsKey(activeCfg));
            CProjectDescriptionSerializationTests.assertTrue((String)"discoveredScannerConfigFileName", (boolean)project.getPersistentProperties().containsKey(discoveredScannerConfigFileName));
            CProjectDescriptionSerializationTests.assertTrue((String)"settingCfg", (boolean)project.getPersistentProperties().containsKey(settingCfg));
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        project.close(null);
    }
}

