/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.DefaultDsfModelSelectionPolicyFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.pda.launch.PDALaunch;
import org.eclipse.cdt.examples.dsf.pda.ui.actions.PDATerminateCommand;
import org.eclipse.cdt.examples.dsf.pda.ui.viewmodel.PDAVMAdapter;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public class PDAAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private static Map<PDALaunch, LaunchAdapterSet> fgLaunchAdapterSets = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, Object> fgDisposedLaunchAdapterSets = new WeakHashMap<ILaunch, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<PDALaunch, LaunchAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgLaunchAdapterSets.containsKey(launch)) {
                fgLaunchAdapterSets.remove(launch).dispose();
                fgDisposedLaunchAdapterSets.put(launch, null);
            }
        }
    }

    public PDAAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        LaunchAdapterSet adapterSet;
        if (!(adaptableObject instanceof PDALaunch)) {
            return null;
        }
        PDALaunch launch = (PDALaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<PDALaunch, LaunchAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            block9: {
                if (!fgDisposedLaunchAdapterSets.containsKey(launch)) break block9;
                return null;
            }
            adapterSet = fgLaunchAdapterSets.get(launch);
            if (adapterSet == null) {
                adapterSet = new LaunchAdapterSet(launch);
                fgLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, IColumnPresentationFactory.class};
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof PDALaunch) {
                PDAAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Immutable
    private static class LaunchAdapterSet {
        final PDAVMAdapter fViewModelAdapter;
        final DsfSourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final PDATerminateCommand fTerminateCommand;
        final IDebugModelProvider fDebugModelProvider;
        final PDALaunch fLaunch;
        final SteppingController fSteppingController;
        private IModelSelectionPolicyFactory fModelSelectionPolicyFactory;

        LaunchAdapterSet(PDALaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fSteppingController = new SteppingController(session);
            session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
            this.fViewModelAdapter = new PDAVMAdapter(session, this.fSteppingController);
            this.fSourceDisplayAdapter = new DsfSourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator(), this.fSteppingController);
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fModelSelectionPolicyFactory = new DefaultDsfModelSelectionPolicyFactory();
            session.registerModelAdapter(IModelSelectionPolicyFactory.class, (Object)this.fModelSelectionPolicyFactory);
            this.fStepIntoCommand = new DsfStepIntoCommand(session, null);
            this.fStepOverCommand = new DsfStepOverCommand(session, null);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fTerminateCommand = new PDATerminateCommand(session);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{"org.eclipse.cdt.examples.dsf.pda.debugModel"};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            this.fViewModelAdapter.dispose();
            session.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            session.unregisterModelAdapter(SteppingController.class);
            this.fSteppingController.dispose();
            session.unregisterModelAdapter(IModelSelectionPolicyFactory.class);
            session.unregisterModelAdapter(IStepIntoHandler.class);
            session.unregisterModelAdapter(IStepOverHandler.class);
            session.unregisterModelAdapter(IStepReturnHandler.class);
            session.unregisterModelAdapter(ISuspendHandler.class);
            session.unregisterModelAdapter(IResumeHandler.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            this.fStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fTerminateCommand.dispose();
        }
    }
}

