/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IFunctionInfo;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.browser.IndexModelUtil;
import org.eclipse.cdt.internal.core.browser.IndexTypeReference;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexTypeInfo
implements ITypeInfo,
IFunctionInfo {
    private final String[] fqn;
    private final IIndexFileLocation fileLocal;
    private final int elementType;
    private final IIndex index;
    private final String[] params;
    private final String returnType;
    private ITypeReference reference;

    private static int hashCode(String[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            result = prime * result + (element == null ? 0 : element.hashCode());
            ++n2;
        }
        return result;
    }

    public static IndexTypeInfo create(IIndex index, IIndexBinding binding) {
        String[] fqn;
        int elementType;
        IIndexFileLocation flsq = null;
        try {
            elementType = IndexModelUtil.getElementType(binding);
            if (binding instanceof ICPPBinding) {
                fqn = ((ICPPBinding)((Object)binding)).getQualifiedName();
            } else if (binding instanceof IField) {
                IField field = (IField)((Object)binding);
                ICompositeType owner = field.getCompositeTypeOwner();
                fqn = new String[]{owner.getName(), field.getName()};
            } else {
                fqn = new String[]{binding.getName()};
            }
            try {
                IIndexFile file = binding.getLocalToFile();
                if (file != null) {
                    flsq = file.getLocation();
                }
            }
            catch (CoreException coreException) {}
            if (binding instanceof IFunction) {
                IFunction function = (IFunction)((Object)binding);
                String[] paramTypes = IndexModelUtil.extractParameterTypes(function);
                String returnType = IndexModelUtil.extractReturnType(function);
                return new IndexTypeInfo(fqn, flsq, elementType, index, paramTypes, returnType, null);
            }
        }
        catch (DOMException dOMException) {
            throw new AssertionError();
        }
        return new IndexTypeInfo(fqn, flsq, elementType, index, null, null, null);
    }

    public static IndexTypeInfo create(IIndex index, IIndexMacro macro) {
        char[] name = macro.getNameCharArray();
        char[][] ps = macro.getParameterList();
        String[] params = null;
        if (ps != null) {
            params = new String[ps.length];
            int i = -1;
            char[][] cArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                char[] p = cArray[n2];
                params[++i] = new String(p);
                ++n2;
            }
        }
        return new IndexTypeInfo(new String[]{new String(name)}, 79, params, null, index);
    }

    public static IndexTypeInfo create(IndexTypeInfo rhs, ITypeReference ref) {
        return new IndexTypeInfo(rhs, ref);
    }

    private IndexTypeInfo(String[] fqn, IIndexFileLocation fileLocal, int elementType, IIndex index, String[] params, String returnType, ITypeReference reference) {
        Assert.isTrue((index != null ? 1 : 0) != 0);
        this.fqn = fqn;
        this.fileLocal = fileLocal;
        this.elementType = elementType;
        this.index = index;
        this.params = params;
        this.returnType = returnType;
        this.reference = reference;
    }

    private IndexTypeInfo(String[] fqn, int elementType, String[] params, String returnType, IIndex index) {
        this(fqn, null, elementType, index, params, returnType, null);
    }

    private IndexTypeInfo(IndexTypeInfo rhs, ITypeReference ref) {
        this(rhs.fqn, rhs.fileLocal, rhs.elementType, rhs.index, rhs.params, rhs.returnType, ref);
    }

    @Override
    public int getCElementType() {
        return this.elementType;
    }

    @Override
    public ICProject getEnclosingProject() {
        IProject project;
        if (this.getResolvedReference() != null && (project = this.reference.getProject()) != null) {
            return CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.fqn[this.fqn.length - 1];
    }

    @Override
    public IQualifiedTypeName getQualifiedTypeName() {
        return new QualifiedTypeName(this.fqn);
    }

    @Override
    public String[] getParameters() {
        return this.params;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.elementType;
        result = 31 * result + (this.fileLocal == null ? 0 : this.fileLocal.hashCode());
        result = 31 * result + IndexTypeInfo.hashCode(this.fqn);
        result = 31 * result + IndexTypeInfo.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexTypeInfo other = (IndexTypeInfo)obj;
        if (this.elementType != other.elementType) {
            return false;
        }
        if (this.fileLocal == null ? other.fileLocal != null : !this.fileLocal.equals(other.fileLocal)) {
            return false;
        }
        if (!Arrays.equals(this.fqn, other.fqn)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }

    public boolean isFileLocal() {
        return this.fileLocal != null;
    }

    @Override
    public ITypeReference getResolvedReference() {
        block12: {
            if (this.reference == null) {
                if (this.elementType == 79) {
                    return this.createMacroReference();
                }
                try {
                    try {
                        this.index.acquireReadLock();
                        IIndexBinding[] ibs = this.findBindings();
                        if (ibs.length <= 0) break block12;
                        IIndexName[] names = this.index.findNames(ibs[0], 2);
                        if (names.length == 0) {
                            names = this.index.findNames(ibs[0], 1);
                        }
                        IIndexName[] iIndexNameArray = names;
                        int n = names.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IIndexName name = iIndexNameArray[n2];
                            this.reference = this.createReference(ibs[0], name);
                            if (this.reference != null) {
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException ce) {
                        CCorePlugin.log(ce);
                        this.index.releaseReadLock();
                    }
                    catch (InterruptedException ie) {
                        CCorePlugin.log(ie);
                        this.index.releaseReadLock();
                    }
                }
                finally {
                    this.index.releaseReadLock();
                }
            }
        }
        return this.reference;
    }

    private IIndexBinding[] findBindings() throws CoreException {
        char[][] cfqn = new char[this.fqn.length][];
        int i = 0;
        while (i < this.fqn.length) {
            cfqn[i] = this.fqn[i].toCharArray();
            ++i;
        }
        IIndexBinding[] ibs = this.index.findBindings(cfqn, new IndexFilter(){

            public boolean acceptBinding(IBinding binding) {
                block10: {
                    block9: {
                        if (!IndexModelUtil.bindingHasCElementType(binding, new int[]{IndexTypeInfo.this.elementType})) {
                            return false;
                        }
                        if (IndexTypeInfo.this.fileLocal != null) break block9;
                        if (((IIndexBinding)binding).isFileLocal()) {
                            return false;
                        }
                        break block10;
                    }
                    IIndexFile localToFile = ((IIndexBinding)binding).getLocalToFile();
                    if (localToFile != null && IndexTypeInfo.this.fileLocal.equals(localToFile.getLocation())) break block10;
                    return false;
                }
                try {
                    if (binding instanceof IFunction && IndexTypeInfo.this.params != null) {
                        Object[] otherParams = IndexModelUtil.extractParameterTypes((IFunction)binding);
                        if (!Arrays.equals(IndexTypeInfo.this.params, otherParams)) {
                            return false;
                        }
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                catch (DOMException e) {
                    CCorePlugin.log(e);
                }
                return true;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return ibs;
    }

    private ITypeReference createMacroReference() {
        block9: {
            try {
                try {
                    this.index.acquireReadLock();
                    IIndexMacro[] macros = this.index.findMacros(this.fqn[0].toCharArray(), IndexFilter.ALL_DECLARED, (IProgressMonitor)new NullProgressMonitor());
                    if (macros.length <= 0) break block9;
                    IIndexMacro[] iIndexMacroArray = macros;
                    int n = macros.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexMacro macro = iIndexMacroArray[n2];
                        this.reference = this.createReference(macro);
                        if (this.reference != null) {
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                    this.index.releaseReadLock();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    this.index.releaseReadLock();
                }
            }
            finally {
                this.index.releaseReadLock();
            }
        }
        return this.reference;
    }

    private IndexTypeReference createReference(IIndexBinding binding, IIndexName indexName) throws CoreException {
        IIndexFileLocation ifl = indexName.getFile().getLocation();
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            if (file != null) {
                return new IndexTypeReference((IBinding)binding, (IResource)file, file.getProject(), indexName.getNodeOffset(), indexName.getNodeLength());
            }
        } else {
            IPath path = URIUtil.toPath((URI)ifl.getURI());
            if (path != null) {
                return new IndexTypeReference((IBinding)binding, path, null, indexName.getNodeOffset(), indexName.getNodeLength());
            }
        }
        return null;
    }

    private IndexTypeReference createReference(IIndexMacro macro) throws CoreException {
        IIndexName def = macro.getDefinition();
        if (def != null) {
            return this.createReference(macro, def);
        }
        return null;
    }

    @Override
    public ITypeReference[] getReferences() {
        ArrayList<IndexTypeReference> references;
        block12: {
            if (this.elementType == 79) {
                return this.getMacroReferences();
            }
            references = new ArrayList<IndexTypeReference>();
            try {
                this.index.acquireReadLock();
                IIndexBinding[] ibs = this.findBindings();
                HashMap<IIndexFileLocation, IIndexFile> iflMap = new HashMap<IIndexFileLocation, IIndexFile>();
                IIndexBinding[] iIndexBindingArray = ibs;
                int n = ibs.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding binding = iIndexBindingArray[n2];
                    IIndexName[] names = this.index.findNames(binding, 2);
                    if (names.length == 0) {
                        names = this.index.findNames(binding, 1);
                    }
                    IIndexName[] iIndexNameArray = names;
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IndexTypeReference ref;
                        IIndexName indexName = iIndexNameArray[n4];
                        if (this.checkFile(iflMap, indexName.getFile()) && (ref = this.createReference(binding, indexName)) != null) {
                            references.add(ref);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
                this.index.releaseReadLock();
                break block12;
            }
            catch (InterruptedException ie) {
                try {
                    CCorePlugin.log(ie);
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.index.releaseReadLock();
                }
            }
            this.index.releaseReadLock();
        }
        return references.toArray(new IndexTypeReference[references.size()]);
    }

    private ITypeReference[] getMacroReferences() {
        ArrayList<IndexTypeReference> references;
        block9: {
            references = new ArrayList<IndexTypeReference>();
            try {
                this.index.acquireReadLock();
                char[] cfn = this.fqn[0].toCharArray();
                IIndexMacro[] ibs = this.index.findMacros(cfn, IndexFilter.ALL_DECLARED, (IProgressMonitor)new NullProgressMonitor());
                HashMap<IIndexFileLocation, IIndexFile> iflMap = new HashMap<IIndexFileLocation, IIndexFile>();
                IIndexMacro[] iIndexMacroArray = ibs;
                int n = ibs.length;
                int n2 = 0;
                while (n2 < n) {
                    IndexTypeReference ref;
                    IIndexMacro macro = iIndexMacroArray[n2];
                    if (this.checkParameters(macro.getParameterList()) && this.checkFile(iflMap, macro.getFile()) && (ref = this.createReference(macro)) != null) {
                        references.add(ref);
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
                this.index.releaseReadLock();
                break block9;
            }
            catch (InterruptedException ie) {
                try {
                    CCorePlugin.log(ie);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.index.releaseReadLock();
                }
            }
            this.index.releaseReadLock();
        }
        return references.toArray(new IndexTypeReference[references.size()]);
    }

    private boolean checkParameters(char[][] parameterList) {
        if (parameterList == null) {
            return this.params == null;
        }
        if (this.params == null || parameterList.length != this.params.length) {
            return false;
        }
        int i = 0;
        while (i < parameterList.length) {
            if (!this.params[i].equals(new String(parameterList[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkFile(HashMap<IIndexFileLocation, IIndexFile> iflMap, IIndexFile file) throws CoreException {
        IIndexFileLocation ifl = file.getLocation();
        IIndexFile otherFile = iflMap.get(ifl);
        if (otherFile == null) {
            iflMap.put(ifl, file);
            return true;
        }
        return otherFile.equals(file);
    }

    @Override
    @Deprecated
    public void addDerivedReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public void addReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean canSubstituteFor(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean encloses(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean exists() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeReference[] getDerivedReferences() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo[] getEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo[] getEnclosedTypes(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo getEnclosingNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo getEnclosingType() {
        return null;
    }

    @Override
    @Deprecated
    public ITypeInfo getEnclosingType(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo getRootNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo[] getSubTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ASTAccessVisibility getSuperTypeAccess(ITypeInfo subType) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public ITypeInfo[] getSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean hasEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean hasSubTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean hasSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isClass() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isEnclosed(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isEnclosed(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isEnclosedType() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isEnclosingType() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isReferenced(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public boolean isUndefinedType() {
        throw new PDOMNotImplementedError();
    }

    @Override
    @Deprecated
    public void setCElementType(int type) {
        throw new PDOMNotImplementedError();
    }
}

