/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ACPathEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class CLibraryFileEntry
extends ACPathEntry
implements ICLibraryFileEntry {
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;
    private IPath fSourceAttachmentPrefixMapping;

    public CLibraryFileEntry(String value, int flags) {
        this(value, flags, null, null, null);
    }

    public CLibraryFileEntry(IPath location, int flags) {
        this(location, flags, null, null, null);
    }

    public CLibraryFileEntry(IFile rc, int flags) {
        this(rc, flags, null, null, null);
    }

    public CLibraryFileEntry(String value, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super(value, flags);
        this.setSourceAttachmentSettings(sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping);
    }

    public CLibraryFileEntry(IPath location, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super(location, flags);
        this.setSourceAttachmentSettings(sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping);
    }

    public CLibraryFileEntry(IFile rc, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        super((IResource)rc, flags);
        this.setSourceAttachmentSettings(sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping);
    }

    private void setSourceAttachmentSettings(IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        if (sourceAttachmentPath == null) {
            return;
        }
        this.fSourceAttachmentPath = sourceAttachmentPath;
        this.fSourceAttachmentRootPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath : Path.EMPTY;
        this.fSourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping != null ? sourceAttachmentPrefixMapping : Path.EMPTY;
    }

    public final int getKind() {
        return 32;
    }

    public final boolean isFile() {
        return true;
    }

    public IPath getSourceAttachmentPath() {
        return this.fSourceAttachmentPath;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return this.fSourceAttachmentPrefixMapping;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.fSourceAttachmentRootPath;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.sourceAttachmentSettingsEqual((CLibraryFileEntry)other);
    }

    public boolean equalsByContents(ICSettingEntry entry) {
        if (entry == this) {
            return true;
        }
        if (!super.equalsByContents(entry)) {
            return false;
        }
        return this.sourceAttachmentSettingsEqual((CLibraryFileEntry)entry);
    }

    private boolean sourceAttachmentSettingsEqual(CLibraryFileEntry otherEntry) {
        if (!CDataUtil.objectsEqual(this.fSourceAttachmentPath, otherEntry.fSourceAttachmentPath)) {
            return false;
        }
        if (!CDataUtil.objectsEqual(this.fSourceAttachmentRootPath, otherEntry.fSourceAttachmentRootPath)) {
            return false;
        }
        return CDataUtil.objectsEqual(this.fSourceAttachmentPrefixMapping, otherEntry.fSourceAttachmentPrefixMapping);
    }

    protected String contentsToString() {
        String result = super.contentsToString();
        if (this.fSourceAttachmentPath != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(result);
            buf.append(" ; srcPath=").append(this.fSourceAttachmentPath);
            buf.append("; srcRoot=").append(this.fSourceAttachmentRootPath);
            buf.append("; srcMapping=").append(this.fSourceAttachmentPrefixMapping);
            result = buf.toString();
        }
        return result;
    }
}

