/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICMacroFileEntry;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryStore {
    private KindBasedStore fStore = new KindBasedStore();
    private boolean fPreserveReadOnly;

    public EntryStore() {
        this(false);
    }

    public EntryStore(boolean preserveReadOnly) {
        this.fPreserveReadOnly = preserveReadOnly;
    }

    public EntryStore(EntryStore base, boolean preserveReadOnly) {
        int[] nArray = KindBasedStore.getLanguageEntryKinds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            ArrayList list = (ArrayList)this.fStore.get(kind);
            if (list != null) {
                this.fStore.put(kind, (ArrayList)list.clone());
            }
            ++n2;
        }
        this.fPreserveReadOnly = preserveReadOnly;
    }

    public ICLanguageSettingEntry[] getEntries() {
        ArrayList result = new ArrayList();
        int[] nArray = KindBasedStore.getLanguageEntryKinds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            List list = (List)this.fStore.get(k);
            if (list != null) {
                result.addAll(list);
            }
            ++n2;
        }
        return result.toArray(new ICLanguageSettingEntry[result.size()]);
    }

    public boolean containsEntriesList(int kind) {
        List<ICLanguageSettingEntry> list = this.getEntriesList(kind, false);
        return list != null;
    }

    public ICLanguageSettingEntry[] getEntries(int kind) {
        List<ICLanguageSettingEntry> list = this.getEntriesList(kind);
        if (list == null) {
            list = new ArrayList<ICLanguageSettingEntry>(0);
        }
        switch (kind) {
            case 1: {
                return list.toArray(new ICIncludePathEntry[list.size()]);
            }
            case 2: {
                return list.toArray(new ICIncludeFileEntry[list.size()]);
            }
            case 4: {
                return list.toArray(new ICMacroEntry[list.size()]);
            }
            case 8: {
                return list.toArray(new ICMacroFileEntry[list.size()]);
            }
            case 16: {
                return list.toArray(new ICLibraryPathEntry[list.size()]);
            }
            case 32: {
                return list.toArray(new ICLibraryFileEntry[list.size()]);
            }
        }
        throw new IllegalArgumentException();
    }

    public List<ICLanguageSettingEntry> getEntriesList(int kind) {
        List<ICLanguageSettingEntry> list = this.getEntriesList(kind, false);
        if (list != null) {
            return new ArrayList<ICLanguageSettingEntry>(list);
        }
        return new ArrayList<ICLanguageSettingEntry>(0);
    }

    private void setEntriesList(int kind, List<ICLanguageSettingEntry> list) {
        this.fStore.put(kind, list);
    }

    private List<ICLanguageSettingEntry> getEntriesList(int kind, boolean create) {
        ArrayList list = (ArrayList)this.fStore.get(kind);
        if (list == null && create) {
            list = new ArrayList();
            this.fStore.put(kind, list);
        }
        return list;
    }

    public void addEntry(int pos, ICLanguageSettingEntry entry) {
        List<ICLanguageSettingEntry> list = this.getEntriesList(entry.getKind(), true);
        if (pos >= list.size()) {
            list.add(entry);
        } else {
            list.add(pos, entry);
        }
    }

    public void addEntries(ICLanguageSettingEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            this.addEntry(entries[i]);
            ++i;
        }
    }

    public void storeEntries(int kind, ICLanguageSettingEntry[] entries) {
        this.storeEntries(kind, entries != null ? Arrays.asList(entries) : new ArrayList<ICLanguageSettingEntry>());
    }

    public void storeEntries(int kind, List<ICLanguageSettingEntry> list) {
        List<ICLanguageSettingEntry> oldList;
        ArrayList<ICLanguageSettingEntry> newList = new ArrayList<ICLanguageSettingEntry>(list);
        if (this.fPreserveReadOnly && (oldList = this.getEntriesList(kind, false)) != null) {
            Set<ICLanguageSettingEntry> ro = this.getReadOnlySet(oldList);
            ro.removeAll(newList);
            for (ICLanguageSettingEntry o : oldList) {
                if (!ro.contains(o)) continue;
                newList.add(o);
            }
        }
        this.setEntriesList(kind, newList);
    }

    private Set<ICLanguageSettingEntry> getReadOnlySet(List<ICLanguageSettingEntry> entries) {
        HashSet<ICLanguageSettingEntry> set = new HashSet<ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry entry : entries) {
            if (!entry.isReadOnly()) continue;
            set.add(entry);
        }
        return set;
    }

    public void addEntry(ICLanguageSettingEntry entry) {
        List<ICLanguageSettingEntry> list = this.getEntriesList(entry.getKind(), true);
        list.add(entry);
    }

    public void trimToSize() {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            ArrayList list = (ArrayList)this.fStore.get(kinds[i]);
            if (list != null) {
                list.trimToSize();
            }
            ++i;
        }
    }
}

