/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.Value;

public abstract class ASTEnumerator
extends ASTNode
implements IASTEnumerationSpecifier.IASTEnumerator,
IASTAmbiguityParent {
    private IASTName name;
    private IASTExpression value;
    private IValue integralValue;

    public ASTEnumerator() {
    }

    public ASTEnumerator(IASTName name, IASTExpression value) {
        this.setName(name);
        this.setValue(value);
    }

    protected void copyAbstractEnumerator(ASTEnumerator copy) {
        copy.setName(this.name == null ? null : this.name.copy());
        copy.setValue(this.value == null ? null : this.value.copy());
        copy.setOffsetAndLength(this);
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATOR_NAME);
        }
    }

    public IASTName getName() {
        return this.name;
    }

    public void setValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.value = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ENUMERATOR_VALUE);
        }
    }

    public IASTExpression getValue() {
        return this.value;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitEnumerators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (this.value != null && !this.value.accept(action)) {
            return false;
        }
        if (action.shouldVisitEnumerators) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 2;
        }
        return 1;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.value) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.value = (IASTExpression)other;
        }
    }

    public IValue getIntegralValue() {
        if (this.integralValue == null) {
            IASTInternalEnumerationSpecifier ies;
            IASTNode parent = this.getParent();
            if (parent instanceof IASTInternalEnumerationSpecifier && (ies = (IASTInternalEnumerationSpecifier)parent).startValueComputation()) {
                this.createEnumValues((IASTEnumerationSpecifier)parent);
            }
            if (this.integralValue == null) {
                this.integralValue = Value.UNKNOWN;
            }
        }
        return this.integralValue;
    }

    private void createEnumValues(IASTEnumerationSpecifier parent) {
        IASTEnumerationSpecifier.IASTEnumerator[] etors = parent.getEnumerators();
        int cv = -1;
        boolean isknown = true;
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = etors;
        int n = etors.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator etor = iASTEnumeratorArray[n2];
            ++cv;
            IASTExpression expr = etor.getValue();
            if (expr != null) {
                IValue val = Value.create(expr, 25);
                Long nv = val.numericalValue();
                isknown = false;
                if (nv != null) {
                    isknown = true;
                    cv = nv.intValue();
                }
            }
            if (etor instanceof ASTEnumerator) {
                ((ASTEnumerator)etor).integralValue = isknown ? Value.create(cv) : Value.UNKNOWN;
            }
            ++n2;
        }
    }
}

