/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTLiteralExpression
extends ASTNode
implements ICPPASTLiteralExpression {
    public static final CPPASTLiteralExpression INT_ZERO = new CPPASTLiteralExpression(0, new char[]{'0'});
    private int kind;
    private char[] value = CharArrayUtils.EMPTY;

    public CPPASTLiteralExpression() {
    }

    public CPPASTLiteralExpression(int kind, char[] value) {
        this.kind = kind;
        this.value = value;
    }

    public CPPASTLiteralExpression copy() {
        CPPASTLiteralExpression copy = new CPPASTLiteralExpression(this.kind, this.value == null ? null : (char[])this.value.clone());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int value) {
        this.assertNotFrozen();
        this.kind = value;
    }

    public char[] getValue() {
        return this.value;
    }

    public void setValue(char[] value) {
        this.assertNotFrozen();
        this.value = value;
    }

    public String toString() {
        return new String(this.value);
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public IType getExpressionType() {
        switch (this.getKind()) {
            case 4: {
                IScope scope = CPPVisitor.getContainingScope(this);
                return CPPVisitor.getThisType(scope);
            }
            case 5: 
            case 6: {
                return new CPPBasicType(6, 0, this);
            }
            case 2: {
                return new CPPBasicType(this.getCharType(), 0, this);
            }
            case 1: {
                return this.classifyTypeOfFloatLiteral();
            }
            case 0: {
                return this.classifyTypeOfIntLiteral();
            }
            case 3: {
                IType type = new CPPBasicType(this.getCharType(), 0, this);
                type = new CPPQualifierType(type, true, false);
                return new CPPArrayType(type);
            }
        }
        return null;
    }

    private int getCharType() {
        return this.getValue()[0] == 'L' ? 7 : 2;
    }

    private IType classifyTypeOfFloatLiteral() {
        char[] lit = this.getValue();
        int len = lit.length;
        int kind = 5;
        int flags = 0;
        if (len > 0) {
            switch (lit[len - 1]) {
                case 'F': 
                case 'f': {
                    kind = 4;
                    break;
                }
                case 'L': 
                case 'l': {
                    flags |= 1;
                }
            }
        }
        return new CPPBasicType(kind, flags, this);
    }

    private IType classifyTypeOfIntLiteral() {
        int makelong = 0;
        boolean unsigned = false;
        char[] lit = this.getValue();
        int i = lit.length - 1;
        while (i >= 0) {
            char c = lit[i];
            if (!(c > 'f' && c <= 'z' || c > 'F' && c <= 'Z')) break;
            switch (c) {
                case 'U': 
                case 'u': {
                    unsigned = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    ++makelong;
                }
            }
            --i;
        }
        int flags = 0;
        if (unsigned) {
            flags |= 8;
        }
        if (makelong > 1) {
            GPPBasicType result = new GPPBasicType(3, flags |= 0x40, null);
            result.setFromExpression(this);
            return result;
        }
        if (makelong == 1) {
            flags |= 1;
        }
        return new CPPBasicType(3, flags, this);
    }

    @Deprecated
    public void setValue(String value) {
        this.assertNotFrozen();
        this.value = value.toCharArray();
    }

    @Deprecated
    public CPPASTLiteralExpression(int kind, String value) {
        this(kind, value.toCharArray());
    }
}

