/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.cdt.internal.core.indexer.IStandaloneScannerInfoProvider;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexerTask;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandaloneIndexer {
    public static final int SKIP_NO_REFERENCES = PDOMWriter.SKIP_NO_REFERENCES;
    public static final int SKIP_ALL_REFERENCES = PDOMWriter.SKIP_ALL_REFERENCES;
    public static final int SKIP_IMPLICIT_REFERENCES = PDOMWriter.SKIP_IMPLICIT_REFERENCES;
    public static final int SKIP_TYPE_REFERENCES = PDOMWriter.SKIP_TYPE_REFERENCES;
    public static final int SKIP_MACRO_REFERENCES = PDOMWriter.SKIP_MACRO_REFERENCES;
    public static final int UPDATE_ALL = 1;
    public static final int UPDATE_CHECK_TIMESTAMPS = 2;
    protected static final List<String> NO_TUS = Collections.emptyList();
    protected IWritableIndex fIndex;
    protected boolean fIndexAllFiles;
    protected Set<String> fValidSourceUnitNames;
    @Deprecated
    protected IScannerInfo fScanner;
    protected IStandaloneScannerInfoProvider fScannerInfoProvider;
    protected ILanguageMapper fMapper;
    protected IParserLogService fLog;
    protected boolean fShowActivity;
    protected boolean fShowProblems;
    protected boolean fTraceStatistics;
    protected int fSkipReferences = SKIP_NO_REFERENCES;
    protected FilenameFilter fExclusionFilter;
    protected String[] fFilesToParseUpFront = new String[0];
    protected int fUpdateOptions = 1;
    private IndexerProgress fProgress = null;
    private volatile StandaloneIndexerTask fDelegate;
    private static FilenameFilter DEFAULT_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return true;
        }
    };

    @Deprecated
    public StandaloneIndexer(IWritableIndex index, boolean indexAllFiles, ILanguageMapper mapper, IParserLogService log, IScannerInfo scanner) {
        this.fIndex = index;
        this.fIndexAllFiles = indexAllFiles;
        this.fMapper = mapper;
        this.fLog = log;
        this.fScanner = scanner;
        this.fScannerInfoProvider = null;
    }

    public StandaloneIndexer(IWritableIndex index, boolean indexAllFiles, ILanguageMapper mapper, IParserLogService log, IStandaloneScannerInfoProvider scannerProvider) {
        this.fIndex = index;
        this.fIndexAllFiles = indexAllFiles;
        this.fMapper = mapper;
        this.fLog = log;
        this.fScanner = null;
        this.fScannerInfoProvider = scannerProvider;
    }

    public void setScannerInfoProvider(IStandaloneScannerInfoProvider provider) {
        this.fScannerInfoProvider = provider;
        this.fScanner = null;
    }

    public IWritableIndex getIndex() {
        return this.fIndex;
    }

    public boolean getIndexAllFiles() {
        return this.fIndexAllFiles;
    }

    public Set<String> getValidSourceUnitNames() {
        return this.fValidSourceUnitNames;
    }

    public void setValidSourceUnitNames(Set<String> validSourceUnitNames) {
        this.fValidSourceUnitNames = validSourceUnitNames;
    }

    @Deprecated
    public IScannerInfo getScannerInfo() {
        return this.fScanner;
    }

    public IScannerInfo getScannerInfo(String path) {
        if (this.fScanner != null) {
            return this.fScanner;
        }
        return this.fScannerInfoProvider.getScannerInformation(path);
    }

    public IStandaloneScannerInfoProvider getScannerInfoProvider() {
        return this.fScannerInfoProvider;
    }

    public ILanguageMapper getLanguageMapper() {
        return this.fMapper;
    }

    public void setLanguageMapper(ILanguageMapper mapper) {
        this.fMapper = mapper;
    }

    public IParserLogService getParserLog() {
        return this.fLog;
    }

    public boolean getShowActivity() {
        return this.fShowActivity;
    }

    public void setShowActivity(boolean showActivity) {
        this.fShowActivity = showActivity;
    }

    public boolean getShowProblems() {
        return this.fShowProblems;
    }

    public void setShowProblems(boolean showProblems) {
        this.fShowProblems = showProblems;
    }

    public boolean getTraceStatistics() {
        return this.fTraceStatistics;
    }

    public void setTraceStatistics(boolean traceStatistics) {
        this.fTraceStatistics = traceStatistics;
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    private void clearIndex() throws CoreException, InterruptedException {
        IWritableIndex index = this.getIndex();
        index.acquireWriteLock(0);
        try {
            index.clear();
        }
        finally {
            index.releaseWriteLock(0);
        }
    }

    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    public int getUpdateOptions() {
        return this.fUpdateOptions;
    }

    public void setUpdateOptions(int options) {
        this.fUpdateOptions = options;
    }

    public void rebuild(List<String> tus, IProgressMonitor monitor) throws IOException {
        this.fProgress = this.createProgress();
        try {
            this.clearIndex();
            this.fDelegate = this.createTask(this.getFilesAdded(tus), NO_TUS, NO_TUS);
            this.fDelegate.setUpdateFlags(this.fUpdateOptions);
            if (this.fDelegate != null) {
                this.fDelegate.run(monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void handleDelta(List<String> added, List<String> changed, List<String> removed, IProgressMonitor monitor) throws IOException {
        this.fProgress = new IndexerProgress();
        this.fDelegate = this.createTask(this.getFilesAdded(added), changed, removed);
        if (this.fDelegate != null) {
            try {
                this.fDelegate.setUpdateFlags(this.fUpdateOptions);
                this.fDelegate.run(monitor);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private List<String> getFilesAdded(List<String> tus) {
        ArrayList<String> added = new ArrayList<String>();
        FilenameFilter filter = this.getExclusionFilter();
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        for (String path : tus) {
            File file = new File(path);
            if (file.isDirectory()) {
                String[] files;
                String[] stringArray = files = file.list(filter);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file2 = stringArray[n2];
                    added.add(file2);
                    ++n2;
                }
                continue;
            }
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            added.add(path);
        }
        return added;
    }

    protected abstract StandaloneIndexerTask createTask(List<String> var1, List<String> var2, List<String> var3);

    public int getSkipReferences() {
        return this.fSkipReferences;
    }

    public void setSkipReferences(int skipReferences) {
        this.fSkipReferences = skipReferences;
    }

    public String[] getFilesToParseUpFront() {
        return this.fFilesToParseUpFront;
    }

    public void setFilesToParseUpFront(String[] filesToParseUpFront) {
        this.fFilesToParseUpFront = filesToParseUpFront;
    }

    public FilenameFilter getExclusionFilter() {
        return this.fExclusionFilter;
    }

    public void setExclusionFilter(FilenameFilter exclusionFilter) {
        this.fExclusionFilter = exclusionFilter;
    }
}

