/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.Path;

public class StandaloneIndexerInputAdapter
extends IndexerInputAdapter {
    private HashMap<String, IIndexFileLocation> fIflCache = new HashMap();
    private final StandaloneIndexer fIndexer;

    public StandaloneIndexerInputAdapter(StandaloneIndexer indexer) {
        this.fIndexer = indexer;
    }

    public IScannerInfo getBuildConfiguration(int linkageID, Object tu) {
        return this.fIndexer.getScannerInfo((String)tu);
    }

    public long getLastModified(IIndexFileLocation location) {
        return new File(URIUtil.toPath((URI)location.getURI()).toOSString()).lastModified();
    }

    public boolean isSourceUnit(Object tu) {
        return this.isValidSourceUnitName((String)tu);
    }

    public boolean isSource(String filename) {
        return this.isValidSourceUnitName(filename);
    }

    public IIndexFileLocation resolveFile(Object tu) {
        return this.resolveASTPath((String)tu);
    }

    public String getASTPath(IIndexFileLocation ifl) {
        return URIUtil.toPath((URI)ifl.getURI()).toOSString();
    }

    public IIndexFileLocation resolveASTPath(String astPath) {
        IIndexFileLocation result = this.fIflCache.get(astPath);
        if (result == null) {
            try {
                astPath = new File(astPath).getCanonicalPath();
            }
            catch (IOException iOException) {}
            result = new IndexFileLocation(URIUtil.toURI((String)astPath), null);
            this.fIflCache.put(astPath, result);
        }
        return result;
    }

    public boolean doesIncludeFileExist(String includePath) {
        return new File(includePath).isFile();
    }

    public IIndexFileLocation resolveIncludeFile(String includePath) {
        IIndexFileLocation result = this.fIflCache.get(includePath);
        if (result == null) {
            File file = new File(includePath);
            try {
                includePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {}
            result = new IndexFileLocation(URIUtil.toURI((String)includePath), null);
            this.fIflCache.put(includePath, result);
        }
        return result;
    }

    public boolean isFileBuildConfigured(Object tu) {
        return this.isValidSourceUnitName((String)tu);
    }

    public boolean canBePartOfSDK(IIndexFileLocation ifl) {
        return false;
    }

    public CodeReader getCodeReader(Object tu) {
        try {
            return new CodeReader((String)tu);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Object getInputFile(IIndexFileLocation location) {
        return URIUtil.toPath((URI)location.getURI());
    }

    public AbstractLanguage[] getLanguages(Object tu, boolean bothForHeaders) {
        ILanguage language = this.fIndexer.getLanguageMapper().getLanguage((String)tu);
        if (language instanceof AbstractLanguage) {
            return new AbstractLanguage[]{(AbstractLanguage)language};
        }
        return new AbstractLanguage[0];
    }

    private boolean isValidSourceUnitName(String file) {
        Path path = new Path(file);
        if (this.fIndexer.getValidSourceUnitNames() == null || this.fIndexer.getValidSourceUnitNames().size() == 0) {
            return true;
        }
        return this.fIndexer.getValidSourceUnitNames().contains(path.getFileExtension());
    }
}

