/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceManipulation
extends Parent
implements ISourceManipulation,
ISourceReference {
    protected static final String[] fgEmptyStrings = new String[0];
    private boolean fIsActive = true;
    private short fIndex = 0;

    public SourceManipulation(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    @Override
    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException(CoreModelMessages.getString("operation.nullContainer"));
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getCModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        ICElement[] elements = new ICElement[]{this};
        this.getCModel().delete(elements, force, monitor);
    }

    @Override
    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException(CoreModelMessages.getString("operation.nullContainer"));
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getCModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    @Override
    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        if (name == null) {
            throw new IllegalArgumentException("element.nullName");
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] dests = new ICElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getCModel().rename(elements, dests, renamings, force, monitor);
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        try {
            return this.getSourceManipulationInfo().getTranslationUnit();
        }
        catch (CModelException cModelException) {
            return null;
        }
    }

    public IResource getCorrespondingResource() throws CModelException {
        return null;
    }

    @Override
    public IOpenable getOpenableParent() {
        ICElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            current = current.getParent();
        }
        return null;
    }

    @Override
    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    @Override
    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getParent().getUnderlyingResource();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new SourceManipulationInfo(this);
    }

    protected SourceManipulationInfo getSourceManipulationInfo() throws CModelException {
        return (SourceManipulationInfo)this.getElementInfo();
    }

    public boolean isIdentical(SourceManipulation other) throws CModelException {
        return this.equals(other) && this.getSourceManipulationInfo().hasSameContentsAs(other.getSourceManipulationInfo());
    }

    @Override
    protected void generateInfos(CElementInfo info, Map<ICElement, CElementInfo> newElements, IProgressMonitor pm) throws CModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        CElementInfo openableParentInfo = (CElementInfo)CModelManager.getDefault().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
        newElements.put(this, info);
    }

    public void setPos(int startPos, int length) {
        try {
            this.getSourceManipulationInfo().setPos(startPos, length);
        }
        catch (CModelException cModelException) {}
    }

    public void setIdPos(int startPos, int length) {
        try {
            this.getSourceManipulationInfo().setIdPos(startPos, length);
        }
        catch (CModelException cModelException) {}
    }

    public void setLines(int startLine, int endLine) {
        try {
            this.getSourceManipulationInfo().setLines(startLine, endLine);
        }
        catch (CModelException cModelException) {}
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        switch (token.charAt(0)) {
            case '[': {
                ICElement[] children;
                int elementType;
                String elementName;
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                token = memento.nextToken();
                if (token.charAt(0) != '#') {
                    elementName = token;
                    token = memento.nextToken();
                } else {
                    elementName = "";
                }
                assert (token.charAt(0) == '#');
                String typeString = memento.nextToken();
                try {
                    elementType = Integer.parseInt(typeString);
                }
                catch (NumberFormatException nfe) {
                    CCorePlugin.log(nfe);
                    return null;
                }
                token = null;
                Object[] mementoParams = new String[]{};
                if (memento.hasMoreTokens()) {
                    ArrayList<String> params = new ArrayList<String>();
                    while ((token = memento.nextToken()).charAt(0) == '(') {
                        params.add(memento.nextToken());
                        token = null;
                        if (memento.hasMoreTokens()) continue;
                    }
                    mementoParams = params.toArray(new String[params.size()]);
                }
                CElement element = null;
                try {
                    children = this.getChildren();
                }
                catch (CModelException exc) {
                    CCorePlugin.log((Throwable)((Object)exc));
                    return null;
                }
                block5 : switch (elementType) {
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICElement element2 = iCElementArray[n2];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                assert (element2 instanceof IFunctionDeclaration);
                                Object[] functionParams = ((IFunctionDeclaration)element2).getParameterTypes();
                                if (Arrays.equals(functionParams, mementoParams)) {
                                    element = (CElement)element2;
                                    break block5;
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 83: 
                    case 85: 
                    case 87: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ICElement element2 = iCElementArray[n3];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                assert (element2 instanceof ITemplate);
                                Object[] templateParams = ((ITemplate)((Object)element2)).getTemplateParameterTypes();
                                if (Arrays.equals(templateParams, mementoParams)) {
                                    element = (CElement)element2;
                                    break block5;
                                }
                            }
                            ++n3;
                        }
                        break;
                    }
                    default: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ICElement element2 = iCElementArray[n4];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                element = (CElement)element2;
                                break block5;
                            }
                            ++n4;
                        }
                        break block5;
                    }
                }
                if (element == null) break;
                if (token != null) {
                    return element.getHandleFromMemento(token, memento);
                }
                return element.getHandleFromMemento(memento);
            }
        }
        return null;
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        ((CElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        SourceManipulation.escapeMementoName(buff, this.getElementName());
        buff.append('#');
        buff.append(Integer.toString(this.getElementType()));
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '[';
    }

    @Override
    public boolean isActive() {
        return this.fIsActive;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    public void setActive(boolean active) {
        this.fIsActive = active;
    }

    public void setIndex(int i) {
        this.fIndex = (short)i;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.fIndex, super.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ISourceReference && this.fIndex != ((ISourceReference)other).getIndex()) {
            return false;
        }
        return super.equals(other);
    }
}

