/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.internal.core.parser.CodeReaderLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InternalParserUtil
extends ParserFactory {
    public static String normalizePath(String path, IFile file) {
        IPath loc = file.getLocation();
        if (loc != null) {
            path = loc.toOSString();
        }
        return path;
    }

    public static CodeReader createExternalFileReader(String externalLocation, CodeReaderLRUCache cache) throws IOException {
        File includeFile = new File(externalLocation);
        if (includeFile.isFile()) {
            CodeReader result;
            String path = includeFile.getCanonicalPath();
            if (cache != null && (result = cache.get(path)) != null) {
                return result;
            }
            return new CodeReader(path);
        }
        return null;
    }

    public static CodeReader createWorkspaceFileReader(String path, IFile file, CodeReaderLRUCache cache) throws CoreException, IOException {
        CodeReader codeReader;
        InputStream in;
        CodeReader result;
        path = InternalParserUtil.normalizePath(path, file);
        if (cache != null && (result = cache.get(path)) != null) {
            return result;
        }
        try {
            in = file.getContents(true);
        }
        catch (CoreException e) {
            switch (e.getStatus().getCode()) {
                case 269: 
                case 270: 
                case 271: 
                case 369: {
                    return null;
                }
            }
            throw e;
        }
        try {
            codeReader = new CodeReader(path, file.getCharset(), in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return codeReader;
    }

    public static CodeReader createCodeReader(IIndexFileLocation ifl, CodeReaderLRUCache cache) throws CoreException, IOException {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            return InternalParserUtil.createWorkspaceFileReader(ifl.getURI().getPath(), (IFile)res, cache);
        }
        return InternalParserUtil.createExternalFileReader(ifl.getURI().getPath(), cache);
    }
}

