/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.util.ICancelable;
import org.eclipse.cdt.internal.core.util.ICanceler;

public class ParserLogService
extends AbstractParserLogService
implements ICanceler {
    private final DebugLogConstants topic;
    private final boolean fIsTracing;
    private final boolean fIsTracingExceptions;
    private final ICanceler fCanceler;

    public ParserLogService(DebugLogConstants constant) {
        this(constant, null);
    }

    public ParserLogService(DebugLogConstants constant, ICanceler canceler) {
        this.topic = constant;
        if (CCorePlugin.getDefault() == null) {
            this.fIsTracingExceptions = false;
            this.fIsTracing = false;
        } else {
            this.fIsTracingExceptions = Util.PARSER_EXCEPTIONS;
            this.fIsTracing = Util.isActive(this.topic);
        }
        this.fCanceler = canceler;
    }

    public void traceLog(String message) {
        Util.debugLog(message, this.topic);
    }

    public void errorLog(String message) {
        Util.log(message, ICLogConstants.CDT);
    }

    public boolean isTracing() {
        return this.fIsTracing;
    }

    public boolean isTracingExceptions() {
        return this.fIsTracingExceptions;
    }

    public void setCancelable(ICancelable cancelable) {
        if (this.fCanceler != null) {
            this.fCanceler.setCancelable(cancelable);
        }
    }
}

