/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritablePDOM
extends PDOM
implements IWritableIndexFragment {
    private boolean fClearedBecauseOfVersionMismatch = false;
    private boolean fCreatedFromScratch = false;
    private ASTFilePathResolver fPathResolver;

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        super(dbPath, locationConverter, cache, linkageFactoryMappings);
    }

    public void setASTFilePathResolver(ASTFilePathResolver resolver) {
        this.fPathResolver = resolver;
    }

    @Override
    public IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location) throws CoreException {
        return super.addFile(linkageID, location);
    }

    @Override
    public void addFileContent(IIndexFragmentFile sourceFile, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorStatement[] macros, IASTName[][] names, ASTFilePathResolver pathResolver) throws CoreException {
        assert (sourceFile.getIndexFragment() == this);
        PDOMFile pdomFile = (PDOMFile)sourceFile;
        pdomFile.addIncludesTo(includes);
        pdomFile.addMacros(macros);
        ASTFilePathResolver origResolver = this.fPathResolver;
        this.fPathResolver = pathResolver;
        try {
            pdomFile.addNames(names);
        }
        finally {
            this.fPathResolver = origResolver;
        }
        IIndexFileLocation location = pdomFile.getLocation();
        this.fEvent.fClearedFiles.remove(location);
        this.fEvent.fFilesWritten.add(location);
    }

    @Override
    public void clearFile(IIndexFragmentFile file, Collection<IIndexFileLocation> contextsRemoved) throws CoreException {
        assert (file.getIndexFragment() == this);
        ((PDOMFile)file).clear(contextsRemoved);
        this.fEvent.fClearedFiles.add(file.getLocation());
    }

    @Override
    public void clear() throws CoreException {
        super.clear();
    }

    @Override
    public void flush() throws CoreException {
        super.flush();
    }

    @Override
    public void setProperty(String propertyName, String value) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName) || "org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            throw new IllegalArgumentException("Property " + value + " may not be written to");
        }
        new DBProperties(this.db, 2056).setProperty(propertyName, value);
    }

    public void rewriteLocations(IIndexLocationConverter newConverter) throws CoreException {
        final ArrayList pdomfiles = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                PDOMFile file = PDOMFile.recreateFile(WritablePDOM.this, record);
                pdomfiles.add(file);
                return true;
            }
        });
        this.clearFileIndex();
        ArrayList<PDOMFile> notConverted = new ArrayList<PDOMFile>();
        for (PDOMFile file : pdomfiles) {
            String internalFormat = newConverter.toInternalFormat(file.getLocation());
            if (internalFormat != null) {
                file.setInternalLocation(internalFormat);
                this.getFileIndex().insert(file.getRecord());
                continue;
            }
            notConverted.add(file);
        }
        for (PDOMFile file : notConverted) {
            file.convertIncludersToUnresolved();
            file.clear(null);
        }
    }

    boolean isClearedBecauseOfVersionMismatch() {
        return this.fClearedBecauseOfVersionMismatch;
    }

    void setClearedBecauseOfVersionMismatch(boolean clearedBecauseOfVersionMismatch) {
        this.fClearedBecauseOfVersionMismatch = clearedBecauseOfVersionMismatch;
    }

    boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    void setCreatedFromScratch(boolean createdFromScratch) {
        this.fCreatedFromScratch = createdFromScratch;
    }

    @Override
    protected final boolean isPermanentlyReadOnly() {
        return false;
    }

    public PDOMFile getFileForASTPath(int linkageID, String astPath) throws CoreException {
        if (this.fPathResolver != null && astPath != null) {
            return this.getFile(linkageID, this.fPathResolver.resolveASTPath(astPath));
        }
        return null;
    }

    @Override
    public long getDatabaseSizeBytes() {
        return this.getDB().getSizeBytes();
    }
}

