/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBProperties {
    static final int PROP_INDEX = 0;
    static final int RECORD_SIZE = 4;
    protected BTree index;
    protected Database db;
    protected int record;

    public DBProperties(Database db) throws CoreException {
        this.record = db.malloc(4);
        this.index = new BTree(db, this.record + 0, DBProperty.getComparator(db));
        this.db = db;
    }

    public DBProperties(Database db, int record) throws CoreException {
        this.record = record;
        this.index = new BTree(db, record + 0, DBProperty.getComparator(db));
        this.db = db;
    }

    public String getProperty(String key) throws CoreException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            return existing.getValue().getString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) throws CoreException {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Set<String> getKeySet() throws CoreException {
        return DBProperty.getKeySet(this.db, this.index);
    }

    public void setProperty(String key, String value) throws CoreException {
        this.removeProperty(key);
        DBProperty newProperty = new DBProperty(this.db, key, value);
        this.index.insert(newProperty.getRecord());
    }

    public boolean removeProperty(String key) throws CoreException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            this.index.delete(existing.getRecord());
            existing.delete();
            return true;
        }
        return false;
    }

    public void clear() throws CoreException {
        this.index.accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                new DBProperty(DBProperties.this.db, record).delete();
                return false;
            }
        });
    }

    public void delete() throws CoreException {
        this.clear();
        this.db.free(this.record);
    }

    public int getRecord() {
        return this.record;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DBProperty {
        static final int KEY = 0;
        static final int VALUE = 4;
        static final int RECORD_SIZE = 8;
        Database db;
        int record;

        public int getRecord() {
            return this.record;
        }

        DBProperty(Database db, String key, String value) throws CoreException {
            assert (key != null);
            assert (value != null);
            IString dbkey = db.newString(key);
            IString dbvalue = db.newString(value);
            this.record = db.malloc(8);
            db.putInt(this.record + 0, dbkey.getRecord());
            db.putInt(this.record + 4, dbvalue.getRecord());
            this.db = db;
        }

        DBProperty(Database db, int record) {
            this.record = record;
            this.db = db;
        }

        public IString getKey() throws CoreException {
            return this.db.getString(this.db.getInt(this.record + 0));
        }

        public IString getValue() throws CoreException {
            return this.db.getString(this.db.getInt(this.record + 4));
        }

        public static IBTreeComparator getComparator(final Database db) {
            return new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    IString left = db.getString(db.getInt(record1 + 0));
                    IString right = db.getString(db.getInt(record2 + 0));
                    return left.compare(right, true);
                }
            };
        }

        public static DBProperty search(final Database db, BTree index, final String key) throws CoreException {
            final DBProperty[] result = new DBProperty[1];
            index.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return db.getString(db.getInt(record + 0)).compare(key, true);
                }

                public boolean visit(int record) throws CoreException {
                    result[0] = new DBProperty(db, record);
                    return false;
                }
            });
            return result[0];
        }

        public static Set<String> getKeySet(final Database db, BTree index) throws CoreException {
            final HashSet<String> result = new HashSet<String>();
            index.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    result.add(new DBProperty(db, record).getKey().getString());
                    return true;
                }
            });
            return result;
        }

        public void delete() throws CoreException {
            this.db.getString(this.db.getInt(this.record + 0)).delete();
            this.db.getString(this.db.getInt(this.record + 4)).delete();
            this.db.free(this.record);
        }
    }
}

