/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroContainerCollector
implements IBTreeVisitor {
    private final PDOMLinkage linkage;
    private final char[] name;
    private final boolean prefixLookup;
    private final boolean caseSensitive;
    private IProgressMonitor monitor = null;
    private int monitorCheckCounter = 0;
    private List<PDOMMacroContainer> macros = new ArrayList<PDOMMacroContainer>();

    public MacroContainerCollector(PDOMLinkage linkage, char[] name, boolean prefixLookup, boolean caseSensitive) {
        this.name = name;
        this.linkage = linkage;
        this.prefixLookup = prefixLookup;
        this.caseSensitive = caseSensitive;
    }

    public void setMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    @Override
    public final int compare(int record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        IString rhsName = PDOMNamedNode.getDBName(this.linkage.getDB(), record);
        return this.compare(rhsName);
    }

    private int compare(IString rhsName) throws CoreException {
        if (this.prefixLookup) {
            int cmp = rhsName.comparePrefix(this.name, false);
            if (this.caseSensitive) {
                cmp = cmp == 0 ? rhsName.comparePrefix(this.name, true) : cmp;
            }
            return cmp;
        }
        int cmp = this.caseSensitive ? rhsName.compareCompatibleWithIgnoreCase(this.name) : rhsName.compare(this.name, false);
        return cmp;
    }

    @Override
    public final boolean visit(int record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (record == 0) {
            return true;
        }
        this.macros.add(new PDOMMacroContainer(this.linkage, record));
        return true;
    }

    public final List<PDOMMacroContainer> getMacroList() {
        return this.macros;
    }

    private void checkCancelled() {
        if (++this.monitorCheckCounter % 4096 == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

