/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class PDOMInclude
implements IIndexFragmentInclude {
    private static final int INCLUDED_FILE = 0;
    private static final int INCLUDED_BY = 4;
    private static final int INCLUDES_NEXT = 8;
    private static final int INCLUDED_BY_NEXT = 12;
    private static final int INCLUDED_BY_PREV = 16;
    private static final int INCLUDE_NAME_OR_LENGTH = 20;
    private static final int NODE_OFFSET = 24;
    private static final int NODE_LENGTH = 27;
    private static final int FLAGS = 29;
    private static final int RECORD_SIZE = 30;
    private static final int FLAG_SYSTEM_INCLUDE = 1;
    private static final int FLAG_INACTIVE_INCLUDE = 2;
    private static final int FLAG_RESOLVED_BY_HEURISTICS = 4;
    private static final int FLAG_DEDUCIBLE_NAME = 8;
    private final PDOMLinkage linkage;
    private final int record;
    private String fName;

    public PDOMInclude(PDOMLinkage pdom, int record) {
        this.linkage = pdom;
        this.record = record;
    }

    public PDOMInclude(PDOMLinkage linkage, IASTPreprocessorIncludeStatement include, PDOMFile containerFile, PDOMFile targetFile) throws CoreException {
        boolean deducible_name;
        this.linkage = linkage;
        this.record = linkage.getDB().malloc(30);
        IASTName name = include.getName();
        char[] nameChars = name.getSimpleID();
        IASTFileLocation loc = name.getFileLocation();
        if (loc != null) {
            linkage.getDB().put3ByteUnsignedInt(this.record + 24, loc.getNodeOffset());
            linkage.getDB().putShort(this.record + 27, (short)loc.getNodeLength());
        }
        Database db = linkage.getDB();
        if (targetFile != null) {
            db.putInt(this.record + 0, targetFile.getRecord());
        }
        int rec = (deducible_name = PDOMInclude.isDeducibleName(targetFile, nameChars)) ? nameChars.length : db.newString(nameChars).getRecord();
        db.putInt(this.record + 20, rec);
        this.setFlag(this.encodeFlags(include, deducible_name));
        this.setIncludedBy(containerFile);
    }

    private byte encodeFlags(IASTPreprocessorIncludeStatement include, boolean deducible_name) {
        byte flags = 0;
        if (include.isSystemInclude()) {
            flags = (byte)(flags | 1);
        }
        if (!include.isActive()) {
            flags = (byte)(flags | 2);
        } else if (include.isResolvedByHeuristics()) {
            flags = (byte)(flags | 4);
        }
        if (deducible_name) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        if (this.isResolved()) {
            this.removeThisFromIncludedByChain();
        }
        Database db = this.linkage.getDB();
        if ((this.getFlag() & 8) == 0) {
            int rec = db.getInt(this.record + 20);
            db.getString(rec).delete();
        }
        db.free(this.record);
    }

    private void removeThisFromIncludedByChain() throws CoreException {
        PDOMInclude prevInclude = this.getPrevInIncludedBy();
        PDOMInclude nextInclude = this.getNextInIncludedBy();
        if (prevInclude != null) {
            prevInclude.setNextInIncludedBy(nextInclude);
        } else {
            ((PDOMFile)this.getIncludes()).setFirstIncludedBy(nextInclude);
        }
        if (nextInclude != null) {
            nextInclude.setPrevInIncludedBy(prevInclude);
        }
    }

    public IIndexFragmentFile getIncludes() throws CoreException {
        int rec = this.linkage.getDB().getInt(this.record + 0);
        return rec != 0 ? new PDOMFile(this.linkage, rec) : null;
    }

    private static boolean isDeducibleName(PDOMFile includedFile, char[] name) throws CoreException {
        if (includedFile == null) {
            return false;
        }
        String s = includedFile.getLocation().getURI().getPath();
        int pos = s.length() - name.length;
        if (pos < 0) {
            return false;
        }
        int i = 0;
        while (i < name.length) {
            if (s.charAt(pos) != name[i]) {
                return false;
            }
            ++i;
            ++pos;
        }
        return true;
    }

    public IIndexFile getIncludedBy() throws CoreException {
        int rec = this.linkage.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMFile(this.linkage, rec) : null;
    }

    private void setIncludedBy(PDOMFile includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.linkage.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getNextInIncludes() throws CoreException {
        int rec = this.linkage.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.linkage, rec) : null;
    }

    public void setNextInIncludes(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.linkage.getDB().putInt(this.record + 8, rec);
    }

    public PDOMInclude getNextInIncludedBy() throws CoreException {
        int rec = this.linkage.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMInclude(this.linkage, rec) : null;
    }

    public void setNextInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.linkage.getDB().putInt(this.record + 12, rec);
    }

    public PDOMInclude getPrevInIncludedBy() throws CoreException {
        int rec = this.getPrevInIncludedByRecord();
        return rec != 0 ? new PDOMInclude(this.linkage, rec) : null;
    }

    int getPrevInIncludedByRecord() throws CoreException {
        return this.linkage.getDB().getInt(this.record + 16);
    }

    public void setPrevInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.linkage.getDB().putInt(this.record + 16, rec);
    }

    public IIndexFileLocation getIncludedByLocation() throws CoreException {
        return this.getIncludedBy().getLocation();
    }

    public IIndexFileLocation getIncludesLocation() throws CoreException {
        IIndexFragmentFile includes = this.getIncludes();
        return includes != null ? includes.getLocation() : null;
    }

    public IIndexFragment getFragment() {
        return this.linkage.getPDOM();
    }

    private void setFlag(byte flag) throws CoreException {
        this.linkage.getDB().putByte(this.record + 29, flag);
    }

    private int getFlag() throws CoreException {
        return this.linkage.getDB().getByte(this.record + 29);
    }

    public boolean isSystemInclude() throws CoreException {
        return (this.getFlag() & 1) != 0;
    }

    public boolean isActive() throws CoreException {
        return (this.getFlag() & 2) == 0;
    }

    public boolean isResolved() throws CoreException {
        return this.linkage.getDB().getInt(this.record + 0) != 0;
    }

    public boolean isResolvedByHeuristics() throws CoreException {
        return (this.getFlag() & 4) != 0;
    }

    public int getNameOffset() throws CoreException {
        return this.linkage.getDB().get3ByteUnsignedInt(this.record + 24);
    }

    public int getNameLength() throws CoreException {
        return this.linkage.getDB().getShort(this.record + 27) & 0xFFFF;
    }

    public String getFullName() throws CoreException {
        if (this.fName == null) {
            Database db = this.linkage.getDB();
            if ((this.getFlag() & 8) == 0) {
                int rec = db.getInt(this.record + 20);
                this.fName = db.getString(rec).getString();
            } else {
                String path = this.getIncludes().getLocation().getURI().getPath();
                int nameLength = db.getInt(this.record + 20);
                this.fName = path.substring(Math.max(path.length() - nameLength, 0));
            }
        }
        return this.fName;
    }

    public String getName() throws CoreException {
        String fullName = this.getFullName();
        int idx = Math.max(fullName.lastIndexOf(47), fullName.lastIndexOf(92));
        return fullName.substring(idx + 1);
    }

    public void convertToUnresolved() throws CoreException {
        if (this.isResolved()) {
            Database db = this.linkage.getDB();
            int flag = this.getFlag();
            if ((flag & 8) != 0) {
                int rec = db.newString(this.getFullName()).getRecord();
                db.putInt(this.record + 20, rec);
                this.setFlag((byte)(flag & 0xFFFFFFF7));
            }
            db.putInt(this.record + 0, 0);
        }
    }
}

