/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexMacroContainer;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMMacroContainer
extends PDOMNamedNode
implements IIndexMacroContainer,
IPDOMBinding {
    private static final int FIRST_DEF_OFFSET = 12;
    private static final int FIRST_REF_OFFSET = 16;
    protected static final int RECORD_SIZE = 20;

    public PDOMMacroContainer(PDOMLinkage linkage, char[] name) throws CoreException {
        super(linkage, (PDOMNode)linkage, name);
    }

    PDOMMacroContainer(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    public int getNodeType() {
        return 5;
    }

    protected int getRecordSize() {
        return 20;
    }

    public boolean isOrphaned() throws CoreException {
        Database db = this.getDB();
        return db.getInt(this.record + 12) == 0 && db.getInt(this.record + 16) == 0;
    }

    public void addDefinition(PDOMMacro name) throws CoreException {
        PDOMMacro first = this.getFirstDefinition();
        if (first != null) {
            first.setPrevInContainer(name);
            name.setNextInContainer(first);
        }
        this.setFirstDefinition(name);
    }

    public void addReference(PDOMMacroReferenceName name) throws CoreException {
        PDOMMacroReferenceName first = this.getFirstReference();
        if (first != null) {
            first.setPrevInContainer(name);
            name.setNextInContainer(first);
        }
        this.setFirstReference(name);
    }

    public PDOMMacro getFirstDefinition() throws CoreException {
        int namerec = this.getDB().getInt(this.record + 12);
        return namerec != 0 ? new PDOMMacro((PDOMLinkage)this.getLinkage(), namerec) : null;
    }

    void setFirstDefinition(PDOMMacro macro) throws CoreException {
        int namerec = macro != null ? macro.getRecord() : 0;
        this.getDB().putInt(this.record + 12, namerec);
    }

    public PDOMMacroReferenceName getFirstReference() throws CoreException {
        int namerec = this.getDB().getInt(this.record + 16);
        return namerec != 0 ? new PDOMMacroReferenceName((PDOMLinkage)this.getLinkage(), namerec) : null;
    }

    void setFirstReference(PDOMMacroReferenceName nextName) throws CoreException {
        int namerec = nextName != null ? nextName.getRecord() : 0;
        this.getDB().putInt(this.record + 16, namerec);
    }

    public IIndexMacro[] getDefinitions() throws CoreException {
        ArrayList<PDOMMacro> macros = new ArrayList<PDOMMacro>();
        PDOMMacro macro = this.getFirstDefinition();
        while (macro != null) {
            macros.add(macro);
            macro = macro.getNextInContainer();
        }
        return macros.toArray(new IIndexMacro[macros.size()]);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        if (linkage != null) {
            linkage.removeMacroContainer(this);
        }
        super.delete(linkage);
    }

    public int getBindingConstant() {
        return 5;
    }

    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    public IIndexScope getScope() {
        return null;
    }

    public boolean hasDeclaration() throws CoreException {
        return false;
    }

    public boolean hasDefinition() throws CoreException {
        return this.getDB().getInt(this.record + 12) != 0;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public boolean isFileLocal() throws CoreException {
        return false;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return CharArrayUtils.EMPTY;
        }
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PDOMMacroContainer.class)) {
            return this;
        }
        return null;
    }
}

