/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNamedNode
extends PDOMNode {
    private static final int NAME = 8;
    protected static final int RECORD_SIZE = 12;
    private char[] fName;

    public PDOMNamedNode(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    public PDOMNamedNode(PDOMLinkage linkage, PDOMNode parent, char[] name) throws CoreException {
        super(linkage, parent);
        this.fName = name;
        Database db = linkage.getDB();
        db.putInt(this.record + 8, name != null ? db.newString(name).getRecord() : 0);
    }

    protected PDOMNamedNode(Database db, char[] name) throws CoreException {
        super(db);
        this.fName = name;
        db.putInt(this.record + 8, name != null ? db.newString(name).getRecord() : 0);
    }

    protected abstract int getRecordSize();

    public IString getDBName() throws CoreException {
        return PDOMNamedNode.getDBName(this.getDB(), this.record);
    }

    public static IString getDBName(Database db, int record) throws CoreException {
        int namerec = db.getInt(record + 8);
        return db.getString(namerec);
    }

    public char[] getNameCharArray() throws CoreException {
        if (this.fName != null) {
            return this.fName;
        }
        this.fName = this.getDBName().getChars();
        return this.fName;
    }

    public boolean hasName(char[] name) throws CoreException {
        if (this.fName != null) {
            return Arrays.equals(this.fName, name);
        }
        return this.getDBName().equals(name);
    }

    protected void updateName(char[] nameCharArray) throws CoreException {
        if (this.fName != null && CharArrayUtils.equals(this.fName, nameCharArray)) {
            return;
        }
        IString name = this.getDBName();
        if (!name.equals(nameCharArray)) {
            name.delete();
            Database db = this.getDB();
            db.putInt(this.record + 8, db.newString(nameCharArray).getRecord());
        }
        this.fName = nameCharArray;
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        Database db = this.getDB();
        int namerec = db.getInt(this.record + 8);
        if (namerec != 0) {
            db.free(namerec);
        }
        super.delete(linkage);
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public IIndexFragmentBinding getParentBinding() throws CoreException {
        PDOMNode parent = this.getParentNode();
        if (parent instanceof IIndexBinding) {
            return (IIndexFragmentBinding)((Object)parent);
        }
        return null;
    }

    public final IIndexFragmentBinding getOwner() {
        try {
            return this.getParentBinding();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

