/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPArgumentList {
    public static int putArguments(PDOMNode parent, ICPPTemplateArgument[] templateArguments) throws CoreException {
        int block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(templateArguments.length, 511);
        int p = block = db.malloc(2 + 8 * len);
        db.putShort(p, (short)len);
        p += 2;
        int i = 0;
        while (i < len) {
            PDOMNode type;
            ICPPTemplateArgument arg = templateArguments[i];
            boolean isNonType = arg.isNonTypeValue();
            if (isNonType) {
                type = linkage.addType(parent, arg.getTypeOfNonTypeValue());
                db.putInt(p, type == null ? 0 : type.getRecord());
                int valueRec = PDOMValue.store(db, linkage, arg.getNonTypeValue());
                db.putInt(p + 4, valueRec);
            } else {
                type = linkage.addType(parent, arg.getTypeValue());
                db.putInt(p, type == null ? 0 : type.getRecord());
            }
            ++i;
            p += 8;
        }
        return block;
    }

    public static void clearArguments(PDOMNode parent, int record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        int p = record + 2;
        int i = 0;
        while (i < len) {
            int typeRec = db.getInt(p);
            if (typeRec != 0) {
                IType t = (IType)((Object)linkage.getNode(typeRec));
                linkage.deleteType(t, parent.getRecord());
            }
            int nonTypeValueRec = db.getInt(p + 4);
            PDOMValue.delete(db, nonTypeValueRec);
            p += 8;
            ++i;
        }
        db.free(record);
    }

    public static ICPPTemplateArgument[] getArguments(PDOMNode parent, int rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        if (len == 0) {
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        rec += 2;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[len];
        int i = 0;
        while (i < len) {
            int typeRec = db.getInt(rec);
            IType type = typeRec == 0 ? new CPPBasicType(-1, 0) : (IType)((Object)linkage.getNode(typeRec));
            int nonTypeValRec = db.getInt(rec + 4);
            if (nonTypeValRec != 0) {
                IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
                result[i] = new CPPTemplateArgument(val, type);
            } else {
                result[i] = new CPPTemplateArgument(type);
            }
            rec += 8;
            ++i;
        }
        return result;
    }
}

