/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumeration
extends PDOMCPPBinding
implements IEnumeration,
IIndexType {
    private static final int FIRST_ENUMERATOR = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCPPEnumeration(PDOMLinkage linkage, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumeration.getNameCharArray());
    }

    public PDOMCPPEnumeration(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 15;
    }

    public IEnumerator[] getEnumerators() throws DOMException {
        try {
            ArrayList<PDOMCPPEnumerator> enums = new ArrayList<PDOMCPPEnumerator>();
            PDOMCPPEnumerator enumerator = this.getFirstEnumerator();
            while (enumerator != null) {
                enums.add(enumerator);
                enumerator = enumerator.getNextEnumerator();
            }
            IEnumerator[] enumerators = enums.toArray(new IEnumerator[enums.size()]);
            int n = enumerators.length;
            int i = 0;
            while (i < n / 2) {
                IEnumerator tmp = enumerators[i];
                enumerators[i] = enumerators[n - 1 - i];
                enumerators[n - 1 - i] = tmp;
                ++i;
            }
            return enumerators;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    private PDOMCPPEnumerator getFirstEnumerator() throws CoreException {
        int value = this.getDB().getInt(this.record + 28);
        return value != 0 ? new PDOMCPPEnumerator((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void addEnumerator(PDOMCPPEnumerator enumerator) throws CoreException {
        PDOMCPPEnumerator first = this.getFirstEnumerator();
        enumerator.setNextEnumerator(first);
        this.getDB().putInt(this.record + 28, enumerator.getRecord());
    }

    public boolean isSameType(IType type) {
        block6: {
            IEnumeration etype;
            block7: {
                PDOMNode node;
                if (type instanceof ITypedef) {
                    return type.isSameType(this);
                }
                if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
                    return node.getRecord() == this.getRecord();
                }
                if (!(type instanceof IEnumeration)) break block6;
                etype = (IEnumeration)type;
                char[] nchars = etype.getNameCharArray();
                if (nchars.length == 0) {
                    nchars = ASTTypeUtil.createNameForAnonymous(etype);
                }
                if (nchars != null && CharArrayUtils.equals(nchars, this.getNameCharArray())) break block7;
                return false;
            }
            try {
                return this.isSameOwner(this.getOwner(), etype.getOwner());
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

