/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumeration;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumerator
extends PDOMCPPBinding
implements IEnumerator {
    private static final int ENUMERATION = 28;
    private static final int NEXT_ENUMERATOR = 32;
    private static final int VALUE = 36;
    protected static final int RECORD_SIZE = 40;

    public PDOMCPPEnumerator(PDOMLinkage linkage, PDOMNode parent, IEnumerator enumerator, PDOMCPPEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumerator.getNameCharArray());
        Database db = this.getDB();
        db.putInt(this.record + 28, enumeration.getRecord());
        this.storeValue(db, enumerator);
        enumeration.addEnumerator(this);
    }

    public PDOMCPPEnumerator(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 40;
    }

    public int getNodeType() {
        return 16;
    }

    private void storeValue(Database db, IEnumerator enumerator) throws CoreException {
        IValue value = enumerator.getValue();
        if (value != null) {
            Long val = value.numericalValue();
            db.putInt(this.record + 36, val == null ? -1 : val.intValue());
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IEnumerator) {
            this.storeValue(this.getDB(), (IEnumerator)newBinding);
        }
    }

    public PDOMCPPEnumerator getNextEnumerator() throws CoreException {
        int value = this.getDB().getInt(this.record + 32);
        return value != 0 ? new PDOMCPPEnumerator((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void setNextEnumerator(PDOMCPPEnumerator enumerator) throws CoreException {
        int value = enumerator != null ? enumerator.getRecord() : 0;
        this.getDB().putInt(this.record + 32, value);
    }

    public IType getType() throws DOMException {
        try {
            return new PDOMCPPEnumeration((PDOMLinkage)this.getLinkage(), this.getDB().getInt(this.record + 28));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IValue getValue() {
        try {
            int val = this.getDB().getInt(this.record + 36);
            return Value.create(val);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Value.UNKNOWN;
        }
    }
}

