/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionSpecialization
extends PDOMCPPSpecialization
implements ICPPFunction {
    private static final int NUM_PARAMS = 40;
    private static final int FIRST_PARAM = 44;
    private static final int FUNCTION_TYPE = 48;
    protected static final int EXCEPTION_SPEC = 52;
    protected static final int ANNOTATION = 56;
    protected static final int RECORD_SIZE = 57;

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPFunction function, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)function), specialized);
        Database db = this.getDB();
        try {
            PDOMNode typeNode;
            ICPPFunctionType ft = function.getType();
            if (ft != null && (typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, ft)) != null) {
                db.putInt(this.record + 48, typeNode.getRecord());
            }
            ft = this.getType();
            IParameter[] params = function.getParameters();
            IType[] paramTypes = ft.getParameterTypes();
            ICPPFunction sFunc = (ICPPFunction)((ICPPSpecialization)((Object)function)).getSpecializedBinding();
            IParameter[] sParams = sFunc.getParameters();
            IType[] sParamTypes = sFunc.getType().getParameterTypes();
            int length = Math.min(sParams.length, params.length);
            db.putInt(this.record + 40, length);
            int i = 0;
            while (i < length) {
                int typeRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0;
                IType type = i < sParamTypes.length ? sParamTypes[i] : null;
                PDOMCPPParameter sParam = new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), (PDOMNode)this, sParams[i], type);
                this.setFirstParameter(new PDOMCPPParameterSpecialization((PDOMLinkage)this.getLinkage(), (PDOMNode)this, (ICPPParameter)params[i], sParam, typeRecord));
                ++i;
            }
            db.putByte(this.record + 56, PDOMCPPAnnotation.encodeAnnotation(function));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        try {
            int typelist = 0;
            if (!(function instanceof ICPPMethod) || !((ICPPMethod)function).isImplicit()) {
                typelist = PDOMCPPTypeList.putTypes(this, function.getExceptionSpecification());
            }
            db.putInt(this.record + 52, typelist);
        }
        catch (DOMException dOMException) {}
    }

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, int bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 57;
    }

    public int getNodeType() {
        return 34;
    }

    public PDOMCPPParameterSpecialization getFirstParameter() throws CoreException {
        int rec = this.getDB().getInt(this.record + 44);
        return rec != 0 ? new PDOMCPPParameterSpecialization((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameterSpecialization param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.getDB().putInt(this.record + 44, rec);
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 2);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.getDB().getInt(this.record + 40);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameterSpecialization param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public ICPPFunctionType getType() throws DOMException {
        try {
            int offset = this.getDB().getInt(this.record + 48);
            return offset == 0 ? null : new PDOMCPPFunctionType((PDOMLinkage)this.getLinkage(), offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 1);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 6);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 5);
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    public IType[] getExceptionSpecification() throws DOMException {
        try {
            int rec = this.getPDOM().getDB().getInt(this.record + 52);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

