/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPFunctionType
extends PDOMCFunctionType
implements ICPPFunctionType {
    private static IType FALLBACK_RETURN_TYPE = new CPPBasicType(1, 0);
    static ICPPFunctionType FALLBACK = new ICPPFunctionType(){

        @Deprecated
        public IPointerType getThisType() {
            return null;
        }

        public boolean isConst() {
            return false;
        }

        public boolean isVolatile() {
            return false;
        }

        public IType[] getParameterTypes() throws DOMException {
            return IType.EMPTY_TYPE_ARRAY;
        }

        public IType getReturnType() throws DOMException {
            return FALLBACK_RETURN_TYPE;
        }

        public boolean isSameType(IType type) {
            return this == type || type.isSameType(this);
        }

        public Object clone() {
            return this;
        }
    };
    private static final int CV = 16;
    private static final int RECORD_SIZE = 17;
    IPointerType thisType;
    int cvq = -1;

    protected PDOMCPPFunctionType(PDOMLinkage linkage, int offset) {
        super(linkage, offset);
    }

    protected PDOMCPPFunctionType(PDOMLinkage linkage, PDOMNode parent, ICPPFunctionType type) throws CoreException {
        super(linkage, parent, type);
        this.setcvq(type.isConst(), type.isVolatile());
    }

    private void setcvq(boolean isConst, boolean isVolatile) throws CoreException {
        int v = (isConst ? 1 : 0) + (isVolatile ? 2 : 0);
        this.getDB().putByte(this.record + 16, (byte)v);
    }

    @Deprecated
    public IPointerType getThisType() {
        return null;
    }

    public final boolean isConst() {
        this.readcvq();
        return (this.cvq & 1) != 0;
    }

    private void readcvq() {
        if (this.cvq == -1) {
            try {
                this.cvq = this.getDB().getByte(this.record + 16);
            }
            catch (CoreException coreException) {
                this.cvq = 0;
            }
        }
    }

    public final boolean isVolatile() {
        this.readcvq();
        return (this.cvq & 2) != 0;
    }

    protected int getRecordSize() {
        return 17;
    }

    public boolean isSameType(IType type) {
        if (type instanceof ICPPFunctionType && super.isSameType(type)) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
        }
        return false;
    }

    public int getNodeType() {
        return 44;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

