/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethod
extends PDOMCPPFunction
implements ICPPMethod {
    private static final int ANNOTATION1 = 49;
    protected static final int RECORD_SIZE = 50;
    private static final int CV_OFFSET = 5;
    private byte annotation1 = (byte)-1;

    public PDOMCPPMethod(PDOMLinkage linkage, PDOMNode parent, ICPPMethod method) throws CoreException, DOMException {
        super(linkage, parent, method, true);
        Database db = this.getDB();
        try {
            this.annotation1 = PDOMCPPAnnotation.encodeExtraAnnotation(method);
            db.putByte(this.record + 49, this.annotation1);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPMethod(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)newBinding;
            super.update(linkage, newBinding);
            this.annotation1 = (byte)-1;
            try {
                byte annot = PDOMCPPAnnotation.encodeExtraAnnotation(method);
                this.getDB().putByte(this.record + 49, annot);
                this.annotation1 = annot;
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    protected int getRecordSize() {
        return 50;
    }

    public int getNodeType() {
        return 10;
    }

    public boolean isVirtual() throws DOMException {
        return this.getBit(this.getAnnotation1(), 0);
    }

    protected byte getAnnotation1() {
        if (this.annotation1 == -1) {
            this.annotation1 = this.getByte(this.record + 49);
        }
        return this.annotation1;
    }

    public boolean isPureVirtual() throws DOMException {
        return this.getBit(this.getAnnotation1(), 4);
    }

    public boolean isDestructor() {
        return this.getBit(this.getAnnotation1(), 1);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isImplicit() {
        return this.getBit(this.getAnnotation1(), 2);
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public int getVisibility() throws DOMException {
        return PDOMCPPAnnotation.getVisibility(this.getAnnotation());
    }

    public ICPPClassType getClassOwner() throws DOMException {
        return (ICPPClassType)((Object)this.getOwner());
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public boolean isConst() {
        return this.getBit(this.getAnnotation1(), 5);
    }

    public boolean isVolatile() {
        return this.getBit(this.getAnnotation1(), 6);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTFieldReference) {
                ICPPASTFieldReference fr = (ICPPASTFieldReference)parent;
                if ((parent = parent.getParent()) instanceof IASTFunctionCallExpression) {
                    if (fr.isPointerDereference()) {
                        return 16;
                    }
                    IType type = fr.getFieldOwner().getExpressionType();
                    if (type instanceof ICPPReferenceType) {
                        return 16;
                    }
                }
            } else if (parent instanceof IASTIdExpression && parent.getParent() instanceof IASTFunctionCallExpression) {
                return 16;
            }
        }
        return 0;
    }

    public IType[] getExceptionSpecification() throws DOMException {
        if (this.isImplicit()) {
            return ClassTypeHelper.getInheritedExceptionSpecification(this);
        }
        return super.getExceptionSpecification();
    }
}

