/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameterSpecialization
extends PDOMCPPSpecialization
implements ICPPParameter {
    private static final int NEXT_PARAM = 40;
    private static final int TYPE = 44;
    protected static final int RECORD_SIZE = 48;

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, int typeRecord) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = this.getDB();
        db.putInt(this.record + 40, 0);
        db.putInt(this.record + 44, typeRecord);
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, IType type) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = this.getDB();
        db.putInt(this.record + 40, 0);
        try {
            if (type == null) {
                type = param.getType();
            }
            if (type != null) {
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, type);
                db.putInt(this.record + 44, typeNode != null ? typeNode.getRecord() : 0);
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 48;
    }

    public int getNodeType() {
        return 32;
    }

    public void setNextParameter(PDOMCPPParameterSpecialization nextParam) throws CoreException {
        int rec = nextParam != null ? nextParam.getRecord() : 0;
        this.getDB().putInt(this.record + 40, rec);
    }

    public PDOMCPPParameterSpecialization getNextParameter() throws CoreException {
        int rec = this.getDB().getInt(this.record + 40);
        return rec != 0 ? new PDOMCPPParameterSpecialization((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getInt(this.record + 44));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private ICPPParameter getParameter() {
        return (ICPPParameter)this.getSpecializedBinding();
    }

    public boolean hasDefaultValue() {
        return this.getParameter().hasDefaultValue();
    }

    public boolean isAuto() throws DOMException {
        return this.getParameter().isAuto();
    }

    public boolean isRegister() throws DOMException {
        return this.getParameter().isRegister();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }
}

