/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.index.CPPPointerToMemberTypeClone;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMPointerType;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPPointerToMemberType
extends PDOMPointerType
implements ICPPPointerToMemberType {
    private static final int TYPE = 13;
    private static final int RECORD_SIZE = 17;

    public PDOMCPPPointerToMemberType(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    public PDOMCPPPointerToMemberType(PDOMLinkage linkage, PDOMNode parent, ICPPPointerToMemberType type) throws CoreException {
        super(linkage, parent, type);
        PDOMNode targetTypeNode;
        Database db = this.getDB();
        IType ct = type.getMemberOfClass();
        int typeRec = 0;
        if (ct != null && (targetTypeNode = this.getLinkage().addType(this, ct)) != null) {
            typeRec = targetTypeNode.getRecord();
        }
        db.putInt(this.record + 13, typeRec);
    }

    protected int getRecordSize() {
        return 17;
    }

    public int getNodeType() {
        return 18;
    }

    public IType getMemberOfClass() {
        try {
            int rec = this.getDB().getInt(this.record + 13);
            return (IType)((Object)this.getLinkage().getNode(rec));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isSameType(IType o) {
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPPointerToMemberType)) {
            return false;
        }
        if (!super.isSameType(o)) {
            return false;
        }
        ICPPPointerToMemberType pt = (ICPPPointerToMemberType)o;
        IType cls = pt.getMemberOfClass();
        if (cls != null) {
            return cls.isSameType(this.getMemberOfClass());
        }
        return false;
    }

    public Object clone() {
        return new CPPPointerToMemberTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getMemberOfClass(), this.record);
        super.delete(linkage);
    }
}

