/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateParameterMap {
    public static int putMap(PDOMNode parent, ICPPTemplateParameterMap map) throws CoreException {
        int block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        Integer[] keys = map.getAllParameterPositions();
        int len = Math.min(keys.length, 341);
        int p = block = db.malloc(2 + 12 * len);
        db.putShort(p, (short)len);
        p += 2;
        int i = 0;
        while (i < len) {
            PDOMNode type;
            Integer paramPos = keys[i];
            db.putInt(p, paramPos);
            p += 4;
            ICPPTemplateArgument arg = map.getArgument(paramPos);
            if (arg.isNonTypeValue()) {
                type = linkage.addType(parent, arg.getTypeOfNonTypeValue());
                db.putInt(p, type == null ? 0 : type.getRecord());
                int valueRec = PDOMValue.store(db, linkage, arg.getNonTypeValue());
                db.putInt(p + 4, valueRec);
            } else {
                type = linkage.addType(parent, arg.getTypeValue());
                db.putInt(p, type == null ? 0 : type.getRecord());
            }
            p += 8;
            ++i;
        }
        return block;
    }

    public static void clearMap(PDOMNode parent, int rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        rec += 2;
        int i = 0;
        while (i < len) {
            int typeRec = db.getInt(rec += 4);
            if (typeRec != 0) {
                IType t = (IType)((Object)linkage.getNode(typeRec));
                linkage.deleteType(t, parent.getRecord());
            }
            int nonTypeValueRec = db.getInt(rec + 4);
            PDOMValue.delete(db, nonTypeValueRec);
            rec += 8;
            ++i;
        }
        db.free(rec);
    }

    public static CPPTemplateParameterMap getMap(PDOMNode parent, int rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        if (len == 0) {
            return CPPTemplateParameterMap.EMPTY;
        }
        rec += 2;
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            CPPTemplateArgument arg;
            int parPos = db.getInt(rec);
            int typeRec = db.getInt(rec + 4);
            IType type = typeRec == 0 ? new CPPBasicType(-1, 0) : (IType)((Object)linkage.getNode(typeRec));
            int nonTypeValRec = db.getInt(rec + 8);
            if (nonTypeValRec != 0) {
                IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
                arg = new CPPTemplateArgument(val, type);
            } else {
                arg = new CPPTemplateArgument(type);
            }
            result.put(parPos, (ICPPTemplateArgument)arg);
            rec += 12;
            ++i;
        }
        return result;
    }
}

