/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTypeList {
    protected static final int NODE_SIZE = 4;

    PDOMCPPTypeList() {
    }

    public static int putTypes(PDOMNode parent, IType[] types) throws CoreException {
        int block;
        if (types == null) {
            return 0;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(types.length, 1023);
        int p = block = db.malloc(2 + 4 * len);
        db.putShort(p, (short)len);
        p += 2;
        int i = 0;
        while (i < len) {
            PDOMNode pdomType;
            IType type = types[i];
            int rec = 0;
            if (type != null && (pdomType = linkage.addType(parent, type)) != null) {
                rec = pdomType.getRecord();
            }
            db.putInt(p, rec);
            ++i;
            p += 4;
        }
        return block;
    }

    public static IType[] getTypes(PDOMNode parent, int rec) throws CoreException {
        if (rec == 0) {
            return null;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        if (len == 0) {
            return IType.EMPTY_TYPE_ARRAY;
        }
        Assert.isTrue((len >= 0 && len <= 1023 ? 1 : 0) != 0);
        rec += 2;
        IType[] result = new IType[len];
        int i = 0;
        while (i < len) {
            int typeRec = db.getInt(rec);
            if (typeRec != 0) {
                result[i] = (IType)((Object)linkage.getNode(typeRec));
            }
            ++i;
            rec += 4;
        }
        return result;
    }

    public static void clearTypes(PDOMNode parent, int record) throws CoreException {
        if (record == 0) {
            return;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 1023 ? 1 : 0) != 0);
        int p = record + 2;
        int i = 0;
        while (i < len) {
            int typeRec = db.getInt(p);
            IType t = (IType)((Object)linkage.getNode(typeRec));
            linkage.deleteType(t, parent.getRecord());
            ++i;
            p += 4;
        }
        db.free(record);
    }
}

