/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateTypeParameter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMTemplateParameterArray {
    public static int putArray(Database db, IPDOMCPPTemplateParameter[] params) throws CoreException {
        int block;
        int len = Math.min(params.length, 511);
        int p = block = db.malloc(2 + 8 * len);
        db.putShort(p, (short)len);
        p += 2;
        int i = 0;
        while (i < len) {
            IPDOMCPPTemplateParameter elem = params[i];
            db.putInt(p, elem == null ? 0 : elem.getRecord());
            ++i;
            p += 4;
        }
        return block;
    }

    public static IPDOMCPPTemplateParameter[] getArray(PDOMNode parent, int rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        if (len == 0) {
            return IPDOMCPPTemplateParameter.EMPTY_ARRAY;
        }
        rec += 2;
        IPDOMCPPTemplateParameter[] result = new IPDOMCPPTemplateParameter[len];
        int i = 0;
        while (i < len) {
            int nodeRec = db.getInt(rec);
            rec += 4;
            result[i] = nodeRec == 0 ? null : (IPDOMCPPTemplateParameter)((Object)linkage.getNode(nodeRec));
            ++i;
        }
        return result;
    }

    public static IPDOMCPPTemplateParameter[] createPDOMTemplateParameters(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateParameter[] origParams) throws CoreException, DOMException {
        IPDOMCPPTemplateParameter[] params = new IPDOMCPPTemplateParameter[origParams.length];
        int i = 0;
        while (i < origParams.length) {
            params[i] = PDOMTemplateParameterArray.createPDOMTemplateParameter(linkage, parent, origParams[i]);
            ++i;
        }
        return params;
    }

    public static IPDOMCPPTemplateParameter createPDOMTemplateParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateParameter origParam) throws CoreException, DOMException {
        PDOMCPPBinding param = null;
        if (origParam instanceof ICPPTemplateNonTypeParameter) {
            param = new PDOMCPPTemplateNonTypeParameter(linkage, parent, (ICPPTemplateNonTypeParameter)origParam);
        } else if (origParam instanceof ICPPTemplateTypeParameter) {
            param = new PDOMCPPTemplateTypeParameter(linkage, parent, (ICPPTemplateTypeParameter)origParam);
        } else if (origParam instanceof ICPPTemplateTemplateParameter) {
            param = new PDOMCPPTemplateTemplateParameter(linkage, parent, (ICPPTemplateTemplateParameter)origParam);
        }
        return param;
    }
}

