/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTargetAction
extends SelectionListenerAction {
    private final Shell shell;

    public BuildTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("BuildTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("BuildTargetAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_BUILD);
        this.setEnabled(false);
    }

    public void run() {
        if (this.canBuild()) {
            IMakeTarget[] targets = this.getSelectedElements().toArray(new IMakeTarget[0]);
            TargetBuild.buildTargets(this.shell, targets);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canBuild();
    }

    private boolean canBuild() {
        List<?> elements = this.getSelectedElements();
        for (Object element : elements) {
            if (element instanceof IMakeTarget) continue;
            return false;
        }
        return elements.size() > 0;
    }

    private List<?> getSelectedElements() {
        return this.getStructuredSelection().toList();
    }
}

