/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "c/c++";
    public static final int C_SOURCEROOT = 1000;

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return CoreModel.getDefault().create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public String getParentHandle(String handle) {
        ICElement cElement = (ICElement)this.getObjectForHandle(handle);
        if (cElement != null && cElement.getParent() != null) {
            return CDTStructureBridge.getHandleForElement(cElement.getParent());
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        ICElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof ICElement && (element = (ICElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                ICElement[] children = parent.getChildren();
                ArrayList<String> childHandles = new ArrayList<String>();
                int i = 0;
                while (i < children.length) {
                    String childHandle = this.getHandleIdentifier(children[i]);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++i;
                }
                AbstractContextStructureBridge parentBridge = ContextCorePlugin.getDefault().getStructureBridge(this.parentContentType);
                if (parentBridge != null && parentBridge instanceof ResourceStructureBridge && element.getElementType() < 61 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (CModelException cModelException) {}
        }
        return Collections.emptyList();
    }

    public static ICElement getElementForHandle(String handle) {
        return CoreModel.create((String)handle);
    }

    public Object getObjectForHandle(String handle) {
        return CDTStructureBridge.getElementForHandle(handle);
    }

    public static String getHandleForElement(ICElement element) {
        return element.getHandleIdentifier();
    }

    public String getHandleIdentifier(Object object) {
        Object adapter;
        if (object instanceof ICElement) {
            return CDTStructureBridge.getHandleForElement((ICElement)object);
        }
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(ICElement.class)) instanceof ICElement) {
            return CDTStructureBridge.getHandleForElement((ICElement)adapter);
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof ICElement) {
            return ((ICElement)object).getElementName();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        ICElement element = (ICElement)this.getObjectForHandle(handle);
        return (element instanceof IMethod || element instanceof IFunction) && element.exists();
    }

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            object = ((IResource)object).getAdapter(ICElement.class);
        }
        boolean accepts = object instanceof ICElement && !(object instanceof IBinary) || object instanceof IWorkingSet;
        return accepts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (!(object instanceof IWorkingSet)) return true;
        try {
            IWorkingSet workingSet = (IWorkingSet)object;
            IAdaptable[] elements = workingSet.getElements();
            int i = 0;
            while (true) {
                if (i >= elements.length) {
                    return true;
                }
                IAdaptable adaptable = elements[i];
                IInteractionElement element = ContextCorePlugin.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                if (element.getInterest().isInteresting()) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDocument(String handle) {
        ICElement element = (ICElement)this.getObjectForHandle(handle);
        return element instanceof ITranslationUnit;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        ITranslationUnit translationUnit;
        int charStart;
        block11: {
            charStart = 0;
            if (object instanceof ConcreteMarker) {
                IMarker iMarker = ((ConcreteMarker)object).getMarker();
            }
            if (!(object instanceof IMarker)) {
                return null;
            }
            IMarker marker = (IMarker)object;
            Integer attribute = marker.getAttribute("charStart", 0);
            if (attribute instanceof Integer) {
                charStart = attribute;
            }
            try {
                translationUnit = null;
                IResource resource = marker.getResource();
                if (!(resource instanceof IFile)) break block11;
                IFile file = (IFile)resource;
                if (CoreModel.isValidTranslationUnitName(null, (String)file.getName())) {
                    ICElement element = CoreModel.getDefault().create(file);
                    translationUnit = CoreModel.getDefault().createTranslationUnitFrom(element.getCProject(), element.getPath());
                    break block11;
                }
                return null;
            }
            catch (CModelException ex) {
                if (ex.doesNotExist()) {
                    StatusHandler.fail((IStatus)ex.getStatus());
                }
                return null;
            }
        }
        if (translationUnit != null) {
            ICElement cElement = translationUnit.getElementAtOffset(charStart);
            if (cElement != null) {
                if (cElement instanceof IInclude) {
                    cElement = cElement.getParent().getParent();
                }
                return cElement.getElementName();
            }
            return null;
        }
        return null;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            ICElement element = (ICElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 11: 
                case 12: 
                case 30: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 60: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 61: 
                case 62: 
                case 65: 
                case 70: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 80: {
                    ITranslationUnit cu = (ITranslationUnit)element.getAncestor(60);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                int priority;
                IMarker curr = markers[i];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

