/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.errorparsers.xlc;

import java.util.regex.Matcher;
import org.eclipse.cdt.core.errorparsers.AbstractErrorParser;
import org.eclipse.cdt.core.errorparsers.ErrorPattern;
import org.eclipse.cdt.errorparsers.xlc.Messages;

public class XlcErrorParser
extends AbstractErrorParser {
    private static final ErrorPattern[] patterns = new ErrorPattern[]{new ErrorPattern(Messages.XlcErrorParser_MacroRedefinitionErrorPattern, 6, 5, -1, 0, -1){

        public int getSeverity(Matcher matcher) {
            return 1;
        }

        public String getDesc(Matcher matcher) {
            return " Macro name " + matcher.group(4) + " originally defined in file " + this.getFileName(matcher);
        }
    }, new ErrorPattern(Messages.XlcErrorParser_CompilerErrorPattern, 1, 2, 5, 0, -1){

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(4);
            if (warningGroup != null) {
                if (warningGroup.equals(Messages.XlcErrorParser_FlagUnrecoverable)) {
                    return 3;
                }
                if (warningGroup.equals(Messages.XlcErrorParser_FlagSevere) || warningGroup.equals(Messages.XlcErrorParser_FlagError)) {
                    return 2;
                }
                if (warningGroup.equals(Messages.XlcErrorParser_FlagWarning)) {
                    return 1;
                }
                if (warningGroup.equals(Messages.XlcErrorParser_FlagInfo)) {
                    return 0;
                }
            }
            return 0;
        }
    }, new ErrorPattern(Messages.XlcErrorParser_LinkerErrorPattern, 0, 0, 3, 0, -1){

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(2);
            if (warningGroup != null) {
                if (warningGroup.indexOf(Messages.XlcErrorParser_LinkerWarning) >= 0) {
                    return 1;
                }
                if (warningGroup.indexOf(Messages.XlcErrorParser_LinkerError) >= 0) {
                    return 2;
                }
            }
            return 0;
        }
    }, new ErrorPattern(Messages.XlcErrorParser_LinkerErrorPattern2, 0, 0, 2, 0, -1){

        public int getSeverity(Matcher matcher) {
            return 2;
        }
    }, new ErrorPattern(Messages.XlcErrorParser_LinkerInfoPattern, 0, 0, 2, 0, -1){

        public int getSeverity(Matcher matcher) {
            return 0;
        }
    }};

    public XlcErrorParser() {
        super(patterns);
    }
}

