/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerFileSICollector
implements IScannerInfoCollector3,
IScannerInfoCollectorCleaner {
    private static final int INCLUDE_PATH = 1;
    private static final int QUOTE_INCLUDE_PATH = 2;
    private static final int INCLUDE_FILE = 3;
    private static final int MACROS_FILE = 4;
    public static final String COLLECTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".PerFileSICollector";
    private static final String CC_ELEM = "compilerCommand";
    private static final String ID_ATTR = "id";
    private static final String FILE_TYPE_ATTR = "fileType";
    private static final String APPLIES_TO_ATTR = "appliesToFiles";
    private static final String FILE_ELEM = "file";
    private static final String PATH_ATTR = "path";
    private IProject project;
    private InfoContext context;
    private ScannerInfoData sid;
    private ProjectScannerInfo psi = null;
    private final Map<IResource, Integer> siChangedForFileMap;
    private final List<Integer> siChangedForCommandIdList;
    private final SortedSet<Integer> freeCommandIdPool;
    private int commandIdCounter = 0;
    private final Object fLock = new Object();

    public PerFileSICollector() {
        this.sid = new ScannerInfoData();
        this.siChangedForFileMap = new HashMap<IResource, Integer>();
        this.siChangedForCommandIdList = new ArrayList<Integer>();
        this.freeCommandIdPool = new TreeSet<Integer>();
    }

    @Override
    public void setProject(IProject project) {
        this.setInfoContext(new InfoContext(project));
    }

    @Override
    public void setInfoContext(InfoContext context) {
        this.project = context.getProject();
        this.context = context;
        try {
            DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, context, this.sid);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    protected InfoContext getInfoContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else {
            if (resource instanceof Integer) {
                Object object = this.fLock;
                synchronized (object) {
                    this.addScannerInfo((Integer)resource, scannerInfo);
                }
                return;
            }
            if (!(resource instanceof IFile)) {
                errorMessage = "resource is not an IFile";
            } else if (((IFile)resource).getProject() == null) {
                errorMessage = "project is null";
            } else if (!((IFile)resource).getProject().equals((Object)this.project)) {
                errorMessage = "wrong project";
            }
        }
        if (errorMessage != null) {
            TraceUtil.outputError("PerFileSICollector.contributeToScannerConfig : ", errorMessage);
            return;
        }
        IFile file = (IFile)resource;
        Object object = this.fLock;
        synchronized (object) {
            for (ScannerInfoTypes type : scannerInfo.keySet()) {
                if (type.equals(ScannerInfoTypes.COMPILER_COMMAND)) {
                    List commands = (List)scannerInfo.get(type);
                    Iterator j = commands.iterator();
                    while (j.hasNext()) {
                        this.addCompilerCommand(file, (CCommandDSC)j.next());
                    }
                    continue;
                }
                this.addScannerInfo(type, (List)scannerInfo.get(type));
            }
        }
    }

    private void addScannerInfo(Integer commandId, Map scannerInfo) {
        assert (Thread.holdsLock(this.fLock));
        CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(commandId);
        if (cmd != null) {
            List<String> siItem = (List<String>)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
            cmd.setSymbols(siItem);
            siItem = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
            siItem = CygpathTranslator.translateIncludePaths(this.project, siItem);
            siItem = CCommandDSC.makeRelative(this.project, siItem);
            cmd.setIncludes(siItem);
            siItem = (List<String>)scannerInfo.get(ScannerInfoTypes.QUOTE_INCLUDE_PATHS);
            siItem = CygpathTranslator.translateIncludePaths(this.project, siItem);
            siItem = CCommandDSC.makeRelative(this.project, siItem);
            cmd.setQuoteIncludes(siItem);
            cmd.setDiscovered(true);
        }
    }

    private void addCompilerCommand(IFile file, CCommandDSC cmd) {
        assert (Thread.holdsLock(this.fLock));
        ArrayList existingCommands = new ArrayList(this.sid.commandIdCommandMap.values());
        int index = existingCommands.indexOf(cmd);
        if (index != -1) {
            cmd = (CCommandDSC)existingCommands.get(index);
        } else {
            int commandId = -1;
            if (!this.freeCommandIdPool.isEmpty()) {
                Integer freeCommandId = this.freeCommandIdPool.first();
                this.freeCommandIdPool.remove(freeCommandId);
                commandId = freeCommandId;
            } else {
                commandId = ++this.commandIdCounter;
            }
            cmd.setCommandId(commandId);
            this.sid.commandIdCommandMap.put(cmd.getCommandIdAsInteger(), cmd);
        }
        this.generateFileDelta(file, cmd);
    }

    private void generateFileDelta(IFile file, CCommandDSC cmd) {
        assert (Thread.holdsLock(this.fLock));
        Integer commandId = cmd.getCommandIdAsInteger();
        Integer oldCommandId = (Integer)this.sid.fileToCommandIdMap.get(file);
        if (oldCommandId != null && oldCommandId.equals(commandId)) {
            this.siChangedForFileMap.remove(file);
        } else {
            this.siChangedForFileMap.put((IResource)file, commandId);
        }
    }

    private void applyFileDeltas() {
        assert (Thread.holdsLock(this.fLock));
        for (IFile iFile : this.siChangedForFileMap.keySet()) {
            Integer commandId = this.siChangedForFileMap.get(iFile);
            if (commandId == null) continue;
            HashSet<IFile> fileSet = (HashSet<IFile>)this.sid.commandIdToFilesMap.get(commandId);
            if (fileSet == null) {
                fileSet = new HashSet<IFile>();
                this.sid.commandIdToFilesMap.put(commandId, fileSet);
                CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(commandId);
                if (cmd != null) {
                    cmd.resolveOptions(this.project);
                }
            }
            if (!fileSet.add(iFile)) continue;
            boolean change = true;
            Integer oldCommandId = (Integer)this.sid.fileToCommandIdMap.get(iFile);
            if (oldCommandId != null) {
                if (oldCommandId.equals(commandId)) {
                    change = false;
                } else {
                    Set oldFileSet = (Set)this.sid.commandIdToFilesMap.get(oldCommandId);
                    if (oldFileSet != null) {
                        oldFileSet.remove(iFile);
                    }
                }
            }
            if (!change) continue;
            this.sid.fileToCommandIdMap.put(iFile, commandId);
        }
        this.generateProjectScannerInfo();
    }

    private void generateProjectScannerInfo() {
        assert (Thread.holdsLock(this.fLock));
        this.psi = new ProjectScannerInfo();
        this.psi.includePaths = this.getAllIncludePaths(1);
        this.psi.quoteIncludePaths = this.getAllIncludePaths(2);
        this.psi.includeFiles = this.getAllIncludePaths(3);
        this.psi.macrosFiles = this.getAllIncludePaths(4);
        this.psi.definedSymbols = this.getAllSymbols();
    }

    private void removeUnusedCommands() {
        assert (Thread.holdsLock(this.fLock));
        for (Map.Entry entry : this.sid.commandIdToFilesMap.entrySet()) {
            Integer cmdId = (Integer)entry.getKey();
            Set fileSet = (Set)entry.getValue();
            if (!fileSet.isEmpty()) continue;
            this.freeCommandIdPool.add(cmdId);
        }
        for (Integer cmdId : this.freeCommandIdPool) {
            this.sid.commandIdCommandMap.remove(cmdId);
            this.sid.commandIdToFilesMap.remove(cmdId);
        }
        while (!this.freeCommandIdPool.isEmpty()) {
            Integer last = this.freeCommandIdPool.last();
            if (last != this.commandIdCounter) break;
            this.freeCommandIdPool.remove(last);
            --this.commandIdCounter;
        }
    }

    private void addScannerInfo(ScannerInfoTypes type, List delta) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeMessages.getString("ScannerInfoCollector.Processing"), 100);
        monitor.subTask(MakeMessages.getString("ScannerInfoCollector.Processing"));
        ArrayList<IResource> changedResources = null;
        Object object = this.fLock;
        synchronized (object) {
            if (this.scannerInfoChanged()) {
                this.applyFileDeltas();
                this.removeUnusedCommands();
                changedResources = new ArrayList<IResource>(this.siChangedForFileMap.keySet());
                this.siChangedForFileMap.clear();
            }
            this.siChangedForCommandIdList.clear();
        }
        monitor.worked(50);
        if (changedResources != null) {
            try {
                monitor.subTask(String.valueOf(MakeMessages.getString("ScannerInfoCollector.Updating")) + this.project.getName());
                IDiscoveredPathManager.IDiscoveredPathInfo pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context);
                if (!(pathInfo instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo)) {
                    pathInfo = this.createPathInfoObject();
                }
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), changedResources);
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }
        monitor.worked(50);
        monitor.done();
    }

    @Override
    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        return new PerFileDiscoveredPathInfo();
    }

    private boolean scannerInfoChanged() {
        assert (Thread.holdsLock(this.fLock));
        return !this.siChangedForFileMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CCommandDSC> getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        ArrayList<CCommandDSC> rv = new ArrayList<CCommandDSC>();
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError("PerProjectSICollector.getCollectedScannerInfo : ", errorMessage);
            return rv;
        }
        if (this.project.equals((Object)((IResource)resource).getProject())) {
            if (type.equals(ScannerInfoTypes.COMPILER_COMMAND)) {
                Object object = this.fLock;
                synchronized (object) {
                    for (Integer n : this.sid.commandIdCommandMap.keySet()) {
                        Set fileSet = (Set)this.sid.commandIdToFilesMap.get(n);
                        if (fileSet == null || fileSet.isEmpty()) continue;
                        rv.add((CCommandDSC)this.sid.commandIdCommandMap.get(n));
                    }
                }
            }
            if (type.equals(ScannerInfoTypes.UNDISCOVERED_COMPILER_COMMAND)) {
                Object object = this.fLock;
                synchronized (object) {
                    if (this.scannerInfoChanged()) {
                        if (this.siChangedForCommandIdList.isEmpty()) {
                            for (IFile iFile : this.siChangedForFileMap.keySet()) {
                                Integer cmdId = this.siChangedForFileMap.get(iFile);
                                if (cmdId == null || this.siChangedForCommandIdList.contains(cmdId)) continue;
                                this.siChangedForCommandIdList.add(cmdId);
                            }
                        }
                        Collections.sort(this.siChangedForCommandIdList);
                        for (Integer n : this.siChangedForCommandIdList) {
                            CCommandDSC command = (CCommandDSC)this.sid.commandIdCommandMap.get(n);
                            rv.add(command);
                        }
                    }
                }
            }
        }
        return rv;
    }

    @Override
    public void deleteAllPaths(IResource resource) {
    }

    @Override
    public void deleteAllSymbols(IResource resource) {
    }

    @Override
    public void deletePath(IResource resource, String path) {
    }

    @Override
    public void deleteSymbol(IResource resource, String symbol) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll(IResource resource) {
        if (resource.equals((Object)this.project)) {
            Object object = this.fLock;
            synchronized (object) {
                this.siChangedForFileMap.clear();
                Set changedFiles = this.sid.fileToCommandIdMap.keySet();
                for (IFile file : changedFiles) {
                    this.siChangedForFileMap.put((IResource)file, null);
                }
                this.sid = new ScannerInfoData();
                this.psi = null;
                this.commandIdCounter = 0;
                this.freeCommandIdPool.clear();
            }
        }
    }

    private Map<IResource, PathInfo> calculatePathInfoMap() {
        PathInfo fpi;
        assert (Thread.holdsLock(this.fLock));
        HashMap<IResource, PathInfo> map = new HashMap<IResource, PathInfo>(this.sid.fileToCommandIdMap.size() + 1);
        for (Map.Entry entry : this.sid.fileToCommandIdMap.entrySet()) {
            CCommandDSC cmd;
            IFile file = (IFile)entry.getKey();
            if (file == null || (cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(entry.getValue())) == null) continue;
            fpi = PerFileSICollector.createFilePathInfo(cmd);
            map.put((IResource)file, fpi);
        }
        if (this.project != null) {
            if (this.psi == null) {
                this.generateProjectScannerInfo();
            }
            fpi = new PathInfo(this.psi.includePaths, this.psi.quoteIncludePaths, this.psi.definedSymbols, this.psi.includeFiles, this.psi.macrosFiles);
            map.put((IResource)this.project, fpi);
        }
        return map;
    }

    private static PathInfo createFilePathInfo(CCommandDSC cmd) {
        IPath[] includes = PerFileSICollector.stringListToPathArray(cmd.getIncludes());
        IPath[] quotedIncludes = PerFileSICollector.stringListToPathArray(cmd.getQuoteIncludes());
        IPath[] incFiles = PerFileSICollector.stringListToPathArray(cmd.getIncludeFile());
        IPath[] macroFiles = PerFileSICollector.stringListToPathArray(cmd.getImacrosFile());
        List<String> symbols = cmd.getSymbols();
        HashMap<String, String> definedSymbols = new HashMap<String, String>(symbols.size());
        for (String symbol : symbols) {
            String key = ScannerConfigUtil.getSymbolKey(symbol);
            String value = ScannerConfigUtil.getSymbolValue(symbol);
            definedSymbols.put(key, value);
        }
        return new PathInfo(includes, quotedIncludes, definedSymbols, incFiles, macroFiles);
    }

    private CCommandDSC getCommand(IPath path) {
        try {
            IFile file = this.project.getWorkspace().getRoot().getFile(path);
            return this.getCommand(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CCommandDSC getCommand(IFile file) {
        Integer cmdId;
        CCommandDSC cmd = null;
        if (file != null && (cmdId = (Integer)this.sid.fileToCommandIdMap.get(file)) != null) {
            cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
        }
        return cmd;
    }

    private IPath[] getAllIncludePaths(int type) {
        ArrayList<String> allIncludes = new ArrayList<String>();
        for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
            CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
            if (!cmd.isDiscovered()) continue;
            List<String> discovered = null;
            switch (type) {
                case 1: {
                    discovered = cmd.getIncludes();
                    break;
                }
                case 2: {
                    discovered = cmd.getQuoteIncludes();
                    break;
                }
                case 3: {
                    discovered = cmd.getIncludeFile();
                    break;
                }
                case 4: {
                    discovered = cmd.getImacrosFile();
                }
            }
            for (String include : discovered) {
                if (allIncludes.contains(include)) continue;
                allIncludes.add(include);
            }
        }
        return PerFileSICollector.stringListToPathArray(allIncludes);
    }

    private static IPath[] stringListToPathArray(List<String> discovered) {
        ArrayList<Path> allIncludes = new ArrayList<Path>(discovered.size());
        for (String include : discovered) {
            if (allIncludes.contains(include)) continue;
            allIncludes.add(new Path(include));
        }
        return allIncludes.toArray(new IPath[allIncludes.size()]);
    }

    private Map<String, String> getAllSymbols() {
        assert (Thread.holdsLock(this.fLock));
        HashMap<String, String> symbols = new HashMap<String, String>();
        for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
            CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
            if (!cmd.isDiscovered()) continue;
            List<String> discovered = cmd.getSymbols();
            for (String symbol : discovered) {
                String key = ScannerConfigUtil.getSymbolKey(symbol);
                String value = ScannerConfigUtil.getSymbolValue(symbol);
                symbols.put(key, value);
            }
        }
        return symbols;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PerFileDiscoveredPathInfo
    implements IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 {
        private PerFileDiscoveredPathInfo() {
        }

        @Override
        public IProject getProject() {
            return PerFileSICollector.this.project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPath[] getIncludePaths() {
            IPath[] quotepaths;
            IPath[] includepaths;
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                includepaths = PerFileSICollector.this.getAllIncludePaths(1);
                quotepaths = PerFileSICollector.this.getAllIncludePaths(2);
            }
            if (quotepaths == null || quotepaths.length == 0) {
                return includepaths;
            }
            if (includepaths == null || includepaths.length == 0) {
                return quotepaths;
            }
            ArrayList<IPath> result = new ArrayList<IPath>(includepaths.length + quotepaths.length);
            result.addAll(Arrays.asList(includepaths));
            result.addAll(Arrays.asList(quotepaths));
            return result.toArray(new IPath[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getSymbols() {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                return PerFileSICollector.this.getAllSymbols();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPath[] getIncludePaths(IPath path) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
                if (cmd != null && cmd.isDiscovered()) {
                    return PerFileSICollector.stringListToPathArray(cmd.getIncludes());
                }
                if (PerFileSICollector.this.psi == null) {
                    PerFileSICollector.this.generateProjectScannerInfo();
                }
                return ((PerFileSICollector)PerFileSICollector.this).psi.includePaths;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPath[] getQuoteIncludePaths(IPath path) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
                if (cmd != null && cmd.isDiscovered()) {
                    return PerFileSICollector.stringListToPathArray(cmd.getQuoteIncludes());
                }
                if (PerFileSICollector.this.psi == null) {
                    PerFileSICollector.this.generateProjectScannerInfo();
                }
                return ((PerFileSICollector)PerFileSICollector.this).psi.quoteIncludePaths;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getSymbols(IPath path) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
                if (cmd != null && cmd.isDiscovered()) {
                    List<String> symbols = cmd.getSymbols();
                    HashMap<String, String> definedSymbols = new HashMap<String, String>(symbols.size());
                    for (String symbol : symbols) {
                        String key = ScannerConfigUtil.getSymbolKey(symbol);
                        String value = ScannerConfigUtil.getSymbolValue(symbol);
                        definedSymbols.put(key, value);
                    }
                    return definedSymbols;
                }
                if (PerFileSICollector.this.psi == null) {
                    PerFileSICollector.this.generateProjectScannerInfo();
                }
                return ((PerFileSICollector)PerFileSICollector.this).psi.definedSymbols;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPath[] getIncludeFiles(IPath path) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
                if (cmd != null) {
                    return PerFileSICollector.stringListToPathArray(cmd.getIncludeFile());
                }
                if (PerFileSICollector.this.psi == null) {
                    PerFileSICollector.this.generateProjectScannerInfo();
                }
                return ((PerFileSICollector)PerFileSICollector.this).psi.includeFiles;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPath[] getMacroFiles(IPath path) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
                if (cmd != null) {
                    return PerFileSICollector.stringListToPathArray(cmd.getImacrosFile());
                }
                if (PerFileSICollector.this.psi == null) {
                    PerFileSICollector.this.generateProjectScannerInfo();
                }
                return ((PerFileSICollector)PerFileSICollector.this).psi.macrosFiles;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                return PerFileSICollector.this.sid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty(IPath path) {
            boolean rc = true;
            IResource resource = PerFileSICollector.this.project.getWorkspace().getRoot().findMember(path);
            if (resource != null) {
                if (resource instanceof IFile) {
                    rc = PerFileSICollector.this.getCommand((IFile)resource) == null;
                } else if (resource instanceof IProject) {
                    Object object = PerFileSICollector.this.fLock;
                    synchronized (object) {
                        rc = PerFileSICollector.this.psi == null || PerFileSICollector.this.psi.isEmpty();
                    }
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<IResource, PathInfo> getPathInfoMap() {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                return PerFileSICollector.this.calculatePathInfoMap();
            }
        }
    }

    private static class ProjectScannerInfo {
        IPath[] includePaths;
        IPath[] quoteIncludePaths;
        IPath[] includeFiles;
        IPath[] macrosFiles;
        Map<String, String> definedSymbols;

        private ProjectScannerInfo() {
        }

        public boolean isEmpty() {
            return this.includePaths.length == 0 && this.quoteIncludePaths.length == 0 && this.includeFiles.length == 0 && this.macrosFiles.length == 0 && this.definedSymbols.size() == 0;
        }
    }

    private class ScannerInfoData
    implements IDiscoveredPathManager.IDiscoveredScannerInfoSerializable {
        private final Map<Integer, Set<IFile>> commandIdToFilesMap;
        private final Map<IFile, Integer> fileToCommandIdMap;
        private final Map<Integer, CCommandDSC> commandIdCommandMap = new LinkedHashMap<Integer, CCommandDSC>();

        public ScannerInfoData() {
            this.fileToCommandIdMap = new HashMap<IFile, Integer>();
            this.commandIdToFilesMap = new HashMap<Integer, Set<IFile>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(Element collectorElem) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                Document doc = collectorElem.getOwnerDocument();
                ArrayList<Integer> commandIds = new ArrayList<Integer>(this.commandIdCommandMap.keySet());
                Collections.sort(commandIds);
                for (Integer commandId : commandIds) {
                    CCommandDSC command = this.commandIdCommandMap.get(commandId);
                    Element cmdElem = doc.createElement(PerFileSICollector.CC_ELEM);
                    collectorElem.appendChild(cmdElem);
                    cmdElem.setAttribute(PerFileSICollector.ID_ATTR, commandId.toString());
                    cmdElem.setAttribute(PerFileSICollector.FILE_TYPE_ATTR, command.appliesToCPPFileType() ? "c++" : "c");
                    command.serialize(cmdElem);
                    Element filesElem = doc.createElement(PerFileSICollector.APPLIES_TO_ATTR);
                    cmdElem.appendChild(filesElem);
                    Set<IFile> files = this.commandIdToFilesMap.get(commandId);
                    if (files == null) continue;
                    Iterator<IFile> j = files.iterator();
                    while (j.hasNext()) {
                        Element fileElem = doc.createElement(PerFileSICollector.FILE_ELEM);
                        IFile file = j.next();
                        IPath path = file.getProjectRelativePath();
                        fileElem.setAttribute(PerFileSICollector.PATH_ATTR, path.toString());
                        filesElem.appendChild(fileElem);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deserialize(Element collectorElem) {
            Object object = PerFileSICollector.this.fLock;
            synchronized (object) {
                Node child = collectorElem.getFirstChild();
                while (child != null) {
                    if (child.getNodeName().equals(PerFileSICollector.CC_ELEM)) {
                        Element cmdElem = (Element)child;
                        boolean cppFileType = cmdElem.getAttribute(PerFileSICollector.FILE_TYPE_ATTR).equals("c++");
                        CCommandDSC command = new CCommandDSC(cppFileType, PerFileSICollector.this.project);
                        command.setCommandId(Integer.parseInt(cmdElem.getAttribute(PerFileSICollector.ID_ATTR)));
                        command.deserialize(cmdElem);
                        NodeList appliesList = cmdElem.getElementsByTagName(PerFileSICollector.APPLIES_TO_ATTR);
                        if (appliesList.getLength() > 0) {
                            Element appliesElem = (Element)appliesList.item(0);
                            NodeList fileList = appliesElem.getElementsByTagName(PerFileSICollector.FILE_ELEM);
                            int i = 0;
                            while (i < fileList.getLength()) {
                                Element fileElem = (Element)fileList.item(i);
                                String fileName = fileElem.getAttribute(PerFileSICollector.PATH_ATTR);
                                IFile file = PerFileSICollector.this.project.getFile(fileName);
                                PerFileSICollector.this.addCompilerCommand(file, command);
                                ++i;
                            }
                            PerFileSICollector.this.applyFileDeltas();
                        }
                    }
                    child = child.getNextSibling();
                }
            }
        }

        public String getCollectorId() {
            return COLLECTOR_ID;
        }
    }
}

