/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.dataviewer;

import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.examples.dsf.dataviewer.DataGeneratorWithThread;
import org.eclipse.cdt.examples.dsf.dataviewer.IDataGenerator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncDataViewer
implements IStructuredContentProvider,
IDataGenerator.Listener {
    private final TableViewer fViewer;
    private final IDataGenerator fDataGenerator;

    public SyncDataViewer(TableViewer viewer, IDataGenerator generator) {
        this.fViewer = viewer;
        this.fDataGenerator = generator;
        this.fDataGenerator.addListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        Query<Integer> countQuery = new Query<Integer>(){

            protected void execute(DataRequestMonitor<Integer> rm) {
                SyncDataViewer.this.fDataGenerator.getCount(rm);
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)countQuery);
        int count = 0;
        try {
            count = (Integer)countQuery.get();
        }
        catch (Exception exception) {
            return new Object[0];
        }
        Object[] elements = new Object[count];
        int i = 0;
        while (i < count) {
            final int index = i;
            Query<String> valueQuery = new Query<String>(){

                protected void execute(DataRequestMonitor<String> rm) {
                    SyncDataViewer.this.fDataGenerator.getValue(index, rm);
                }
            };
            ImmediateExecutor.getInstance().execute((Runnable)valueQuery);
            try {
                elements[i] = valueQuery.get();
            }
            catch (Exception exception) {
                elements[i] = "error";
            }
            ++i;
        }
        return elements;
    }

    public void dispose() {
        this.fDataGenerator.removeListener(this);
    }

    @Override
    public void countChanged() {
        this.refreshViewer();
    }

    @Override
    public void valuesChanged(Set<Integer> indexes) {
        this.refreshViewer();
    }

    private void refreshViewer() {
        Display display = this.fViewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!SyncDataViewer.this.fViewer.getControl().isDisposed()) {
                    SyncDataViewer.this.fViewer.refresh();
                }
            }
        });
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        shell.setLayoutData((Object)data);
        Font font = new Font((Device)display, "Courier", 10, 0);
        TableViewer tableViewer = new TableViewer((Composite)shell, 2048);
        tableViewer.getControl().setLayoutData((Object)data);
        final DataGeneratorWithThread generator = new DataGeneratorWithThread();
        SyncDataViewer contentProvider = new SyncDataViewer(tableViewer, generator);
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        tableViewer.setInput(new Object());
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        Query<Object> shutdownQuery = new Query<Object>(){

            protected void execute(DataRequestMonitor<Object> rm) {
                generator.shutdown((RequestMonitor)rm);
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)shutdownQuery);
        try {
            shutdownQuery.get();
        }
        catch (Exception exception) {}
        font.dispose();
        display.dispose();
    }
}

